/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.discontinuous_beacon_beams;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.minecraft.class_1269;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import net.sssubtlety.discontinuous_beacon_beams.Config;
import net.sssubtlety.discontinuous_beacon_beams.DiscontinuousBeaconBeams;
import net.sssubtlety.discontinuous_beacon_beams.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FeatureControl {
    @Nullable
    private static final Config CONFIG_INSTANCE;
    private static boolean verifySave;
    private static ImmutableSet<class_2248> beamHidingBlocks;

    private static class_1269 onConfigSave(ConfigHolder<Config> holder, Config config) {
        if (verifySave && FeatureControl.invalidateConfig("Error saving config")) {
            verifySave = false;
            holder.save();
            verifySave = true;
            return class_1269.field_5814;
        }
        return class_1269.field_21466;
    }

    private static class_1269 onConfigLoad(ConfigHolder<Config> holder, Config config) {
        if (FeatureControl.invalidateConfig("Error loading config")) {
            holder.save();
        }
        return class_1269.field_21466;
    }

    private static boolean invalidateConfig(String errPrefix) {
        class_3545<ImmutableSet<class_2248>, Optional<StringBuilder>> buildResult = FeatureControl.buildBlockSetFromStrings(CONFIG_INSTANCE == null ? Defaults.beam_hiding_blocks : FeatureControl.CONFIG_INSTANCE.beam_hiding_blocks);
        beamHidingBlocks = (ImmutableSet)buildResult.method_15442();
        Optional errBuilder = (Optional)buildResult.method_15441();
        if (errBuilder.isPresent()) {
            DiscontinuousBeaconBeams.LOGGER.error("{}: {}", (Object)errPrefix, errBuilder.get());
            return true;
        }
        return false;
    }

    private static class_3545<@NotNull ImmutableSet<class_2248>, Optional<StringBuilder>> buildBlockSetFromStrings(List<String> strings) {
        ImmutableSet.Builder blockSetBuilder = ImmutableSet.builder();
        LinkedList errIds = new LinkedList();
        for (String string : strings) {
            class_2960 id = class_2960.method_60654((String)string);
            class_7923.field_41175.method_17966(id).ifPresentOrElse(arg_0 -> ((ImmutableSet.Builder)blockSetBuilder).add(arg_0), () -> errIds.add(id.toString()));
        }
        int errCount = errIds.size();
        StringBuilder errBuilder = null;
        if (errCount > 0) {
            errBuilder = new StringBuilder();
            if (errCount == 1) {
                errBuilder.append("No item found for id '").append((String)errIds.get(0)).append("'").append(System.lineSeparator());
            } else {
                errBuilder.append("No items found for ids:").append(System.lineSeparator());
                for (String errId : errIds) {
                    errBuilder.append("- ").append(errId).append(System.lineSeparator());
                }
            }
        }
        return new class_3545((Object)blockSetBuilder.build(), Optional.ofNullable(errBuilder));
    }

    public static void init() {
    }

    public static boolean doesHideBeam(class_2248 block) {
        return beamHidingBlocks.contains((Object)block);
    }

    public static boolean hidingBlocksToggleBeams() {
        return CONFIG_INSTANCE == null ? true : FeatureControl.CONFIG_INSTANCE.hiding_blocks_toggle_beams;
    }

    public static boolean rememberColorWhenHidingBlocksEnableBeams() {
        return CONFIG_INSTANCE == null ? true : FeatureControl.CONFIG_INSTANCE.remember_color_when_hiding_blocks_enable_beams;
    }

    public static boolean stainableBlocksEnableBeams() {
        return CONFIG_INSTANCE == null ? true : FeatureControl.CONFIG_INSTANCE.stainable_blocks_enable_beams;
    }

    public static boolean rememberColorWhenStainableBlocksEnableBeams() {
        return CONFIG_INSTANCE == null ? true : FeatureControl.CONFIG_INSTANCE.remember_color_when_stainable_blocks_enable_beams;
    }

    public static boolean enableBeaconBeams() {
        return CONFIG_INSTANCE == null ? true : FeatureControl.CONFIG_INSTANCE.enable_beacon_beams;
    }

    public static boolean isConfigLoaded() {
        return CONFIG_INSTANCE != null;
    }

    static {
        verifySave = true;
        beamHidingBlocks = (ImmutableSet)FeatureControl.buildBlockSetFromStrings(Defaults.beam_hiding_blocks).method_15442();
        if (Util.isModLoaded("cloth-config", ">=7.0.72")) {
            ConfigHolder holder = AutoConfig.register(Config.class, GsonConfigSerializer::new);
            CONFIG_INSTANCE = (Config)holder.getConfig();
            FeatureControl.onConfigLoad((ConfigHolder<Config>)holder, CONFIG_INSTANCE);
            holder.registerLoadListener(FeatureControl::onConfigLoad);
            holder.registerSaveListener(FeatureControl::onConfigSave);
        } else {
            CONFIG_INSTANCE = null;
        }
    }

    public static interface Defaults {
        public static final List<String> beam_hiding_blocks = Lists.newArrayList((Object[])new String[]{class_7923.field_41175.method_10221((Object)class_2246.field_10033).toString(), class_7923.field_41175.method_10221((Object)class_2246.field_10285).toString()});
        public static final boolean hiding_blocks_toggle_beams = true;
        public static final boolean remember_color_when_hiding_blocks_enable_beams = true;
        public static final boolean stainable_blocks_enable_beams = true;
        public static final boolean remember_color_when_stainable_blocks_enable_beams = true;
        public static final boolean enable_beacon_beams = true;
    }
}

