/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.discontinuous_beacon_beams.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import java.util.List;
import net.minecraft.class_10633;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_4275;
import net.sssubtlety.discontinuous_beacon_beams.FeatureControl;
import net.sssubtlety.discontinuous_beacon_beams.mixin_helper.BeamSegmentMixinAccessor;
import net.sssubtlety.discontinuous_beacon_beams.mixin_helper.SpoofBlock;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_2580.class})
abstract class BeaconBlockEntityMixin
extends class_2586 {
    @Unique
    private static final int DEFAULT_COLOR = ((class_4275)class_2246.field_10327).method_10622().method_7787();
    @Unique
    private static final int UNMATCHABLE_DYE_COLOR = DEFAULT_COLOR - 1;
    @Unique
    @Nullable
    private Integer colorOverride;
    @Unique
    private boolean hasColor;
    @Unique
    private boolean beamIsVisible;
    @Shadow
    private final List<class_10633.class_2581> field_19178;

    private BeaconBlockEntityMixin() {
        super(null, null, null);
        throw new IllegalStateException("BeaconBlockEntityMixin's dummy constructor called!");
    }

    @ModifyExpressionValue(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;getBlock()Lnet/minecraft/block/Block;")})
    private static class_2248 updateBeamStateAndSpoofBlock(class_2248 original, class_1937 world, class_2338 pos, class_2680 unused, class_2580 beaconBlockEntity, @Share(value="togglingVisibility") LocalBooleanRef togglingVisibility) {
        if (!world.method_8608() || original == class_2246.field_9987) {
            return original;
        }
        return BeaconBlockEntityMixin.updateBeamStateAndSpoofBlockImpl((class_2248)original, (class_10633.class_2581)BeaconBlockEntityMixin.getTopSegment((class_2580)beaconBlockEntity), (BeaconBlockEntityMixin)((BeaconBlockEntityMixin)beaconBlockEntity), (LocalBooleanRef)togglingVisibility).block.orElse(original);
    }

    @ModifyArgs(method={"tick"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z"))
    private static void modifyBeamState(Args args, class_1937 world, class_2338 pos, class_2680 state, class_2580 beaconBlockEntity) {
        if (!FeatureControl.enableBeaconBeams() || BeaconBlockEntityMixin.getTopSegment(beaconBlockEntity) == null) {
            return;
        }
        BeamSegmentMixinAccessor beamSegment = (BeamSegmentMixinAccessor)args.get(0);
        BeaconBlockEntityMixin beaconBlockEntityMixin = (BeaconBlockEntityMixin)beaconBlockEntity;
        if (!beaconBlockEntityMixin.beamIsVisible) {
            beamSegment.discontinuous_beacon_beams$setInvisible();
        }
        if (beaconBlockEntityMixin.colorOverride != null) {
            beamSegment.discontinuous_beacon_beams$setColor(beaconBlockEntityMixin.colorOverride);
        }
    }

    @ModifyExpressionValue(method={"tick"}, allow=1, slice={@Slice(to=@At(value="INVOKE", target="Lnet/minecraft/block/entity/Beam$Segment;incrementHeight()V"))}, at={@At(value="INVOKE", target="Lnet/minecraft/block/entity/Beam$Segment;getArgb()I")})
    private static int mismatchColorIfTogglingVisibility(int original, @Share(value="togglingVisibility") LocalBooleanRef togglingVisibility) {
        return togglingVisibility.get() ? UNMATCHABLE_DYE_COLOR : original;
    }

    @Unique
    private static SpoofBlock updateBeamStateAndSpoofBlockImpl(class_2248 original, @Nullable class_10633.class_2581 beamSegment, BeaconBlockEntityMixin beaconBlockEntityMixin, LocalBooleanRef togglingVisibility) {
        if (beamSegment == null) {
            beaconBlockEntityMixin.hasColor = false;
            beaconBlockEntityMixin.beamIsVisible = true;
            return SpoofBlock.ORIGINAL;
        }
        if (!FeatureControl.enableBeaconBeams()) {
            return SpoofBlock.UN_STAINABLE;
        }
        togglingVisibility.set(false);
        boolean beamWasVisible = beaconBlockEntityMixin.beamIsVisible;
        if (beamWasVisible) {
            if (FeatureControl.doesHideBeam(original)) {
                beaconBlockEntityMixin.beamIsVisible = false;
                togglingVisibility.set(true);
                beaconBlockEntityMixin.colorOverride = beaconBlockEntityMixin.hasColor ? Integer.valueOf(beamSegment.method_10944()) : null;
                return SpoofBlock.STAINABLE;
            }
            if (original instanceof class_4275) {
                class_4275 stainable = (class_4275)original;
                beaconBlockEntityMixin.colorOverride = beaconBlockEntityMixin.hasColor ? null : Integer.valueOf(stainable.method_10622().method_7787());
                beaconBlockEntityMixin.hasColor = true;
            }
            return SpoofBlock.ORIGINAL;
        }
        if (FeatureControl.hidingBlocksToggleBeams() && FeatureControl.doesHideBeam(original)) {
            beaconBlockEntityMixin.beamIsVisible = true;
            togglingVisibility.set(true);
            if (FeatureControl.rememberColorWhenHidingBlocksEnableBeams()) {
                beaconBlockEntityMixin.colorOverride = beamSegment.method_10944();
            } else {
                beaconBlockEntityMixin.colorOverride = DEFAULT_COLOR;
                beaconBlockEntityMixin.hasColor = false;
            }
            return SpoofBlock.STAINABLE;
        }
        if (FeatureControl.stainableBlocksEnableBeams() && original instanceof class_4275) {
            class_4275 stainable = (class_4275)original;
            beaconBlockEntityMixin.beamIsVisible = true;
            togglingVisibility.set(true);
            beaconBlockEntityMixin.colorOverride = beaconBlockEntityMixin.hasColor && FeatureControl.rememberColorWhenStainableBlocksEnableBeams() ? null : Integer.valueOf(stainable.method_10622().method_7787());
            beaconBlockEntityMixin.hasColor = true;
        }
        return SpoofBlock.ORIGINAL;
    }

    @Unique
    @Nullable
    private static class_10633.class_2581 getTopSegment(class_2580 beaconBlockEntity) {
        BeaconBlockEntityMixin beaconBlockEntityMixin = (BeaconBlockEntityMixin)beaconBlockEntity;
        int size = beaconBlockEntityMixin.field_19178.size();
        return size < 1 ? null : beaconBlockEntityMixin.field_19178.get(size - 1);
    }
}

