/*
 * Decompiled with CFR 0.152.
 */
package de.arlomu.servergm;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Main
extends JavaPlugin
implements CommandExecutor,
TabCompleter,
Listener {
    private String prefix;
    private String msgSelf;
    private String msgOther;
    private String msgPlayerNotFound;
    private String msgInvalidGamemode;
    private String msgNoPermission;
    private String msgMustSpecifyPlayer;
    private String msgCommandDisabled;
    private String msgReloadSuccess;
    private String msgReloadNoPermission;
    private final Map<String, Boolean> enabledCommands = new HashMap<String, Boolean>();
    private boolean f3f4SwitcherEnabled;

    public void onEnable() {
        String[] cmds;
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        for (String cmd : cmds = new String[]{"gm", "gmc", "gms", "gma", "gmsp", "gmreload", "gamemode", "crea", "surv", "adven", "spec"}) {
            PluginCommand command = this.getCommand(cmd);
            if (command == null) continue;
            command.setExecutor((CommandExecutor)this);
            command.setTabCompleter((TabCompleter)this);
        }
    }

    private void loadConfig() {
        this.prefix = this.color(this.getConfig().getString("prefix", ""));
        this.msgSelf = this.color(this.getConfig().getString("messages.self"));
        this.msgOther = this.color(this.getConfig().getString("messages.other"));
        this.msgPlayerNotFound = this.color(this.getConfig().getString("messages.player_not_found"));
        this.msgInvalidGamemode = this.color(this.getConfig().getString("messages.invalid_gamemode"));
        this.msgNoPermission = this.color(this.getConfig().getString("messages.no_permission"));
        this.msgMustSpecifyPlayer = this.color(this.getConfig().getString("messages.must_specify_player"));
        this.msgCommandDisabled = this.color(this.getConfig().getString("messages.command_disabled"));
        this.msgReloadSuccess = this.color(this.getConfig().getString("messages.reload_success"));
        this.msgReloadNoPermission = this.color(this.getConfig().getString("messages.reload_no_permission"));
        this.enabledCommands.clear();
        for (String cmd : this.getConfig().getConfigurationSection("enabled_commands").getKeys(false)) {
            this.enabledCommands.put(cmd, this.getConfig().getBoolean("enabled_commands." + cmd, true));
        }
        this.f3f4SwitcherEnabled = this.getConfig().getBoolean("f3_f4_switcher_enabled", true);
    }

    private String color(String input) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)input);
    }

    private boolean isEnabled(String command) {
        return this.enabledCommands.getOrDefault(command, false);
    }

    private void send(CommandSender sender, String message) {
        sender.sendMessage(this.prefix + message);
    }

    private GameMode parseGamemode(String arg) {
        return switch (arg.toLowerCase()) {
            case "0", "s", "survival" -> GameMode.SURVIVAL;
            case "1", "c", "creative" -> GameMode.CREATIVE;
            case "2", "a", "adventure" -> GameMode.ADVENTURE;
            case "3", "sp", "spectator" -> GameMode.SPECTATOR;
            default -> null;
        };
    }

    private void setGamemode(CommandSender sender, GameMode mode, Player target, boolean isSelf, String command) {
        String perm = "servergm." + command + "." + (isSelf ? "self" : "other");
        if (!sender.hasPermission(perm) && !sender.hasPermission("servergm.all")) {
            this.send(sender, this.msgNoPermission);
            return;
        }
        target.setGameMode(mode);
        String modeName = mode.name().toLowerCase();
        if (isSelf) {
            this.send(sender, this.msgSelf.replace("%gamemode%", modeName));
        } else {
            this.send(sender, this.msgOther.replace("%spieler%", target.getName()).replace("%gamemode%", modeName));
            this.send((CommandSender)target, this.msgSelf.replace("%gamemode%", modeName));
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        GameMode mode;
        Player player;
        String command = cmd.getName().toLowerCase();
        if (command.equals("gmreload")) {
            if (!sender.hasPermission("servergm.reload")) {
                this.send(sender, this.msgReloadNoPermission);
                return true;
            }
            this.reloadConfig();
            this.loadConfig();
            this.send(sender, this.msgReloadSuccess);
            return true;
        }
        if (!this.isEnabled(command)) {
            this.send(sender, this.msgCommandDisabled);
            return true;
        }
        Player target = player = sender instanceof Player ? (Player)sender : null;
        boolean isSelf = true;
        if (command.equals("gm") || command.equals("gamemode") || command.equals("gammemode")) {
            if (args.length < 1) {
                this.send(sender, this.msgInvalidGamemode);
                return true;
            }
            mode = this.parseGamemode(args[0]);
            if (mode == null) {
                this.send(sender, this.msgInvalidGamemode);
                return true;
            }
            if (args.length >= 2) {
                target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    this.send(sender, this.msgPlayerNotFound);
                    return true;
                }
                isSelf = sender instanceof Player && ((Player)sender).equals((Object)target);
            } else if (!(sender instanceof Player)) {
                this.send(sender, this.msgMustSpecifyPlayer);
                return true;
            }
        } else {
            switch (command) {
                case "gmc": 
                case "crea": {
                    GameMode gameMode = GameMode.CREATIVE;
                    break;
                }
                case "gms": 
                case "surv": {
                    GameMode gameMode = GameMode.SURVIVAL;
                    break;
                }
                case "gma": 
                case "adven": {
                    GameMode gameMode = GameMode.ADVENTURE;
                    break;
                }
                case "gmsp": 
                case "spec": {
                    GameMode gameMode = GameMode.SPECTATOR;
                    break;
                }
                default: {
                    GameMode gameMode = mode = null;
                }
            }
            if (args.length >= 1) {
                target = Bukkit.getPlayer((String)args[0]);
                if (target == null) {
                    this.send(sender, this.msgPlayerNotFound);
                    return true;
                }
                isSelf = sender instanceof Player && ((Player)sender).equals((Object)target);
            }
        }
        this.setGamemode(sender, mode, target, isSelf, command);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        String command = cmd.getName().toLowerCase();
        if (!this.isEnabled(command)) {
            return Collections.emptyList();
        }
        if (command.equals("gm") || command.equals("gamemode") || command.equals("gammemode")) {
            if (args.length == 1) {
                return Arrays.asList("0", "1", "2", "3", "s", "c", "a", "sp");
            }
            if (args.length == 2) {
                return null;
            }
        } else if (args.length == 1) {
            return null;
        }
        return Collections.emptyList();
    }

    @EventHandler
    public void onGamemodeChange(PlayerGameModeChangeEvent event) {
        if (!this.f3f4SwitcherEnabled) {
            return;
        }
        Player player = event.getPlayer();
        GameMode newMode = event.getNewGameMode();
        event.setCancelled(true);
        player.performCommand("gm " + newMode.ordinal());
    }
}

