/*
 * Decompiled with CFR 0.152.
 */
package de.arlomu.servergm.Main;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public final class Main
extends JavaPlugin
implements CommandExecutor {
    private String prefix;
    private String msgSelf;
    private String msgOther;
    private Map<String, Boolean> enabledCommands = new HashMap();

    public void onEnable() {
        String[] cmds;
        this.saveDefaultConfig();
        this.loadConfig();
        for (String cmd : cmds = new String[]{"gm", "gmc", "gms", "gma", "gmsp"}) {
            this.getCommand(cmd).setExecutor((CommandExecutor)this);
        }
    }

    private void loadConfig() {
        this.prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("prefix", ""));
        this.msgSelf = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.self"));
        this.msgOther = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("messages.other"));
        for (String cmd : this.getConfig().getConfigurationSection("enabled_commands").getKeys(false)) {
            this.enabledCommands.put(cmd, this.getConfig().getBoolean("enabled_commands." + cmd, true));
        }
    }

    private GameMode parseGamemode(String arg) {
        switch (arg.toLowerCase()) {
            case "0": 
            case "s": 
            case "survival": {
                return GameMode.SURVIVAL;
            }
            case "1": 
            case "c": 
            case "creative": {
                return GameMode.CREATIVE;
            }
            case "2": 
            case "a": 
            case "adventure": {
                return GameMode.ADVENTURE;
            }
            case "3": 
            case "sp": 
            case "spectator": {
                return GameMode.SPECTATOR;
            }
        }
        return null;
    }

    private boolean isEnabled(String command) {
        return this.enabledCommands.getOrDefault(command, false);
    }

    private void send(Player sender, String message) {
        sender.sendMessage(this.prefix + message);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Nur Spieler k\u00f6nnen diesen Befehl nutzen.");
            return true;
        }
        Player player = (Player)sender;
        String command = cmd.getName().toLowerCase();
        if (!this.isEnabled(command)) {
            this.send(player, String.valueOf(ChatColor.RED) + "Dieser Befehl ist deaktiviert.");
            return true;
        }
        GameMode targetGamemode = null;
        Player targetPlayer = player;
        boolean isSelf = true;
        if (command.equals("gm")) {
            if (args.length == 0) {
                targetGamemode = GameMode.CREATIVE;
            } else {
                targetGamemode = this.parseGamemode(args[0]);
                if (args.length >= 2) {
                    targetPlayer = Bukkit.getPlayer((String)args[1]);
                    if (targetPlayer == null) {
                        this.send(player, String.valueOf(ChatColor.RED) + "Spieler nicht gefunden.");
                        return true;
                    }
                    isSelf = targetPlayer.equals((Object)player);
                }
            }
        } else {
            switch (command) {
                case "gmc": {
                    GameMode gameMode = GameMode.CREATIVE;
                    break;
                }
                case "gms": {
                    GameMode gameMode = GameMode.SURVIVAL;
                    break;
                }
                case "gma": {
                    GameMode gameMode = GameMode.ADVENTURE;
                    break;
                }
                case "gmsp": {
                    GameMode gameMode = GameMode.SPECTATOR;
                    break;
                }
                default: {
                    GameMode gameMode = targetGamemode = null;
                }
            }
            if (args.length >= 1) {
                targetPlayer = Bukkit.getPlayer((String)args[0]);
                if (targetPlayer == null) {
                    this.send(player, String.valueOf(ChatColor.RED) + "Spieler nicht gefunden.");
                    return true;
                }
                isSelf = targetPlayer.equals((Object)player);
            }
        }
        String perm = "servergm." + command + "." + (isSelf ? "self" : "other");
        if (!player.hasPermission(perm) && !player.hasPermission("servergm.all")) {
            this.send(player, String.valueOf(ChatColor.RED) + "Du hast keine Berechtigung daf\u00fcr.");
            return true;
        }
        targetPlayer.setGameMode(targetGamemode);
        String modeName = targetGamemode.name().toLowerCase();
        if (isSelf) {
            this.send(player, this.msgSelf.replace("%gamemode%", modeName));
        } else {
            this.send(player, this.msgOther.replace("%spieler%", targetPlayer.getName()).replace("%gamemode%", modeName));
            this.send(targetPlayer, this.msgSelf.replace("%gamemode%", modeName));
        }
        return true;
    }
}

