/*
 * Decompiled with CFR 0.152.
 */
package dev.hardaway.mannequins.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.hardaway.mannequins.client.model.DummyModel;
import dev.hardaway.mannequins.client.model.TranslatedHumanoid;
import dev.hardaway.mannequins.core.mixin.client.HumanoidModelAccessor;
import java.util.Collections;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.HumanoidArm;

public class StatueModel
extends DummyModel
implements TranslatedHumanoid {
    private final ModelPart stand;
    private final ModelPart root;

    public StatueModel(ModelPart root) {
        super(root);
        this.stand = root.getChild("stand");
        this.root = this.stand.getChild("root");
        HumanoidModelAccessor access = (HumanoidModelAccessor)((Object)this);
        access.setBody(this.root.getChild("body"));
        access.setLeftArm(this.body.getChild("left_arm"));
        access.setRightArm(this.body.getChild("right_arm"));
        access.setHead(this.body.getChild("head"));
    }

    @Override
    public ModelPart getRoot() {
        return this.root;
    }

    protected Iterable<ModelPart> headParts() {
        return Collections.emptySet();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.stand);
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        this.stand.translateAndRotate(poseStack);
        this.getRoot().translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
        super.translateToHand(arm, poseStack);
    }

    @Override
    public void translateToHead(PoseStack poseStack) {
        this.stand.translateAndRotate(poseStack);
        this.getRoot().translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
    }

    @Override
    public void translateToBody(PoseStack poseStack) {
        this.stand.translateAndRotate(poseStack);
        this.getRoot().translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
    }

    @Override
    public void translateToElytra(PoseStack poseStack) {
        this.stand.translateAndRotate(poseStack);
        this.getRoot().translateAndRotate(poseStack);
        this.body.translateAndRotate(poseStack);
        poseStack.translate(0.0f, this.head.y / 16.0f, 0.0f);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition modelRoot = mesh.getRoot();
        PartDefinition stand = modelRoot.addOrReplaceChild("stand", CubeListBuilder.create().texOffs(24, 16).addBox(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, false), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition root = stand.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 10.0f, 4.0f, false), PartPose.offset((float)0.0f, (float)-10.0f, (float)0.0f));
        body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(32, 0).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, false), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }
}

