/*
 * Decompiled with CFR 0.152.
 */
package dev.hardaway.mannequins.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import dev.hardaway.mannequins.api.DummyExpression;
import dev.hardaway.mannequins.client.block.MannequinClientBlockExtension;
import dev.hardaway.mannequins.client.model.DummyModel;
import dev.hardaway.mannequins.common.block.DummyBlock;
import dev.hardaway.mannequins.common.block.entity.DummyBlockEntity;
import dev.hardaway.mannequins.common.compat.vanity.MannequinsAssetTypes;
import dev.hardaway.mannequins.common.compat.vanity.MannequinsVanityCompat;
import dev.hardaway.mannequins.common.entity.ClientDummy;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import tech.thatgravyboat.vanity.api.style.Style;
import tech.thatgravyboat.vanity.client.design.ClientDesignManager;

public class DummyEntityRenderer
extends LivingEntityRenderer<ClientDummy, DummyModel> {
    private static final Map<Block, DummyModel> MODEL_PROVIDERS = new HashMap<Block, DummyModel>();
    private final EntityRendererProvider.Context context;

    public DummyEntityRenderer(EntityRendererProvider.Context context, DummyModel model, DummyModel innerArmorModel, DummyModel outerArmorModel) {
        super(context, (EntityModel)model, 0.0f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)innerArmorModel, (HumanoidModel)outerArmorModel, context.getModelManager()));
        this.addLayer((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.getModelSet()));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
        this.context = context;
        MODEL_PROVIDERS.clear();
    }

    protected boolean shouldShowName(ClientDummy entity) {
        return false;
    }

    public void render(ClientDummy entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        this.model = (EntityModel)MODEL_PROVIDERS.computeIfAbsent(entity.getDummy().getBlockState().getBlock(), block -> ((MannequinClientBlockExtension)IClientBlockExtensions.of((Block)block)).getRenderingDelegate().apply(this.context));
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(ClientDummy entity) {
        Holder<DummyExpression> expression;
        Pair<ResourceLocation, String> vanity;
        DummyBlockEntity mannequin = entity.getDummy();
        if (MannequinsVanityCompat.isLoaded() && (vanity = mannequin.getVanity()) != null) {
            ResourceLocation vanityTexture;
            Style style = ClientDesignManager.INSTANCE.getDesign((ResourceLocation)vanity.getFirst()).map(design -> design.getStyleForItem((String)vanity.getSecond(), new ItemStack((ItemLike)mannequin.getBlockState().getBlock()))).orElse(null);
            ResourceLocation resourceLocation = vanityTexture = style != null ? style.asset(MannequinsAssetTypes.MANNEQUIN) : null;
            if (vanityTexture != null) {
                return vanityTexture;
            }
        }
        if ((expression = mannequin.getExpression()) != null) {
            return ((DummyExpression)expression.value()).asset().withPrefix("textures/").withSuffix(".png");
        }
        return ((DummyBlock)mannequin.getBlockState().getBlock()).getDummyTexture();
    }
}

