/*
 * Decompiled with CFR 0.152.
 */
package dev.hardaway.mannequins.client.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.hardaway.mannequins.core.Mannequins;
import dev.hardaway.mannequins.core.util.ScrollHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ScrollBar
extends AbstractWidget {
    private static final ResourceLocation SCROLLBAR = Mannequins.path("widget/scrollbar");
    private static final ResourceLocation SCROLLBAR_DISABLED = Mannequins.path("widget/scrollbar_disabled");
    private final ScrollHandler scrollHandler;
    private final OnScroll onScroll;
    private boolean dragging;

    public ScrollBar(int x, int y, int width, int height, int maxScroll, Component title, @Nullable OnScroll onScroll) {
        super(x, y, width, height, title);
        this.scrollHandler = new ScrollHandler(0, height);
        this.setMaxScroll(maxScroll);
        this.dragging = false;
        this.onScroll = onScroll;
    }

    public void tick() {
        this.scrollHandler.update();
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        boolean draggable = this.scrollHandler.getMaxScroll() > 0;
        float barY = draggable ? (float)(this.height - 17) * this.scrollHandler.getInterpolatedScroll(partialTicks) / (float)this.scrollHandler.getMaxScroll() : 0.0f;
        guiGraphics.blitSprite(this.active ? SCROLLBAR : SCROLLBAR_DISABLED, this.getX() + 1, this.getY() + Math.round(barY) + 1, 6, 15);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void drag(double mouseY) {
        this.scrollHandler.setScroll((double)this.scrollHandler.getMaxScroll() * ((mouseY - (double)this.getY() - 7.5) / (double)(this.height - 15)));
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.isHovered()) {
            this.dragging = true;
            this.drag(mouseY);
            this.onScroll.scroll(this);
        }
    }

    public void mouseMoved(double mouseX, double mouseY) {
        if (this.dragging) {
            this.drag(mouseY);
            this.onScroll.scroll(this);
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.dragging) {
            this.dragging = false;
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.scrollHandler.mouseScrolled(2.0, scrollY);
        this.onScroll.scroll(this);
        return true;
    }

    public void setScrollSpeed(float speed) {
        this.scrollHandler.setScrollSpeed(speed);
    }

    public float getInterpolatedScrollPercentage(float partialTicks) {
        return this.scrollHandler.getMaxScroll() > 0 ? this.scrollHandler.getInterpolatedScroll(partialTicks) / (float)this.scrollHandler.getMaxScroll() : 0.0f;
    }

    public float getScrollPercentage() {
        return this.scrollHandler.getMaxScroll() > 0 ? (float)(this.scrollHandler.getScroll() / (double)this.scrollHandler.getMaxScroll()) : 0.0f;
    }

    public double getScroll() {
        return this.scrollHandler.getMaxScroll() > 0 ? this.scrollHandler.getScroll() : 0.0;
    }

    public void setScroll(double scroll) {
        this.scrollHandler.setScroll(scroll);
    }

    public float getInterpolatedScroll(float partialTicks) {
        return this.scrollHandler.getMaxScroll() > 0 ? this.scrollHandler.getInterpolatedScroll(partialTicks) : 0.0f;
    }

    public int getMaxScroll() {
        return this.scrollHandler.getMaxScroll();
    }

    public void setMaxScroll(int maxScroll) {
        this.scrollHandler.setHeight(maxScroll);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    @FunctionalInterface
    public static interface OnScroll {
        public void scroll(ScrollBar var1);
    }
}

