/*
 * Decompiled with CFR 0.152.
 */
package dev.hardaway.mannequins.common.block;

import dev.hardaway.mannequins.api.DummyExpression;
import dev.hardaway.mannequins.common.block.entity.DummyBlockEntity;
import dev.hardaway.mannequins.core.registry.MannequinsRegistries;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class DummyBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;
    public static final ResourceLocation CONTENTS = ResourceLocation.withDefaultNamespace((String)"contents");
    protected static final VoxelShape SHAPE = Shapes.join((VoxelShape)Shapes.empty(), (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.OR);
    protected static final VoxelShape LOWER_VISUAL_SHAPE = Shapes.join((VoxelShape)Shapes.empty(), (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)2.0, (double)0.875), (BooleanOp)BooleanOp.OR);
    protected static final VoxelShape UPPER_VISUAL_SHAPE = Shapes.join((VoxelShape)Shapes.empty(), (VoxelShape)Shapes.box((double)0.125, (double)-1.0, (double)0.125, (double)0.875, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.OR);

    public DummyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @Nullable
    public abstract AbstractContainerMenu createMenu(int var1, Inventory var2, ContainerLevelAccess var3, DummyBlockEntity var4);

    @Nullable
    public DummyBlockEntity getMannequin(Level level, BlockState state, BlockPos pos) {
        DummyBlockEntity mannequin;
        BlockEntity be = level.getBlockEntity(state.getValue(HALF) == DoubleBlockHalf.LOWER ? pos : pos.below());
        return be instanceof DummyBlockEntity ? (mannequin = (DummyBlockEntity)be) : null;
    }

    protected MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        return this.getMannequin(level, state, pos);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        return state.getValue(HALF) == DoubleBlockHalf.LOWER || belowState.is((Block)this);
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        if (facing.getAxis() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (facing == Direction.UP)) {
            return half == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
        }
        return facingState.is((Block)this) && facingState.getValue(HALF) != half ? (BlockState)facingState.setValue(HALF, (Comparable)half) : Blocks.AIR.defaultBlockState();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        Level level = context.getLevel();
        if (blockpos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(blockpos.above()).canBeReplaced(context)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(RotationSegment.convertToSegment((float)(context.getRotation() + 180.0f))))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockPos above = pos.above();
        level.setBlock(above, DoublePlantBlock.copyWaterloggedFrom((LevelReader)level, (BlockPos)above, (BlockState)((BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER))), 3);
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(rotation.rotate(((Integer)state.getValue((Property)ROTATION)).intValue(), 16)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(mirror.mirror(((Integer)state.getValue((Property)ROTATION)).intValue(), 16)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ROTATION, WATERLOGGED, HALF});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        DummyBlockEntity mannequin = this.getMannequin(level, state, pos);
        if (mannequin != null) {
            player.openMenu((MenuProvider)mannequin, buf -> buf.writeBlockPos(mannequin.getBlockPos()));
        }
        return InteractionResult.CONSUME;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            Registry registry = level.registryAccess().registry(MannequinsRegistries.EXPRESSIONS).orElse(null);
            if (registry == null) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            DummyBlockEntity mannequin = this.getMannequin(level, state, pos);
            List expressions = registry.holders().filter(holder -> {
                DummyExpression expression = (DummyExpression)holder.value();
                return expression.item().contains(stack.getItemHolder()) && state.is(expression.mannequin()) && !holder.equals(mannequin.getExpression());
            }).collect(Collectors.toList());
            if (expressions.isEmpty()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            expressions.add(null);
            Holder expression = (Holder)Util.getRandom(expressions, (RandomSource)level.getRandom());
            mannequin.setExpression((Holder<DummyExpression>)expression);
            mannequin.setChanged();
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide) {
            if (player.isCreative()) {
                BlockPos blockpos;
                BlockState blockstate;
                DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.getValue(HALF);
                if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = level.getBlockState(blockpos = pos.below())).is(state.getBlock()) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER) {
                    BlockState blockstate1 = blockstate.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
                    level.setBlock(blockpos, blockstate1, 35);
                    level.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
                }
            } else {
                DummyBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)this.getMannequin(level, state, pos), (Entity)player, (ItemStack)player.getMainHandItem());
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @javax.annotation.Nullable BlockEntity te, ItemStack stack) {
        super.playerDestroy(level, player, pos, Blocks.AIR.defaultBlockState(), te, stack);
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        BlockEntity be = (BlockEntity)params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (be instanceof DummyBlockEntity) {
            DummyBlockEntity mannequin = (DummyBlockEntity)be;
            params = params.withDynamicDrop(CONTENTS, p_56219_ -> {
                for (int i = 0; i < mannequin.getInventory().getSlots(); ++i) {
                    p_56219_.accept(mannequin.getInventory().getStackInSlot(i));
                }
            });
        }
        return super.getDrops(state, params);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? LOWER_VISUAL_SHAPE : UPPER_VISUAL_SHAPE;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public abstract ResourceLocation getDummyTexture();
}

