/*
 * Decompiled with CFR 0.152.
 */
package dev.hardaway.mannequins.common.block.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import dev.hardaway.mannequins.api.DummyExpression;
import dev.hardaway.mannequins.api.DummyPose;
import dev.hardaway.mannequins.common.block.DummyBlock;
import dev.hardaway.mannequins.common.compat.vanity.MannequinsVanityCompat;
import dev.hardaway.mannequins.common.entity.ClientDummy;
import dev.hardaway.mannequins.common.menu.DummyInventory;
import dev.hardaway.mannequins.core.registry.MannequinsComponents;
import dev.hardaway.mannequins.core.registry.MannequinsRegistries;
import dev.hardaway.mannequins.core.util.BuiltinPoses;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import tech.thatgravyboat.vanity.common.registries.ModDataComponents;

public abstract class DummyBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DummyPose DEFAULT_POSE = BuiltinPoses.DEFAULT.getPose();
    private final DummyInventory inventory = new DummyInventory();
    private DummyPose pose = DEFAULT_POSE;
    private BuiltinPoses lastPoseCycle = BuiltinPoses.DEFAULT;
    @Nullable
    private Pair<ResourceLocation, String> vanity;
    @Nullable
    private Holder<DummyExpression> expression;
    @Nullable
    private ClientDummy dummy;
    @Nullable
    private Component name;

    public DummyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (level.isClientSide()) {
            this.setDummy(new ClientDummy(level, this));
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.level.isClientSide()) {
            this.getDummy().setRemoved(Entity.RemovalReason.DISCARDED);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveCustomOnly(registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains("CustomName", 8)) {
            this.name = DummyBlockEntity.parseCustomNameSafe((String)tag.getString("CustomName"), (HolderLookup.Provider)registries);
        }
        DummyPose.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("mannequin_pose")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this::setPose);
        if (tag.contains("mannequin_expression", 8)) {
            RegistryFixedCodec.create(MannequinsRegistries.EXPRESSIONS).parse((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries), (Object)tag.get("mannequin_expression")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this::setExpression);
        } else {
            this.setExpression(null);
        }
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
        if (MannequinsVanityCompat.isLoaded() && tag.contains("vanity", 10)) {
            Objects.requireNonNull(((DataComponentType)ModDataComponents.STYLE.get()).codec()).parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("vanity")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(vanity -> {
                this.vanity = vanity;
            });
        } else {
            this.vanity = null;
        }
        super.loadAdditional(tag, registries);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (this.name != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)registries));
        }
        DummyPose.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.pose).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(poseTag -> tag.put("mannequin_pose", poseTag));
        if (this.expression != null) {
            RegistryFixedCodec.create(MannequinsRegistries.EXPRESSIONS).encodeStart((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries), this.expression).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(expressionTag -> tag.put("mannequin_expression", expressionTag));
        }
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        if (MannequinsVanityCompat.isLoaded() && this.vanity != null) {
            Objects.requireNonNull(((DataComponentType)ModDataComponents.STYLE.get()).codec()).encodeStart((DynamicOps)NbtOps.INSTANCE, this.vanity).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(vanityTag -> tag.put("vanity", vanityTag));
        }
        super.saveAdditional(tag, registries);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        this.name = (Component)componentInput.get(DataComponents.CUSTOM_NAME);
        this.pose = (DummyPose)componentInput.getOrDefault(MannequinsComponents.POSE, (Object)DEFAULT_POSE);
        this.expression = (Holder)componentInput.get(MannequinsComponents.EXPRESSION);
        if (MannequinsVanityCompat.isLoaded()) {
            this.vanity = (Pair)componentInput.get((Supplier)ModDataComponents.STYLE);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        components.set(DataComponents.CUSTOM_NAME, (Object)this.name);
        components.set(MannequinsComponents.POSE, (Object)this.pose);
        components.set(MannequinsComponents.EXPRESSION, this.expression);
        if (MannequinsVanityCompat.isLoaded()) {
            components.set((Supplier)ModDataComponents.STYLE, this.vanity);
        }
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("CustomName");
        tag.remove("mannequin_pose");
        tag.remove("mannequin_expression");
        tag.remove("vanity");
    }

    public void markDirty() {
        BlockPos pos = this.getBlockPos();
        BlockState state = this.getBlockState();
        if (this.level != null) {
            this.setChanged();
            this.level.sendBlockUpdated(pos, state, state, 3);
            this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
        }
    }

    @Nullable
    public Pair<ResourceLocation, String> getVanity() {
        return this.vanity;
    }

    @Nullable
    public ClientDummy getDummy() {
        return this.dummy;
    }

    public void setDummy(@Nullable ClientDummy dummy) {
        if (!this.level.isClientSide()) {
            return;
        }
        this.dummy = dummy;
    }

    @Nullable
    public Holder<DummyExpression> getExpression() {
        return this.expression;
    }

    public void setExpression(@Nullable Holder<DummyExpression> expression) {
        this.expression = expression;
        this.markDirty();
    }

    public BuiltinPoses getLastPoseCycle() {
        return this.lastPoseCycle;
    }

    public void setLastPoseCycle(BuiltinPoses lastPoseCycle) {
        this.lastPoseCycle = lastPoseCycle;
    }

    public DummyPose getPose() {
        return this.pose;
    }

    public void setPose(DummyPose pose) {
        this.pose = pose;
        this.markDirty();
    }

    public void randomizePose() {
        int nextOrdinal = this.getLastPoseCycle().ordinal() + 1;
        if (nextOrdinal >= BuiltinPoses.VALUES.length) {
            nextOrdinal = 0;
        }
        BuiltinPoses pose = BuiltinPoses.VALUES[nextOrdinal];
        this.setLastPoseCycle(pose);
        this.setPose(pose.getPose());
    }

    public void resetPose() {
        this.setExpression(null);
        this.setPose(BuiltinPoses.DEFAULT.getPose());
        this.setLastPoseCycle(BuiltinPoses.DEFAULT);
    }

    public DummyInventory getInventory() {
        return this.inventory;
    }

    public Component getName() {
        return this.name != null ? this.name : this.getBlockState().getBlock().getName();
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return ((DummyBlock)this.getBlockState().getBlock()).createMenu(containerId, playerInventory, ContainerLevelAccess.create((Level)this.getLevel(), (BlockPos)this.getBlockPos()), this);
    }
}

