/*
 * Decompiled with CFR 0.152.
 */
package dev.hardaway.mannequins.common.block.entity;

import dev.hardaway.mannequins.api.DummyExpression;
import dev.hardaway.mannequins.common.block.DummyBlock;
import dev.hardaway.mannequins.common.block.entity.DummyBlockEntity;
import dev.hardaway.mannequins.core.registry.MannequinsBlockEntities;
import dev.hardaway.mannequins.core.registry.MannequinsExpressions;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;

public class MannequinBlockEntity
extends DummyBlockEntity {
    private float attackAnimationXFactor;
    private float attackAnimationZFactor;
    private int attackAnimation;
    public int attackDelay;

    public MannequinBlockEntity(BlockPos pos, BlockState blockState) {
        super(MannequinsBlockEntities.MANNEQUIN.get(), pos, blockState);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, MannequinBlockEntity dummy) {
        if (dummy.attackAnimation <= 0) {
            return;
        }
        --dummy.attackAnimation;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MannequinBlockEntity dummy) {
        if (dummy.attackDelay <= 0) {
            return;
        }
        --dummy.attackDelay;
    }

    @Override
    public void randomizePose() {
        Optional trolder;
        Level level = this.getLevel();
        if ((this.getExpression() == null || !this.getExpression().is(MannequinsExpressions.MANNEQUIN_TROLLED)) && level.getRandom().nextDouble() < 0.001 && (trolder = level.registryAccess().holder(MannequinsExpressions.MANNEQUIN_TROLLED)).isPresent()) {
            this.setExpression((Holder<DummyExpression>)((Holder)trolder.get()));
            return;
        }
        super.randomizePose();
    }

    public void attack(float attackYaw) {
        float bodyRot = -RotationSegment.convertToDegrees((int)((Integer)this.getBlockState().getValue((Property)DummyBlock.ROTATION)));
        float rotation = attackYaw + bodyRot * ((float)Math.PI / 180);
        this.attackAnimation = 40;
        this.attackAnimationXFactor = Mth.cos((float)rotation);
        this.attackAnimationZFactor = Mth.sin((float)rotation);
    }

    private float getAttackAnimation(float partialTicks) {
        float x = (float)this.attackAnimation - partialTicks;
        return Mth.cos((float)x) / 2.0f * Mth.sqrt((float)x) / (50.0f - x);
    }

    public boolean hasAnimation() {
        return this.attackAnimation > 0;
    }

    public float getAnimationRotationX(float partialTicks) {
        return this.attackAnimationXFactor * this.getAttackAnimation(partialTicks);
    }

    public float getAnimationRotationZ(float partialTicks) {
        return this.attackAnimationZFactor * this.getAttackAnimation(partialTicks);
    }
}

