/*
 * Decompiled with CFR 0.152.
 */
package dev.hardaway.mannequins.common.menu;

import com.mojang.datafixers.util.Pair;
import dev.hardaway.mannequins.common.block.entity.DummyBlockEntity;
import dev.hardaway.mannequins.common.menu.DummyInventory;
import dev.hardaway.mannequins.core.Mannequins;
import dev.hardaway.mannequins.core.util.QuickMoveHelper;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.Nullable;

public class DummyEditorMenu
extends AbstractContainerMenu {
    public static final ResourceLocation EMPTY_EDITOR_SLOT_MAINHAND = Mannequins.path("item/empty_editor_slot_mainhand");
    private static final QuickMoveHelper MOVE_HELPER = new QuickMoveHelper().add(0, 4, 4, 36, true).add(4, 36, 0, 4, false);
    private final ContainerLevelAccess access;
    private final DummyBlockEntity dummy;

    public MenuType<?> getType() {
        return super.getType();
    }

    public DummyEditorMenu(Supplier<MenuType<? extends DummyEditorMenu>> type, int containerId, Inventory playerInventory, FriendlyByteBuf data) {
        this(type, containerId, playerInventory, ContainerLevelAccess.NULL, (DummyBlockEntity)Minecraft.getInstance().level.getBlockEntity(data.readBlockPos()));
    }

    public DummyEditorMenu(Supplier<MenuType<? extends DummyEditorMenu>> type, int id, final Inventory inventory, ContainerLevelAccess access, DummyBlockEntity dummy) {
        super(type.get(), id);
        this.access = access;
        this.dummy = dummy;
        DummyInventory dummyInventory = this.dummy.getInventory();
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)dummyInventory, 0, 8, 18){

            public int getMaxStackSize() {
                return 1;
            }

            public boolean mayPlace(ItemStack itemStack) {
                return inventory.player.getEquipmentSlotForItem(itemStack) == EquipmentSlot.HEAD;
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_HELMET);
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)dummyInventory, 1, 8, 36){

            public int getMaxStackSize() {
                return 1;
            }

            public boolean mayPlace(ItemStack itemStack) {
                return inventory.player.getEquipmentSlotForItem(itemStack) == EquipmentSlot.CHEST;
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE);
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)dummyInventory, 2, 8, 54){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_EDITOR_SLOT_MAINHAND);
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)dummyInventory, 3, 8, 72){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 121 + y * 18 - 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)inventory, x, 8 + x * 18, 161));
        }
    }

    public boolean stillValid(Player player) {
        return DummyEditorMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)this.dummy.getBlockState().getBlock());
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        return MOVE_HELPER.quickMoveStack(this, player, slot);
    }

    @Nullable
    public DummyBlockEntity getDummy() {
        return this.dummy;
    }
}

