/*
 * Decompiled with CFR 0.152.
 */
package dev.hardaway.mannequins.core;

import dev.hardaway.mannequins.api.DummyExpression;
import dev.hardaway.mannequins.common.entity.ClientDummy;
import dev.hardaway.mannequins.common.network.handler.MannequinsClientPlayHandler;
import dev.hardaway.mannequins.common.network.handler.MannequinsServerPlayHandler;
import dev.hardaway.mannequins.common.network.payload.ClientboundAttackMannequinPayload;
import dev.hardaway.mannequins.common.network.payload.ServerboundMannequinActionPayload;
import dev.hardaway.mannequins.common.network.payload.ServerboundSetMannequinPosePayload;
import dev.hardaway.mannequins.core.data.MannequinsBlockTagsProvider;
import dev.hardaway.mannequins.core.data.MannequinsItemModelProvider;
import dev.hardaway.mannequins.core.data.MannequinsLanguageProvider;
import dev.hardaway.mannequins.core.data.MannequinsRecipeProvider;
import dev.hardaway.mannequins.core.data.MannequinsSoundDefinitionsProvider;
import dev.hardaway.mannequins.core.data.loot.MannequinsBlockLootProvider;
import dev.hardaway.mannequins.core.data.loot.MannequinsLootProvider;
import dev.hardaway.mannequins.core.registry.MannequinsBlockEntities;
import dev.hardaway.mannequins.core.registry.MannequinsBlocks;
import dev.hardaway.mannequins.core.registry.MannequinsComponents;
import dev.hardaway.mannequins.core.registry.MannequinsEntities;
import dev.hardaway.mannequins.core.registry.MannequinsExpressions;
import dev.hardaway.mannequins.core.registry.MannequinsItems;
import dev.hardaway.mannequins.core.registry.MannequinsMenus;
import dev.hardaway.mannequins.core.registry.MannequinsRegistries;
import dev.hardaway.mannequins.core.registry.MannequinsSounds;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.handling.MainThreadPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@Mod(value="mannequins")
public class Mannequins {
    public static final String MOD_ID = "mannequins";

    public Mannequins(IEventBus bus) {
        bus.addListener(this::setup);
        bus.addListener(this::registerAttributes);
        bus.addListener(this::registerCreativeTabs);
        bus.addListener(this::registerPayloadHandlers);
        bus.addListener(this::gatherData);
        bus.register(MannequinsRegistries.class);
        MannequinsComponents.REGISTRY.register(bus);
        MannequinsSounds.REGISTRY.register(bus);
        MannequinsBlocks.REGISTRY.register(bus);
        MannequinsBlockEntities.REGISTRY.register(bus);
        MannequinsItems.REGISTRY.register(bus);
        MannequinsEntities.REGISTRY.register(bus);
        MannequinsMenus.REGISTRY.register(bus);
    }

    public static ResourceLocation path(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {});
    }

    private void registerAttributes(EntityAttributeCreationEvent event) {
        event.put(MannequinsEntities.DUMMY.get(), ClientDummy.createAttributes().build());
    }

    private void registerCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() != CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            return;
        }
        event.insertAfter(new ItemStack((ItemLike)Items.ARMOR_STAND), new ItemStack((ItemLike)MannequinsItems.MANNEQUIN.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        event.insertAfter(new ItemStack((ItemLike)MannequinsItems.MANNEQUIN.get()), new ItemStack((ItemLike)MannequinsItems.STATUE.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("m2");
        registrar.playToServer(ServerboundSetMannequinPosePayload.PACKET_TYPE, ServerboundSetMannequinPosePayload.CODEC, (IPayloadHandler)new MainThreadPayloadHandler(MannequinsServerPlayHandler::handleSyncMannequinPose));
        registrar.playToServer(ServerboundMannequinActionPayload.PACKET_TYPE, ServerboundMannequinActionPayload.CODEC, (IPayloadHandler)new MainThreadPayloadHandler(MannequinsServerPlayHandler::handleMannequinAction));
        registrar.playToClient(ClientboundAttackMannequinPayload.PACKET_TYPE, ClientboundAttackMannequinPayload.CODEC, (IPayloadHandler)new MainThreadPayloadHandler(MannequinsClientPlayHandler::handleMannequinAttack));
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        event.createDatapackRegistryObjects(new RegistrySetBuilder().add(MannequinsRegistries.EXPRESSIONS, bootstrap -> {
            HolderGetter itemLookup = bootstrap.lookup(Registries.ITEM);
            HolderSet.Named axeTag = itemLookup.getOrThrow(ItemTags.AXES);
            bootstrap.register(MannequinsExpressions.MANNEQUIN_TROLLED, (Object)new DummyExpression((Holder<Block>)MannequinsBlocks.MANNEQUIN, Mannequins.path("entity/mannequin/expression/mannequin_trolled")));
            bootstrap.register(MannequinsExpressions.MANNEQUIN_HAPPY, (Object)new DummyExpression((Holder<Block>)MannequinsBlocks.MANNEQUIN, Mannequins.path("entity/mannequin/expression/mannequin_happy"), (HolderSet<Item>)axeTag));
            bootstrap.register(MannequinsExpressions.MANNEQUIN_NEUTRAL, (Object)new DummyExpression((Holder<Block>)MannequinsBlocks.MANNEQUIN, Mannequins.path("entity/mannequin/expression/mannequin_neutral"), (HolderSet<Item>)axeTag));
            bootstrap.register(MannequinsExpressions.MANNEQUIN_UPSET, (Object)new DummyExpression((Holder<Block>)MannequinsBlocks.MANNEQUIN, Mannequins.path("entity/mannequin/expression/mannequin_upset"), (HolderSet<Item>)axeTag));
            bootstrap.register(MannequinsExpressions.MANNEQUIN_SURPRISED, (Object)new DummyExpression((Holder<Block>)MannequinsBlocks.MANNEQUIN, Mannequins.path("entity/mannequin/expression/mannequin_surprised"), (HolderSet<Item>)axeTag));
            HolderSet.Named pickaxeTag = itemLookup.getOrThrow(ItemTags.PICKAXES);
            bootstrap.register(MannequinsExpressions.STATUE_TROLLED, (Object)new DummyExpression((Holder<Block>)MannequinsBlocks.STATUE, Mannequins.path("entity/statue/expression/statue_trolled")));
            bootstrap.register(MannequinsExpressions.STATUE_HAPPY, (Object)new DummyExpression((Holder<Block>)MannequinsBlocks.STATUE, Mannequins.path("entity/statue/expression/statue_happy"), (HolderSet<Item>)pickaxeTag));
            bootstrap.register(MannequinsExpressions.STATUE_NEUTRAL, (Object)new DummyExpression((Holder<Block>)MannequinsBlocks.STATUE, Mannequins.path("entity/statue/expression/statue_neutral"), (HolderSet<Item>)pickaxeTag));
            bootstrap.register(MannequinsExpressions.STATUE_UPSET, (Object)new DummyExpression((Holder<Block>)MannequinsBlocks.STATUE, Mannequins.path("entity/statue/expression/statue_upset"), (HolderSet<Item>)pickaxeTag));
            bootstrap.register(MannequinsExpressions.STATUE_SURPRISED, (Object)new DummyExpression((Holder<Block>)MannequinsBlocks.STATUE, Mannequins.path("entity/statue/expression/statue_surprised"), (HolderSet<Item>)pickaxeTag));
        }));
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(event.includeClient(), (DataProvider)new MannequinsLanguageProvider(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new MannequinsSoundDefinitionsProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new MannequinsItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new MannequinsBlockTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new MannequinsRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new MannequinsLootProvider(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(MannequinsBlockLootProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
    }
}

