/*
 * Decompiled with CFR 0.152.
 */
package dev.hardaway.mannequins.core.registry;

import dev.hardaway.mannequins.client.model.DummyModel;
import dev.hardaway.mannequins.client.model.MannequinModel;
import dev.hardaway.mannequins.client.model.StatueModel;
import dev.hardaway.mannequins.core.Mannequins;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

public class MannequinsModelLayers {
    public static final ModelLayerLocation MANNEQUIN = MannequinsModelLayers.create("mannequin");
    public static final ModelLayerLocation STATUE = MannequinsModelLayers.create("statue");
    public static final ModelLayerLocation DUMMY_INNER_ARMOR = MannequinsModelLayers.create("dummy", "inner_armor");
    public static final ModelLayerLocation DUMMY_OUTER_ARMOR = MannequinsModelLayers.create("dummy", "outer_armor");

    public static ModelLayerLocation create(String model) {
        return MannequinsModelLayers.create(model, "main");
    }

    public static ModelLayerLocation create(String model, String layer) {
        return new ModelLayerLocation(Mannequins.path(model), layer);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(MANNEQUIN, MannequinModel::createBodyLayer);
        event.registerLayerDefinition(STATUE, StatueModel::createBodyLayer);
        event.registerLayerDefinition(DUMMY_INNER_ARMOR, () -> DummyModel.createBodyLayer(new CubeDeformation(0.5f)));
        event.registerLayerDefinition(DUMMY_OUTER_ARMOR, () -> DummyModel.createBodyLayer(new CubeDeformation(1.0f)));
    }
}

