/*
 * Decompiled with CFR 0.152.
 */
package dev.hardaway.mannequins.core.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class QuickMoveHelper {
    private final List<Action> actions = new ArrayList<Action>();

    private static boolean mergeItemStack(AbstractContainerMenu menu, ItemStack stack, int startIndex, int endIndex, boolean reverse) {
        boolean flag = false;
        int i = startIndex;
        if (reverse) {
            i = endIndex - 1;
        }
        if (stack.isStackable()) {
            while (!stack.isEmpty() && !(reverse ? i < startIndex : i >= endIndex)) {
                Slot slot = menu.getSlot(i);
                ItemStack itemstack = slot.getItem();
                if (slot.mayPlace(stack) && !itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.getCount() + stack.getCount();
                    if (j <= (maxSize = Math.min(slot.getMaxStackSize(stack), stack.getMaxStackSize()))) {
                        stack.setCount(0);
                        itemstack.setCount(j);
                        slot.setChanged();
                        flag = true;
                    } else if (itemstack.getCount() < maxSize) {
                        stack.shrink(maxSize - itemstack.getCount());
                        itemstack.setCount(maxSize);
                        slot.setChanged();
                        flag = true;
                    }
                }
                if (reverse) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.isEmpty()) {
            i = reverse ? endIndex - 1 : startIndex;
            while (!(!reverse ? i >= endIndex : i < startIndex)) {
                Slot slot1 = menu.getSlot(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(stack)) {
                    if (stack.getCount() > slot1.getMaxStackSize(stack)) {
                        slot1.set(stack.split(slot1.getMaxStackSize(stack)));
                    } else {
                        slot1.set(stack.split(stack.getCount()));
                    }
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (reverse) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public QuickMoveHelper add(int fromStart, int fromSize, int toStart, int toSize, boolean reverse) {
        this.actions.add(new Action(fromStart, fromSize, toStart, toSize, reverse));
        return this;
    }

    public ItemStack quickMoveStack(AbstractContainerMenu menu, Player player, int slotId) {
        ItemStack oldStack = ItemStack.EMPTY;
        Slot slot = menu.getSlot(slotId);
        if (slot != null && slot.hasItem()) {
            ItemStack slotItem = slot.getItem();
            oldStack = slotItem.copy();
            for (Action action : this.actions) {
                if (slotId < action.fromStart || slotId >= action.fromEnd || QuickMoveHelper.mergeItemStack(menu, slotItem, action.toStart, action.toEnd, action.reverse)) continue;
                return ItemStack.EMPTY;
            }
            if (slotItem.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotItem.getCount() == oldStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotItem);
        }
        return oldStack;
    }

    public static class Action {
        private final int fromStart;
        private final int fromEnd;
        private final int toStart;
        private final int toEnd;
        private final boolean reverse;

        public Action(int fromStart, int fromSize, int toStart, int toSize, boolean reverse) {
            this.fromStart = fromStart;
            this.fromEnd = fromStart + fromSize;
            this.toStart = toStart;
            this.toEnd = toStart + toSize;
            this.reverse = reverse;
        }
    }
}

