/*
 * Decompiled with CFR 0.152.
 */
package dev.hardaway.mannequins.core.util;

import net.minecraft.util.Mth;

public final class ScrollHandler {
    public static final float DEFAULT_SCROLL_SPEED = 5.0f;
    public static final float DEFAULT_TRANSITION_SPEED = 0.5f;
    public static final double DEFAULT_MIN_SNAP = (double)0.1f;
    private int height;
    private int visibleHeight;
    private double scroll;
    private double lastScroll;
    private double nextScroll;
    private float scrollSpeed;
    private float transitionSpeed;
    private double minSnap;

    public ScrollHandler(int height, int visibleHeight) {
        this.height = height;
        this.visibleHeight = visibleHeight;
        this.scroll = 0.0;
        this.scrollSpeed = 5.0f;
        this.transitionSpeed = 0.5f;
        this.minSnap = 0.1f;
    }

    public void update() {
        this.lastScroll = this.scroll;
        if (this.getMaxScroll() > 0) {
            double delta = this.nextScroll - this.scroll;
            this.scroll = Math.abs(delta) < this.minSnap ? this.nextScroll : (this.scroll += delta * (double)this.transitionSpeed);
            if (this.scroll < 0.0) {
                this.scroll = 0.0;
                this.nextScroll = 0.0;
            }
            if (this.scroll >= (double)this.getMaxScroll()) {
                this.scroll = this.getMaxScroll();
                this.nextScroll = this.getMaxScroll();
            }
        }
    }

    public boolean mouseScrolled(double maxScroll, double amount) {
        if (this.getMaxScroll() > 0) {
            float scrollAmount = (float)Math.min(Math.abs(amount), maxScroll) * this.getScrollSpeed();
            float finalScroll = (float)(amount < 0.0 ? -1 : 1) * scrollAmount;
            double scroll = Mth.clamp((double)(this.getScroll() - (double)finalScroll), (double)0.0, (double)this.getMaxScroll());
            if (this.getScroll() != scroll) {
                this.scroll(finalScroll);
                return true;
            }
        }
        return false;
    }

    public ScrollHandler scroll(double scrollAmount) {
        this.nextScroll -= scrollAmount;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public ScrollHandler setHeight(int height) {
        this.height = height;
        this.setScroll(this.scroll);
        return this;
    }

    public int getVisibleHeight() {
        return this.visibleHeight;
    }

    public ScrollHandler setVisibleHeight(int visibleHeight) {
        this.visibleHeight = visibleHeight;
        this.setScroll(this.scroll);
        return this;
    }

    public double getScroll() {
        return this.scroll;
    }

    public ScrollHandler setScroll(double scroll) {
        this.nextScroll = this.scroll = Mth.clamp((double)scroll, (double)0.0, (double)(this.height - this.visibleHeight));
        this.lastScroll = this.scroll;
        return this;
    }

    public int getMaxScroll() {
        return Math.max(0, this.height - this.visibleHeight);
    }

    public float getInterpolatedScroll(float partialTicks) {
        return (float)Mth.lerp((double)partialTicks, (double)this.lastScroll, (double)this.scroll);
    }

    public float getScrollSpeed() {
        return this.scrollSpeed;
    }

    public ScrollHandler setScrollSpeed(float scrollSpeed) {
        this.scrollSpeed = Math.max(scrollSpeed, 0.0f);
        return this;
    }

    public double getLastScroll() {
        return this.lastScroll;
    }

    public double getNextScroll() {
        return this.nextScroll;
    }

    public ScrollHandler setTransitionSpeed(float transitionSpeed) {
        this.transitionSpeed = transitionSpeed;
        return this;
    }

    public ScrollHandler setMinSnap(double minSnap) {
        this.minSnap = minSnap;
        return this;
    }
}

