/*
 * Decompiled with CFR 0.152.
 */
package club.mcpvp.consistentdurability;

import club.mcpvp.consistentdurability.DamageCalc;
import club.mcpvp.consistentdurability.listeners.PlayerItemDamageListener;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class ConsistentDurability
extends JavaPlugin {
    public static final NamespacedKey DURABILITY_KEY = new NamespacedKey("consistentdurability", "durability");
    private static final double ELYTRA_DAMAGE_PER_TICK = 0.05;
    private static final double ELYTRA_MINIMUM_DURABILITY = 1.0;

    public void onEnable() {
        this.saveDefaultConfig();
        if (this.getConfig().getBoolean("elytra-durability-fix")) {
            this.scheduleElytraTimer();
        }
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new PlayerItemDamageListener(this), (Plugin)this);
    }

    private void scheduleElytraTimer() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                double currentDurability;
                Integer maxDurability;
                ItemStack item;
                if (!player.isGliding() || player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR || (item = player.getEquipment().getItem(EquipmentSlot.CHEST)).getType() != Material.ELYTRA || item.hasData((DataComponentType)DataComponentTypes.UNBREAKABLE) || (maxDurability = (Integer)item.getData(DataComponentTypes.MAX_DAMAGE)) == null || (currentDurability = DamageCalc.getCurrentDurability(item, maxDurability)) <= 1.0) continue;
                int unbreakingLevel = item.getEnchantmentLevel(Enchantment.UNBREAKING);
                double damage = DamageCalc.calculateToolDamage(0.05, unbreakingLevel);
                double newDurability = currentDurability - damage;
                item.setData(DataComponentTypes.DAMAGE, (Object)(maxDurability - (int)Math.ceil(newDurability)));
                item.editMeta(meta -> {
                    PersistentDataContainer pdc = meta.getPersistentDataContainer();
                    pdc.set(DURABILITY_KEY, PersistentDataType.DOUBLE, (Object)newDurability);
                });
            }
        }, 1L, 1L);
    }
}

