/*
 * Decompiled with CFR 0.152.
 */
package club.mcpvp.consistentdurability.listeners;

import club.mcpvp.consistentdurability.ConsistentDurability;
import club.mcpvp.consistentdurability.DamageCalc;
import io.papermc.paper.datacomponent.DataComponentTypes;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class PlayerItemDamageListener
implements Listener {
    private final ConsistentDurability plugin;

    public PlayerItemDamageListener(ConsistentDurability plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerItemDamage(PlayerItemDamageEvent event) {
        boolean isElytra;
        ItemStack item = event.getItem();
        boolean bl = isElytra = item.getType() == Material.ELYTRA;
        if (isElytra && this.plugin.getConfig().getBoolean("elytra-durability-fix")) {
            event.setCancelled(true);
            return;
        }
        if (!this.plugin.getConfig().getBoolean("unbreaking-rng-removal")) {
            return;
        }
        int originalDamage = event.getOriginalDamage();
        if (originalDamage <= 0) {
            return;
        }
        if (!Tag.ITEMS_ENCHANTABLE_ARMOR.isTagged((Keyed)item.getType()) && !isElytra) {
            return;
        }
        int level = item.getEnchantmentLevel(Enchantment.UNBREAKING);
        if (level <= 0) {
            return;
        }
        Integer maxDurability = (Integer)item.getData(DataComponentTypes.MAX_DAMAGE);
        if (maxDurability == null) {
            return;
        }
        int currentRawDamage = (Integer)item.getDataOrDefault(DataComponentTypes.DAMAGE, (Object)0);
        int currentRawDurability = maxDurability - currentRawDamage;
        double damage = isElytra ? DamageCalc.calculateToolDamage(originalDamage, level) : DamageCalc.calculateArmorDamage(originalDamage, level);
        double currentDurability = DamageCalc.getCurrentDurability(item, maxDurability);
        double newDurability = currentDurability - damage;
        if (newDurability < 1.0E-7) {
            event.setDamage(maxDurability.intValue());
        } else {
            event.setDamage(currentRawDurability - (int)Math.ceil(newDurability));
            item.editMeta(meta -> {
                PersistentDataContainer pdc = meta.getPersistentDataContainer();
                pdc.set(ConsistentDurability.DURABILITY_KEY, PersistentDataType.DOUBLE, (Object)newDurability);
            });
        }
    }
}

