/*
 * Decompiled with CFR 0.152.
 */
package net.nerol.mazerunner.entity.goals;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.nerol.mazerunner.entity.GrieverEntity;
import net.nerol.mazerunner.entity.animations.AttackAnimations;

public class GrieverAttackGoal
extends class_1352 {
    private final GrieverEntity entity;
    private class_1309 target;
    private final double speed;
    private final double wallRange = 36.0;
    private final double sightRange = 200.0;
    private int cooldown;
    private boolean hasLineOfSight;

    public GrieverAttackGoal(GrieverEntity entity, double speed) {
        this.entity = entity;
        this.speed = speed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        List entities = this.entity.method_37908().method_8390(class_1309.class, new class_238(this.entity.method_23317() - 200.0, this.entity.method_23318() - 200.0, this.entity.method_23321() - 200.0, this.entity.method_23317() + 200.0, this.entity.method_23318() + 200.0, this.entity.method_23321() + 200.0), e -> this.isValidTarget((class_1309)e) && e.method_5805());
        class_1309 closestPlayer = entities.stream().filter(e -> e instanceof class_1657).min(Comparator.comparingDouble(e -> e.method_5858((class_1297)this.entity))).orElse(null);
        if (closestPlayer != null && this.canAttack(closestPlayer)) {
            this.target = closestPlayer;
            return true;
        }
        class_1309 closestOther = entities.stream().filter(e -> !(e instanceof class_1657)).min(Comparator.comparingDouble(e -> e.method_5858((class_1297)this.entity))).orElse(null);
        if (closestOther != null && this.canAttack(closestOther)) {
            this.target = closestOther;
            return true;
        }
        this.target = null;
        return false;
    }

    public boolean method_6266() {
        class_1657 player;
        class_1309 class_13092 = this.target;
        if (class_13092 instanceof class_1657 && ((player = (class_1657)class_13092).method_7325() || player.method_68878())) {
            return false;
        }
        return this.target != null && this.target.method_5805();
    }

    public void method_6269() {
        this.entity.method_19540(true);
        if (this.hasLineOfSight) {
            this.entity.setChasing(true);
        }
        this.cooldown = 0;
    }

    public void method_6270() {
        this.target = null;
        this.entity.stopAttacking();
        this.entity.method_19540(false);
        this.entity.setChasing(false);
        this.entity.method_5942().method_6340();
    }

    public void method_6268() {
        if (this.target == null) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        this.hasLineOfSight = this.checkLineOfSight(this.target);
        this.entity.setChasing(this.hasLineOfSight);
        this.moveToTarget();
        double distanceSq = this.entity.method_5858((class_1297)this.target);
        if (distanceSq <= 16.0 && this.isCooledDown()) {
            this.resetCooldown();
            this.entity.method_6104(class_1268.field_5808);
            this.entity.method_6121(GrieverAttackGoal.method_64451((class_1297)this.entity), (class_1297)this.target);
            AttackAnimations.performRandomAttack(this.entity, this.target);
        }
    }

    private void moveToTarget() {
        if (this.target == null) {
            return;
        }
        double speedFactor = this.entity.method_6101() && this.hasLineOfSight ? 1.8 : (this.entity.method_6101() || this.hasLineOfSight ? 1.415 : 1.0);
        this.entity.method_5942().method_6337(this.target.method_23317(), this.target.method_23318(), this.target.method_23321(), this.speed * speedFactor);
    }

    public boolean method_38846() {
        return true;
    }

    private boolean checkLineOfSight(class_1309 targetToCheck) {
        class_3959 context = new class_3959(this.entity.method_5836(1.0f), targetToCheck.method_5836(1.0f), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.entity);
        class_3965 result = this.entity.method_37908().method_17742(context);
        return result.method_17783() == class_239.class_240.field_1333;
    }

    private boolean canAttack(class_1309 possibleTarget) {
        double distSq = this.entity.method_5858((class_1297)possibleTarget);
        if (distSq <= 40000.0 && this.checkLineOfSight(possibleTarget)) {
            return true;
        }
        return distSq <= 1296.0;
    }

    private boolean isValidTarget(class_1309 e) {
        if (e instanceof class_1657) {
            class_1657 player = (class_1657)e;
            return !player.method_7325() && !player.method_68878();
        }
        return e instanceof class_1296 || e.method_5864() == class_1299.field_6077;
    }

    protected void resetCooldown() {
        this.cooldown = this.method_38847(24);
    }

    protected boolean isCooledDown() {
        return this.cooldown <= 0;
    }
}

