/*
 * Decompiled with CFR 0.152.
 */
package net.nerol.mazerunner.entity.animations;

import java.util.Random;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.nerol.mazerunner.SoundEvent.ModSounds;
import net.nerol.mazerunner.effect.ModEffects;
import net.nerol.mazerunner.entity.GrieverEntity;

public class AttackAnimations {
    private static final Random RANDOM = new Random();

    public static void performRandomAttack(GrieverEntity attacker, class_1309 target) {
        String attackType = AttackAnimations.getRandomAttackType();
        AttackAnimations.performAttack(attacker, target, attackType);
    }

    private static String getRandomAttackType() {
        int roll = RANDOM.nextInt(100);
        if (roll < 90) {
            return "bite";
        }
        if (roll >= 95) {
            return "sting";
        }
        return "strike";
    }

    private static void performAttack(GrieverEntity attacker, class_1309 target, String attackType) {
        switch (attackType) {
            case "bite": {
                AttackAnimations.performBiteAttack(attacker, target);
                break;
            }
            case "sting": {
                AttackAnimations.performStingAttack(attacker, target);
                break;
            }
            case "strike": {
                AttackAnimations.performStrikeAttack(attacker, target);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected attack type: " + attackType);
            }
        }
    }

    private static void performBiteAttack(GrieverEntity attacker, class_1309 target) {
        if (attacker.method_5858((class_1297)target) <= 16.0 && !attacker.method_37908().method_8608()) {
            class_3218 serverWorld = (class_3218)attacker.method_37908();
            target.method_64397(serverWorld, serverWorld.method_48963().method_48812((class_1309)attacker), 10.0f);
            attacker.method_5783(ModSounds.GRIEVER_BITE, 1.0f, 1.0f);
            attacker.startBiteAttack();
        }
    }

    private static void performStingAttack(GrieverEntity attacker, class_1309 target) {
        if (attacker.method_5858((class_1297)target) <= 12.25 && !attacker.method_37908().method_8608()) {
            class_3218 serverWorld = (class_3218)attacker.method_37908();
            target.method_64397(serverWorld, serverWorld.method_48963().method_48812((class_1309)attacker), 12.0f);
            attacker.startStingAttack();
            target.method_6092(new class_1293(ModEffects.FLARE, 1728000, 0));
            attacker.method_6092(new class_1293(class_1294.field_5909, 600, 1, false, false));
            attacker.method_6092(new class_1293(class_1294.field_5911, 900, 1, false, false));
            attacker.method_6092(new class_1293(class_1294.field_5901, 600, 0, false, false));
        }
    }

    private static void performStrikeAttack(GrieverEntity attacker, class_1309 target) {
        if (attacker.method_5858((class_1297)target) <= 10.5625 && !attacker.method_37908().method_8608()) {
            class_3218 serverWorld = (class_3218)attacker.method_37908();
            attacker.startStrikeAttack();
            target.method_64397(serverWorld, serverWorld.method_48963().method_48812((class_1309)attacker), 14.0f);
            class_243 direction = target.method_19538().method_1020(attacker.method_19538()).method_1029();
            target.method_5762(direction.field_1352 * 0.45, -0.66, direction.field_1350 * 0.45);
            target.field_6007 = true;
        }
    }
}

