/*
 * Decompiled with CFR 0.152.
 */
package net.nerol.mazerunner.entity.goals;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.nerol.mazerunner.entity.GrieverEntity;
import net.nerol.mazerunner.entity.animations.AttackAnimations;

public class GrieverAttackGoal
extends class_1352 {
    private final GrieverEntity entity;
    private class_1309 target;
    private final double speed;
    private final double wallRange = 36.0;
    private final double sightRange = 200.0;
    private int cooldown;
    private boolean hasLineOfSight;
    private int leapCooldown = 0;
    private int windupTicks = 0;
    private boolean isWindingUp = false;

    public GrieverAttackGoal(GrieverEntity entity, double speed) {
        this.entity = entity;
        this.speed = speed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        List entities = this.entity.method_37908().method_8390(class_1309.class, new class_238(this.entity.method_23317() - 200.0, this.entity.method_23318() - 200.0, this.entity.method_23321() - 200.0, this.entity.method_23317() + 200.0, this.entity.method_23318() + 200.0, this.entity.method_23321() + 200.0), e -> this.isValidTarget((class_1309)e) && e.method_5805());
        class_1309 closestPlayer = entities.stream().filter(e -> e instanceof class_1657).min(Comparator.comparingDouble(e -> e.method_5858((class_1297)this.entity))).orElse(null);
        if (closestPlayer != null && this.canAttack(closestPlayer)) {
            this.target = closestPlayer;
            this.entity.method_5980(this.target);
            return true;
        }
        class_1309 closestOther = entities.stream().filter(e -> !(e instanceof class_1657)).min(Comparator.comparingDouble(e -> e.method_5858((class_1297)this.entity))).orElse(null);
        if (closestOther != null && this.canAttack(closestOther)) {
            this.target = closestOther;
            this.entity.method_5980(this.target);
            return true;
        }
        this.target = null;
        this.entity.method_5980(null);
        return false;
    }

    public boolean method_6266() {
        class_1657 player;
        class_1309 class_13092 = this.target;
        if (class_13092 instanceof class_1657 && ((player = (class_1657)class_13092).method_7325() || player.method_68878())) {
            return false;
        }
        return this.target != null && this.target.method_5805();
    }

    public void method_6269() {
        this.entity.method_19540(true);
        if (this.hasLineOfSight) {
            this.entity.setChasing(true);
        }
        this.cooldown = 0;
    }

    public void method_6270() {
        this.target = null;
        this.entity.method_5980(null);
        this.entity.stopAttacking();
        this.entity.method_19540(false);
        this.entity.setChasing(false);
        this.entity.setLeaping(false);
        this.entity.method_5942().method_6340();
    }

    public void method_6268() {
        if (this.target == null) {
            return;
        }
        this.target = this.entity.method_5968();
        if (this.entity.isRoaring()) {
            this.entity.method_18799(class_243.field_1353);
            this.entity.method_5942().method_6340();
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.leapCooldown > 0) {
            --this.leapCooldown;
        }
        this.hasLineOfSight = this.checkLineOfSight(this.target);
        this.entity.setChasing(this.hasLineOfSight);
        double distanceSq = this.entity.method_5858((class_1297)this.target);
        if (!this.isWindingUp && distanceSq > 625.0 && this.hasLineOfSight && this.isCooledDown() && this.leapCooldown <= 0) {
            this.resetCooldown();
            this.entity.setLeaping(true);
            this.leapCooldown = 400;
            this.windupTicks = 9;
            this.isWindingUp = true;
            this.entity.method_5942().method_6340();
            this.entity.method_18799(class_243.field_1353);
            this.entity.method_5988().method_6226((class_1297)this.target, 30.0f, 30.0f);
            return;
        }
        if (this.isWindingUp) {
            --this.windupTicks;
            if (this.windupTicks <= 0) {
                this.leapTowardTarget();
                this.leapCooldown = 400;
                this.isWindingUp = false;
            }
            return;
        }
        if (this.entity.method_24828()) {
            this.entity.setLeaping(false);
        }
        this.moveToTarget();
        if (distanceSq <= 16.0 && this.isCooledDown()) {
            this.resetCooldown();
            this.entity.method_6104(class_1268.field_5808);
            this.entity.method_6121(GrieverAttackGoal.method_64451((class_1297)this.entity), (class_1297)this.target);
            AttackAnimations.performRandomAttack(this.entity, this.target);
        }
    }

    private void leapTowardTarget() {
        class_243 from = this.entity.method_19538();
        class_243 to = this.target.method_19538();
        double dx = to.field_1352 - from.field_1352;
        double dz = to.field_1350 - from.field_1350;
        double dy = to.field_1351 - from.field_1351;
        class_243 horizontal = new class_243(dx, 0.0, dz);
        double horizontalDistance = horizontal.method_1033();
        if (horizontalDistance < 1.0E-6) {
            return;
        }
        class_243 direction = horizontal.method_1029();
        double horizontalVelocity = 2.75;
        class_243 leapHorizontal = direction.method_1021(horizontalVelocity);
        double verticalBoost = 1.0 + class_3532.method_15350((double)(dy / 10.0), (double)0.0, (double)0.3);
        class_243 leapVelocity = new class_243(leapHorizontal.field_1352, verticalBoost, leapHorizontal.field_1350);
        this.entity.method_18799(leapVelocity);
        this.entity.field_6007 = true;
    }

    private void moveToTarget() {
        if (this.target == null || this.entity.isRoaring()) {
            return;
        }
        double speedFactor = this.entity.method_6101() && this.hasLineOfSight ? 1.8 : (this.entity.method_6101() || this.hasLineOfSight ? 1.415 : 1.0);
        this.entity.method_5942().method_6337(this.target.method_23317(), this.target.method_23318(), this.target.method_23321(), this.speed * speedFactor);
    }

    public boolean method_38846() {
        return true;
    }

    private boolean checkLineOfSight(class_1309 targetToCheck) {
        class_3959 context = new class_3959(this.entity.method_5836(1.0f), targetToCheck.method_5836(1.0f), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.entity);
        class_3965 result = this.entity.method_37908().method_17742(context);
        return result.method_17783() == class_239.class_240.field_1333;
    }

    private boolean canAttack(class_1309 possibleTarget) {
        double distSq = this.entity.method_5858((class_1297)possibleTarget);
        if (distSq <= 40000.0 && this.checkLineOfSight(possibleTarget)) {
            return true;
        }
        return distSq <= 1296.0;
    }

    private boolean isValidTarget(class_1309 e) {
        if (e instanceof class_1657) {
            class_1657 player = (class_1657)e;
            return !player.method_7325() && !player.method_68878();
        }
        return e instanceof class_1296 || e.method_5864() == class_1299.field_6077;
    }

    protected void resetCooldown() {
        this.cooldown = this.method_38847(24);
    }

    protected boolean isCooledDown() {
        return this.cooldown <= 0;
    }
}

