/*
 * Decompiled with CFR 0.152.
 */
package net.nerol.mazerunner.entity;

import java.util.List;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1408;
import net.minecraft.class_1410;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import net.nerol.mazerunner.SoundEvent.ModSounds;
import net.nerol.mazerunner.effect.ModEffects;
import net.nerol.mazerunner.entity.goals.GrieverAmbientGoal;
import net.nerol.mazerunner.entity.goals.GrieverAttackGoal;
import net.nerol.mazerunner.entity.goals.GrieverRoarGoal;
import net.nerol.mazerunner.item.ModItems;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GrieverEntity
extends class_1588
implements GeoAnimatable {
    private static final Random random = new Random();
    private boolean biteAnimationTriggered = false;
    private boolean stingAnimationTriggered = false;
    private boolean strikeAnimationTriggered = false;
    private boolean sniffAnimationTriggered = false;
    private boolean roarAnimationTriggered = false;
    private static final class_2940<Boolean> CHASING = class_2945.method_12791(GrieverEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> BITE_TICKS = class_2945.method_12791(GrieverEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> BITE_ATTACK = class_2945.method_12791(GrieverEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> STING_TICKS = class_2945.method_12791(GrieverEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> STING_ATTACK = class_2945.method_12791(GrieverEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> STRIKE_TICKS = class_2945.method_12791(GrieverEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> STRIKE_ATTACK = class_2945.method_12791(GrieverEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> ROAR_TICKS = class_2945.method_12791(GrieverEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> IS_ROARING = class_2945.method_12791(GrieverEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> SNIFF_TICKS = class_2945.method_12791(GrieverEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SNIFFING = class_2945.method_12791(GrieverEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CLIMBING = class_2945.method_12791(GrieverEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> LEAPING = class_2945.method_12791(GrieverEntity.class, (class_2941)class_2943.field_13323);
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("animation.idle");
    protected static final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("animation.walk");
    protected static final RawAnimation ATTACK_BITE_ANIM = RawAnimation.begin().thenPlay("animation.attack_bite");
    protected static final RawAnimation CHASE_ANIM = RawAnimation.begin().thenLoop("animation.chase");
    protected static final RawAnimation ATTACK_STING_ANIM = RawAnimation.begin().thenPlay("animation.attack_sting");
    protected static final RawAnimation ATTACK_STRIKE_ANIM = RawAnimation.begin().thenPlay("animation.attack_strike");
    protected static final RawAnimation CLIMB_ANIM = RawAnimation.begin().thenLoop("animation.climb");
    protected static final RawAnimation SNIFF_ANIM = RawAnimation.begin().thenPlay("animation.sniff");
    protected static final RawAnimation ROAR_ANIM = RawAnimation.begin().thenPlay("animation.roar");
    protected static final RawAnimation LEAP_ANIM = RawAnimation.begin().thenPlayAndHold("animation.leap");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public GrieverEntity(class_1299<? extends GrieverEntity> type, class_1937 world) {
        super(type, world);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(CHASING, (Object)false);
        builder.method_56912(BITE_TICKS, (Object)0);
        builder.method_56912(BITE_ATTACK, (Object)false);
        builder.method_56912(STING_TICKS, (Object)0);
        builder.method_56912(STING_ATTACK, (Object)false);
        builder.method_56912(STRIKE_TICKS, (Object)0);
        builder.method_56912(STRIKE_ATTACK, (Object)false);
        builder.method_56912(ROAR_TICKS, (Object)0);
        builder.method_56912(IS_ROARING, (Object)false);
        builder.method_56912(SNIFF_TICKS, (Object)0);
        builder.method_56912(SNIFFING, (Object)false);
        builder.method_56912(CLIMBING, (Object)false);
        builder.method_56912(LEAPING, (Object)false);
    }

    public void setChasing(boolean chasing) {
        this.field_6011.method_12778(CHASING, (Object)chasing);
    }

    public boolean isChasing() {
        return (Boolean)this.field_6011.method_12789(CHASING);
    }

    public void startBiteAttack() {
        if (!this.biteAnimationTriggered) {
            this.field_6011.method_12778(BITE_ATTACK, (Object)true);
            this.biteAnimationTriggered = true;
            this.field_6011.method_12778(BITE_TICKS, (Object)14);
        }
    }

    public void startStingAttack() {
        if (!this.stingAnimationTriggered) {
            this.field_6011.method_12778(STING_ATTACK, (Object)true);
            this.stingAnimationTriggered = true;
            this.field_6011.method_12778(STING_TICKS, (Object)20);
        }
    }

    public void startStrikeAttack() {
        if (!this.strikeAnimationTriggered) {
            this.field_6011.method_12778(STRIKE_ATTACK, (Object)true);
            this.strikeAnimationTriggered = true;
            this.field_6011.method_12778(STRIKE_TICKS, (Object)18);
        }
    }

    public void stopAttacking() {
        this.field_6011.method_12778(BITE_TICKS, (Object)0);
        this.field_6011.method_12778(STRIKE_TICKS, (Object)0);
        this.field_6011.method_12778(STING_TICKS, (Object)0);
        this.field_6011.method_12778(BITE_ATTACK, (Object)false);
        this.field_6011.method_12778(STRIKE_ATTACK, (Object)false);
        this.field_6011.method_12778(STING_ATTACK, (Object)false);
        this.biteAnimationTriggered = false;
        this.stingAnimationTriggered = false;
        this.strikeAnimationTriggered = false;
    }

    public void setRoaring(boolean bool) {
        if (!this.roarAnimationTriggered) {
            this.field_6011.method_12778(IS_ROARING, (Object)bool);
            this.field_6011.method_12778(ROAR_TICKS, (Object)44);
            this.roarAnimationTriggered = true;
            this.method_5942().method_6340();
            this.method_18799(class_243.field_1353);
        }
    }

    public boolean isRoaring() {
        return (Boolean)this.field_6011.method_12789(IS_ROARING);
    }

    public void setSniffing(boolean bool) {
        if (!this.sniffAnimationTriggered) {
            this.field_6011.method_12778(SNIFFING, (Object)bool);
            this.field_6011.method_12778(SNIFF_TICKS, (Object)28);
            this.sniffAnimationTriggered = true;
            this.method_5942().method_6340();
            this.method_18799(class_243.field_1353);
        }
    }

    public void setLeaping(boolean bool) {
        this.field_6011.method_12778(LEAPING, (Object)bool);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return this.field_6012;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.leapController());
        controllers.add(this.sniffController());
        controllers.add(this.roarController());
        controllers.add(this.climbController());
        controllers.add(this.attackAnimations());
        controllers.add(this.walkIdleChaseController());
    }

    protected <T extends GeoAnimatable> AnimationController<T> leapController() {
        return new AnimationController("Leap", 0, test -> {
            if (((Boolean)this.field_6011.method_12789(LEAPING)).booleanValue() && !this.isRoaring()) {
                return test.setAndContinue(LEAP_ANIM);
            }
            test.controller().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    protected <T extends GeoAnimatable> AnimationController<T> climbController() {
        return new AnimationController("Climb", 0, test -> {
            if (this.method_6101()) {
                return test.setAndContinue(CLIMB_ANIM);
            }
            return PlayState.STOP;
        });
    }

    protected <T extends GeoAnimatable> AnimationController<T> attackAnimations() {
        return new AnimationController("Attack", 0, state -> {
            if (((Boolean)this.field_6011.method_12789(BITE_ATTACK)).booleanValue()) {
                return state.setAndContinue(ATTACK_BITE_ANIM);
            }
            if (((Boolean)this.field_6011.method_12789(STING_ATTACK)).booleanValue()) {
                return state.setAndContinue(ATTACK_STING_ANIM);
            }
            if (((Boolean)this.field_6011.method_12789(STRIKE_ATTACK)).booleanValue()) {
                return state.setAndContinue(ATTACK_STRIKE_ANIM);
            }
            state.controller().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    protected <T extends GeoAnimatable> AnimationController<T> walkIdleChaseController() {
        return new AnimationController("walkIdleChase", state -> {
            if (((Boolean)this.field_6011.method_12789(LEAPING)).booleanValue() || ((Boolean)this.field_6011.method_12789(SNIFFING)).booleanValue() || ((Boolean)this.field_6011.method_12789(IS_ROARING)).booleanValue() || this.method_6101() || ((Boolean)this.field_6011.method_12789(BITE_ATTACK)).booleanValue() || ((Boolean)this.field_6011.method_12789(STING_ATTACK)).booleanValue() || ((Boolean)this.field_6011.method_12789(STRIKE_ATTACK)).booleanValue()) {
                return PlayState.STOP;
            }
            return state.isMoving() ? state.setAndContinue(this.isChasing() ? CHASE_ANIM : WALK_ANIM) : state.setAndContinue(IDLE_ANIM);
        });
    }

    protected <T extends GeoAnimatable> AnimationController<T> sniffController() {
        return new AnimationController("Sniff", 0, event -> {
            if (((Boolean)this.field_6011.method_12789(SNIFFING)).booleanValue() && !((Boolean)this.field_6011.method_12789(IS_ROARING)).booleanValue()) {
                return event.setAndContinue(SNIFF_ANIM);
            }
            event.controller().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    protected <T extends GeoAnimatable> AnimationController<T> roarController() {
        return new AnimationController("Roar", 0, event -> {
            if (((Boolean)this.field_6011.method_12789(IS_ROARING)).booleanValue() && !((Boolean)this.field_6011.method_12789(SNIFFING)).booleanValue()) {
                return event.setAndContinue(ROAR_ANIM);
            }
            event.controller().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    public void method_6005(double strength, double x, double z) {
        if (this.method_6101() || this.isRoaring()) {
            return;
        }
        super.method_6005(strength, x, z);
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_6101() && this.field_5976) {
            this.method_18800(this.method_18798().field_1352, 0.25, this.method_18798().field_1350);
            this.method_18799(this.method_18798().method_18805(1.0, 1.0, 1.0));
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_6059(ModEffects.FLARE)) {
            this.method_6016(ModEffects.FLARE);
        }
        if (!this.method_37908().field_9236) {
            this.field_6011.method_12778(CLIMBING, (Object)this.field_5976);
            this.decrementTicks(BITE_TICKS, BITE_ATTACK);
            this.decrementTicks(STING_TICKS, STING_ATTACK);
            this.decrementTicks(STRIKE_TICKS, STRIKE_ATTACK);
            this.decrementTicks(ROAR_TICKS, IS_ROARING);
            this.decrementTicks(SNIFF_TICKS, SNIFFING);
        }
    }

    public boolean method_6101() {
        return (Boolean)this.field_6011.method_12789(CLIMBING);
    }

    protected class_1408 method_5965(class_1937 world) {
        return new class_1410((class_1308)this, world);
    }

    private void decrementTicks(class_2940<Integer> tickData, class_2940<Boolean> data) {
        int ticks = (Integer)this.field_6011.method_12789(tickData);
        if (ticks > 0) {
            this.field_6011.method_12778(tickData, (Object)(--ticks));
            if (ticks == 0) {
                this.field_6011.method_12778(data, (Object)false);
                if (tickData == BITE_TICKS) {
                    this.biteAnimationTriggered = false;
                }
                if (tickData == STING_TICKS) {
                    this.stingAnimationTriggered = false;
                }
                if (tickData == STRIKE_TICKS) {
                    this.strikeAnimationTriggered = false;
                }
                if (tickData == SNIFF_TICKS) {
                    this.setSniffing(false);
                }
                if (tickData == ROAR_TICKS) {
                    this.setRoaring(false);
                }
            }
        }
    }

    protected void method_5959() {
        this.field_6189 = new class_1410((class_1308)this, this.method_37908());
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new GrieverRoarGoal(this));
        this.field_6201.method_6277(1, (class_1352)new GrieverAttackGoal(this, 1.05));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(4, (class_1352)new GrieverAmbientGoal(this));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23724, 6.0).method_26868(class_5134.field_23723, 4.5).method_26868(class_5134.field_51583, 3.0).method_26868(class_5134.field_23721, 9.0).method_26868(class_5134.field_49079, 10.0).method_26868(class_5134.field_23728, (double)0.2f).method_26868(class_5134.field_23717, 240.0).method_26868(class_5134.field_23718, (double)0.65f).method_26868(class_5134.field_49077, 0.5).method_26868(class_5134.field_47759, (double)3.4f).method_26868(class_5134.field_23725, 2.5).method_26868(class_5134.field_47761, 1.5).method_26868(class_5134.field_51578, (double)0.1f).method_26868(class_5134.field_23716, 120.0).method_26868(class_5134.field_23719, 0.3);
    }

    public void method_6078(class_1282 source) {
        super.method_6078(source);
        if (!this.method_37908().method_8608()) {
            int randomDrops = random.nextInt(5) + 3;
            class_3218 serverWorld = (class_3218)this.method_37908();
            class_1542 netherite_scrap = new class_1542((class_1937)serverWorld, this.method_23317(), this.method_23318(), this.method_23321(), new class_1799((class_1935)class_1802.field_22021, randomDrops));
            randomDrops = random.nextInt(6) + 4;
            class_1542 rotten_flesh = new class_1542((class_1937)serverWorld, this.method_23317(), this.method_23318(), this.method_23321(), new class_1799((class_1935)class_1802.field_8511, randomDrops));
            class_1542 flare_injector = new class_1542((class_1937)serverWorld, this.method_23317(), this.method_23318(), this.method_23321(), new class_1799((class_1935)ModItems.FLARE_INJECTOR, 1));
            serverWorld.method_8649((class_1297)netherite_scrap);
            serverWorld.method_8649((class_1297)rotten_flesh);
            serverWorld.method_8649((class_1297)flare_injector);
            List nearbyGrievers = this.method_37908().method_8390(GrieverEntity.class, this.method_5829().method_1014(75.0), e -> e != this);
            for (GrieverEntity otherGriever : nearbyGrievers) {
                class_1309 currentTarget;
                if (!otherGriever.method_5805() || (currentTarget = otherGriever.method_5968()) instanceof class_1657) continue;
                otherGriever.method_5980(this.method_5968());
            }
        }
    }

    protected class_3414 method_5994() {
        return (class_3414)class_7923.field_41172.method_63535(class_2960.method_60655((String)"mazerunner", (String)"griever.idle"));
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15007;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(ModSounds.GRIEVER_WALK, 0.25f, 1.0f);
    }

    protected class_3414 method_6002() {
        return ModSounds.GRIEVER_ROAR;
    }
}

