/*
 * Decompiled with CFR 0.152.
 */
package dev.joee.btagraves.render;

import com.b100.json.JsonParser;
import com.b100.json.element.JsonArray;
import com.b100.json.element.JsonObject;
import com.b100.utils.StringUtils;
import com.mojang.logging.LogUtils;
import dev.joee.btagraves.tileentity.TileEntityGrave;
import java.util.Base64;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class FetchSkinThread
extends Thread {
    private static int counter = 0;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final JsonParser jsonParser = new JsonParser();
    private final TileEntityGrave tileEntity;
    private static final HashMap<UUID, Future<String>> skinUrls = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FetchSkinThread(TileEntityGrave te) {
        this.tileEntity = te;
        UUID uuid = this.tileEntity.getUUID();
        HashMap<UUID, Future<String>> hashMap = skinUrls;
        synchronized (hashMap) {
            if (skinUrls.containsKey(uuid)) {
                if (skinUrls.get(uuid).isDone()) {
                    try {
                        this.tileEntity.skinUrl = skinUrls.get(uuid).get();
                    }
                    catch (Exception exception) {}
                }
            } else {
                Future<String> url = executor.submit(() -> this.getSkinUrl(uuid));
                skinUrls.put(uuid, url);
                skinUrls.notifyAll();
            }
        }
        if (!skinUrls.containsKey(uuid) || !skinUrls.get(uuid).isDone()) {
            this.setDaemon(true);
            this.setName("FetchSkinThread " + counter++);
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        UUID uuid = this.tileEntity.getUUID();
        try {
            HashMap<UUID, Future<String>> hashMap = skinUrls;
            synchronized (hashMap) {
                while (!skinUrls.containsKey(uuid)) {
                    skinUrls.wait(500L);
                }
                this.tileEntity.skinUrl = skinUrls.get(uuid).get();
            }
        }
        catch (InterruptedException | NullPointerException | ExecutionException e) {
            LOGGER.error("Failed to fetch skin for {}", (Object)uuid);
        }
    }

    private static String decodeBase64(String string) {
        return new String(Base64.getDecoder().decode(string));
    }

    private String getSkinObject(UUID uuid) {
        try {
            return StringUtils.getWebsiteContentAsString((String)("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid));
        }
        catch (Exception var4) {
            return null;
        }
    }

    @Nullable
    private String getSkinUrl(UUID uuid) {
        if (uuid != null) {
            JsonObject object;
            JsonArray properties;
            JsonObject textureProperty;
            JsonObject texturesObject;
            String string = null;
            for (int i = 0; i < 3 && (string = this.getSkinObject(uuid)) == null; ++i) {
                try {
                    FetchSkinThread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException var7) {
                    break;
                }
            }
            if (string != null && (texturesObject = jsonParser.parse((Object)FetchSkinThread.decodeBase64((textureProperty = (properties = (object = jsonParser.parse((Object)string)).getArray("properties")).query(e -> e.getAsObject().getString("name").equalsIgnoreCase("textures")).getAsObject()).getString("value"))).getObject("textures")).has("SKIN")) {
                return texturesObject.getObject("SKIN").getString("url") + "?btagraves";
            }
        }
        return null;
    }
}

