/*
 * Decompiled with CFR 0.152.
 */
package dev.joee.btagraves.render;

import dev.joee.btagraves.render.GraveSkinParser;
import dev.joee.btagraves.tileentity.TileEntityGrave;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.render.ImageParser;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.font.FontRendererDefault;
import net.minecraft.client.render.font.SF;
import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.block.Block;
import net.minecraft.core.world.WorldSource;
import org.lwjgl.opengl.GL11;

public class TileEntityRendererGrave
extends TileEntityRenderer<TileEntityGrave> {
    private static final FontRenderer FONT_RENDERER = new FontRendererDefault();
    private static final Pattern FORMAT_PATTERN = Pattern.compile("\u00a7[0-9a-fk-or]|\u00a7<.*?>");
    private final Cube mainCube = new Cube(0, 0, 28, 24);

    public TileEntityRendererGrave() {
        this.mainCube.addBox(0.0f, 0.0f, 0.0f, 10, 16, 4);
    }

    public void doRender(Tessellator t, TileEntityGrave te, double x, double y, double z, float partialTick) {
        float headOffsetX;
        Block block = te.getBlock();
        if (block == null) {
            return;
        }
        if (LightmapHelper.isLightmapEnabled()) {
            int coord = block.getLightmapCoord((WorldSource)te.worldObj, te.x, te.y, te.z);
            LightmapHelper.setLightmapCoord((int)coord);
        }
        float scale = 0.0625f;
        GL11.glDisable((int)2896);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-8.0f, (float)-16.0f, (float)8.0f);
        float[] angles = new float[]{270.0f, 90.0f, 0.0f, 180.0f};
        float angle = angles[te.getBlockMeta() & 3];
        GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-5.0f, (float)0.0f, (float)0.0f);
        this.renderDispatcher.textureManager.bindTexture(this.renderDispatcher.textureManager.loadTexture("/assets/btagraves/textures/block/grave.png"));
        this.mainCube.render(1.0f);
        this.renderDispatcher.textureManager.bindDownloadableTexture(te.skinUrl, "/assets/btagraves/textures/block/head.png", (ImageParser)GraveSkinParser.instance);
        float headOffsetY = headOffsetX = 3.0f;
        float epsilon = 0.001f;
        t.startDrawingQuads();
        t.addVertexWithUV((double)(headOffsetX + 4.0f), (double)(headOffsetY + 0.0f), (double)(-epsilon), 1.0, 0.0);
        t.addVertexWithUV((double)(headOffsetX + 0.0f), (double)(headOffsetY + 0.0f), (double)(-epsilon), 0.0, 0.0);
        t.addVertexWithUV((double)(headOffsetX + 0.0f), (double)(headOffsetY + 4.0f), (double)(-epsilon), 0.0, 1.0);
        t.addVertexWithUV((double)(headOffsetX + 4.0f), (double)(headOffsetY + 4.0f), (double)(-epsilon), 1.0, 1.0);
        t.draw();
        GL11.glPopMatrix();
        float textScale = 0.08f;
        GL11.glTranslatef((float)0.0f, (float)8.0f, (float)(-epsilon));
        GL11.glScalef((float)textScale, (float)textScale, (float)textScale);
        GL11.glDepthMask((boolean)false);
        String text = te.deathMessage;
        int maxWidth = 70;
        List<String> lines = TileEntityRendererGrave.wrapText(TileEntityRendererGrave.propagateFormattingToWords(text), maxWidth);
        for (int i = 0; i < lines.size(); ++i) {
            FONT_RENDERER.renderWidthConstrained(t, (CharSequence)lines.get(i), -FONT_RENDERER.stringWidth((CharSequence)lines.get(i)) / 2, i * 14, maxWidth).setConfig(SF.setOutlined((long)0L)).call();
        }
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
    }

    private static List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() == 0 ? word : currentLine + " " + word;
            if (FONT_RENDERER.stringWidth((CharSequence)testLine) <= maxWidth) {
                currentLine.setLength(0);
                currentLine.append(testLine);
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine.setLength(0);
            }
            if (FONT_RENDERER.stringWidth((CharSequence)word) > maxWidth) {
                StringBuilder splitWord = new StringBuilder();
                for (char c : word.toCharArray()) {
                    splitWord.append(c);
                    if (FONT_RENDERER.stringWidth((CharSequence)splitWord.toString()) <= maxWidth) continue;
                    splitWord.setLength(splitWord.length() - 1);
                    lines.add(splitWord.toString());
                    splitWord.setLength(0);
                    splitWord.append(c);
                }
                currentLine.append((CharSequence)splitWord);
                continue;
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public static String propagateFormattingToWords(String input) {
        StringBuilder output = new StringBuilder();
        StringBuilder activeFormats = new StringBuilder();
        StringBuilder wordBuffer = new StringBuilder();
        Matcher formatMatcher = FORMAT_PATTERN.matcher(input);
        int i = 0;
        while (i < input.length()) {
            if (formatMatcher.find(i) && formatMatcher.start() == i) {
                String formatCode = formatMatcher.group();
                wordBuffer.append(formatCode);
                i += formatCode.length();
                if (formatCode.equals("\u00a7r")) {
                    activeFormats.setLength(0);
                    continue;
                }
                if (formatCode.matches("\u00a7[0-9a-fr]")) {
                    TileEntityRendererGrave.removeColorAndReset(activeFormats);
                }
                activeFormats.append(formatCode);
                continue;
            }
            char c = input.charAt(i);
            if (Character.isWhitespace(c)) {
                if (wordBuffer.length() > 0) {
                    output.append((CharSequence)activeFormats).append((CharSequence)wordBuffer);
                    wordBuffer.setLength(0);
                }
                output.append(c);
            } else {
                wordBuffer.append(c);
            }
            ++i;
        }
        if (wordBuffer.length() > 0) {
            output.append((CharSequence)activeFormats).append((CharSequence)wordBuffer);
        }
        return output.toString();
    }

    private static void removeColorAndReset(StringBuilder formats) {
        Matcher m = FORMAT_PATTERN.matcher(formats.toString());
        StringBuilder newFormats = new StringBuilder();
        while (m.find()) {
            String f = m.group();
            if (f.matches("\u00a7[0-9a-fr]")) continue;
            newFormats.append(f);
        }
        formats.setLength(0);
        formats.append((CharSequence)newFormats);
    }
}

