/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import net.elton.windmeter.Data.WindmeterData;
import net.elton.windmeter.WindmeterClientConfig;
import net.elton.windmeter.block.ModBlocks;
import net.elton.windmeter.block.entity.ModBlockEntities;
import net.elton.windmeter.block.entity.renderer.CupAnemometerBlockEntityRenderer;
import net.elton.windmeter.block.entity.renderer.CupAnemometerModel;
import net.elton.windmeter.block.entity.renderer.GardenWindmillBlockEntityRenderer;
import net.elton.windmeter.block.entity.renderer.GardenWindmillModel;
import net.elton.windmeter.block.entity.renderer.ProbeBlockEntityRenderer;
import net.elton.windmeter.block.entity.renderer.ProbeModel;
import net.elton.windmeter.block.entity.renderer.WeatherDisplayBlockEntityRenderer;
import net.elton.windmeter.block.entity.renderer.WeatherDisplayModel;
import net.elton.windmeter.block.entity.renderer.WindDisplayBlockEntityRenderer;
import net.elton.windmeter.block.entity.renderer.WindDisplayModel;
import net.elton.windmeter.block.entity.renderer.WindSockBlockEntityRenderer;
import net.elton.windmeter.block.entity.renderer.WindSockModel;
import net.elton.windmeter.block.entity.renderer.WindVaneBlockEntityRenderer;
import net.elton.windmeter.block.entity.renderer.WindVaneModel;
import net.elton.windmeter.block.entity.renderer.WindmeterBlockEntityRenderer;
import net.elton.windmeter.block.entity.renderer.WindmeterHDBlockEntityRenderer;
import net.elton.windmeter.block.entity.renderer.WindmeterHDModel;
import net.elton.windmeter.block.entity.renderer.WindmeterModel;
import net.elton.windmeter.command.WindmeterCommands;
import net.elton.windmeter.component.ModDataComponents;
import net.elton.windmeter.item.ModItems;
import net.elton.windmeter.network.ChannelDataDisp;
import net.elton.windmeter.network.ChannelDataWM;
import net.elton.windmeter.network.ClientPayloadHandler;
import net.elton.windmeter.network.ClientPayloadHandlerDisp;
import net.elton.windmeter.network.ClientPayloadHandlerPos;
import net.elton.windmeter.network.PosDataWM;
import net.elton.windmeter.network.ServerPayloadHandler;
import net.elton.windmeter.network.ServerPayloadHandlerDisp;
import net.elton.windmeter.network.ServerPayloadHandlerPos;
import net.elton.windmeter.screen.ModMenuTypes;
import net.elton.windmeter.screen.custon.CupAnemometerScreen;
import net.elton.windmeter.screen.custon.WeatherDisplayScreen;
import net.elton.windmeter.screen.custon.WindDisplayScreen;
import net.elton.windmeter.screen.custon.WindmeterHDScreen;
import net.elton.windmeter.screen.custon.WindmeterScreen;
import net.elton.windmeter.ui.ModTabs;
import net.elton.windmeter.util.ModItemProperties;
import net.elton.windmeter.util.WindmeterServerConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.neoforged.neoforge.server.command.ConfigCommand;
import org.slf4j.Logger;

@Mod(value="windmeter")
public class WindMeter {
    public static final String MODID = "windmeter";
    private static final Logger LOGGER = LogUtils.getLogger();

    public WindMeter(IEventBus modEventBus, FMLModContainer modContainer, Dist dist) {
        NeoForge.EVENT_BUS.register((Object)this);
        ModTabs.CREATIVE_TABS.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        NeoForge.EVENT_BUS.register((Object)new EventHandler(this));
        ModDataComponents.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)WindmeterServerConfig.SPEC);
        if (dist.isClient()) {
            modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)WindmeterClientConfig.SPEC);
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM WINDMETER");
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Windmeter loaded");
    }

    public static ResourceLocation getPath(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public class EventHandler {
        public EventHandler(WindMeter this$0) {
        }

        @SubscribeEvent
        public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player entity = event.getEntity();
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (!entity.level().isClientSide()) {
                assert (server != null);
                WindmeterData data = WindmeterData.requestData(server);
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new PosDataWM(data.posArrayX.subList(0, 102), data.posArrayY.subList(0, 102), data.posArrayZ.subList(0, 102)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        @SubscribeEvent
        public void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player entity = event.getEntity();
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (!entity.level().isClientSide()) {
                assert (server != null);
                WindmeterData data = WindmeterData.requestData(server);
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new PosDataWM(data.posArrayX.subList(0, 102), data.posArrayY.subList(0, 102), data.posArrayZ.subList(0, 102)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @EventBusSubscriber(modid="windmeter", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ModItemProperties.addCustomItemProperties();
            LOGGER.info("HELLO FROM CLIENT WINDMETER");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
        }
    }

    @EventBusSubscriber(modid="windmeter", bus=EventBusSubscriber.Bus.GAME)
    public class GameBusEvents {
        public GameBusEvents(WindMeter this$0) {
        }

        @SubscribeEvent
        public static void onCommandsRegister(RegisterCommandsEvent event) {
            new WindmeterCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
            ConfigCommand.register((CommandDispatcher)event.getDispatcher());
        }
    }

    @EventBusSubscriber(modid="windmeter", bus=EventBusSubscriber.Bus.MOD, value={Dist.DEDICATED_SERVER})
    public class ModBusCommonEvents {
        public ModBusCommonEvents(WindMeter this$0) {
        }

        @SubscribeEvent
        public static void register(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar(WindMeter.MODID);
            registrar.playBidirectional(ChannelDataWM.TYPE, ChannelDataWM.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(ClientPayloadHandler::handleDataOnMain, ServerPayloadHandler::handleDataOnMain));
            registrar.playBidirectional(ChannelDataDisp.TYPE, ChannelDataDisp.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(ClientPayloadHandlerDisp::handleDataOnMain, ServerPayloadHandlerDisp::handleDataOnMain));
            registrar.playToClient(PosDataWM.TYPE, PosDataWM.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(ClientPayloadHandlerPos::handleDataOnMain, ServerPayloadHandlerPos::handleDataOnMain));
        }
    }

    @EventBusSubscriber(modid="windmeter", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public class ModBusClientEvents {
        public ModBusClientEvents(WindMeter this$0) {
        }

        @SubscribeEvent
        public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(WindmeterModel.LAYER_LOCATION, WindmeterModel::createBodyLayer);
            event.registerLayerDefinition(WindmeterHDModel.LAYER_LOCATION, WindmeterHDModel::createBodyLayer);
            event.registerLayerDefinition(CupAnemometerModel.LAYER_LOCATION, CupAnemometerModel::createBodyLayer);
            event.registerLayerDefinition(ProbeModel.LAYER_LOCATION, ProbeModel::createBodyLayer);
            event.registerLayerDefinition(WindVaneModel.LAYER_LOCATION, WindVaneModel::createBodyLayer);
            event.registerLayerDefinition(WindSockModel.LAYER_LOCATION, WindSockModel::createBodyLayer);
            event.registerLayerDefinition(GardenWindmillModel.LAYER_LOCATION, GardenWindmillModel::createBodyLayer);
            event.registerLayerDefinition(WindDisplayModel.LAYER_WIND_DISPLAY, WindDisplayModel::createBodyLayer);
            event.registerLayerDefinition(WeatherDisplayModel.LAYER_WEATHER_DISPLAY, WeatherDisplayModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(ModBlockEntities.WINDMETER_BE.get(), WindmeterBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(ModBlockEntities.WINDMETER_HD_BE.get(), WindmeterHDBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(ModBlockEntities.CUP_ANEMOMETER_BE.get(), CupAnemometerBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(ModBlockEntities.WIND_VANE_BE.get(), WindVaneBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(ModBlockEntities.WIND_SOCK_BE.get(), WindSockBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(ModBlockEntities.WIND_DISPLAY_BE.get(), WindDisplayBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(ModBlockEntities.WEATHER_DISPLAY_BE.get(), WeatherDisplayBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(ModBlockEntities.PROBE_BE.get(), ProbeBlockEntityRenderer::new);
            event.registerBlockEntityRenderer(ModBlockEntities.GARDEN_WINDMILL_BE.get(), GardenWindmillBlockEntityRenderer::new);
        }

        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)ModMenuTypes.WINDMETER_MENU.get(), WindmeterScreen::new);
            event.register((MenuType)ModMenuTypes.WINDMETER_HD_MENU.get(), WindmeterHDScreen::new);
            event.register((MenuType)ModMenuTypes.CUP_ANEMOMETER_MENU.get(), CupAnemometerScreen::new);
            event.register((MenuType)ModMenuTypes.WIND_DISPLAY_MENU.get(), WindDisplayScreen::new);
            event.register((MenuType)ModMenuTypes.WEATHER_DISPLAY_MENU.get(), WeatherDisplayScreen::new);
        }

        @SubscribeEvent
        public static void register(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar(WindMeter.MODID);
            registrar.playBidirectional(ChannelDataWM.TYPE, ChannelDataWM.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(ClientPayloadHandler::handleDataOnMain, ServerPayloadHandler::handleDataOnMain));
            registrar.playBidirectional(ChannelDataDisp.TYPE, ChannelDataDisp.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(ClientPayloadHandlerDisp::handleDataOnMain, ServerPayloadHandlerDisp::handleDataOnMain));
            registrar.playToClient(PosDataWM.TYPE, PosDataWM.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(ClientPayloadHandlerPos::handleDataOnMain, ServerPayloadHandlerPos::handleDataOnMain));
        }
    }
}

