/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter;

import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="windmeter", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class WindmeterClientConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.EnumValue<WindUnits> WIND_UNITS = BUILDER.comment("Wind speed units to be used on displays (mph, kmh, meters per second, bft, kts)").defineEnum("windunits", (Enum)WindUnits.MPH);
    public static WindUnits windUnits;
    private static final ModConfigSpec.EnumValue<TempUnits> TEMP_UNITS;
    public static TempUnits tempUnits;
    private static final ModConfigSpec.IntValue SCREEN_COLOR;
    public static int screenColor;
    private static final ModConfigSpec.IntValue SCREEN_TEXT_COLOR;
    public static int screenTextColor;
    private static final ModConfigSpec.BooleanValue SCREEN_CAP;
    public static boolean screenCap;
    private static final ModConfigSpec.BooleanValue DYNAMIC_TEXT_COLOR;
    public static boolean dynamicTextColor;
    public static final ModConfigSpec SPEC;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        if (event.getConfig().getSpec() == SPEC && !(event instanceof ModConfigEvent.Unloading)) {
            windUnits = (WindUnits)((Object)WIND_UNITS.get());
            tempUnits = (TempUnits)((Object)TEMP_UNITS.get());
            screenColor = (Integer)SCREEN_COLOR.get();
            screenTextColor = (Integer)SCREEN_TEXT_COLOR.get();
            dynamicTextColor = (Boolean)DYNAMIC_TEXT_COLOR.get();
            screenCap = (Boolean)SCREEN_CAP.get();
        }
    }

    static {
        TEMP_UNITS = BUILDER.comment("Temperature units to be used on displays").defineEnum("tempunits", (Enum)TempUnits.FAHRENHEIT);
        SCREEN_COLOR = BUILDER.comment("Color of numbers on wind display. Input number must be color in base 10 format. Use online converters to translate hexadecimal to decimal. Example color 0xff6347 (16) -> 16737095 (10)").defineInRange("numbercolors", 16737095, 0, 0xFFFFFF);
        SCREEN_TEXT_COLOR = BUILDER.comment("Color of text on wind display. Input number must be color in base 10 format. Use online converters to translate hexadecimal to decimal. Example color 0xac16ff (16) -> 11278079 (10)").defineInRange("textcolor", 11278079, 0, 0xFFFFFF);
        SCREEN_CAP = BUILDER.comment("Whether wind display digits should be capped at 999 or not (does not apply to weather display").define("screencap", true);
        DYNAMIC_TEXT_COLOR = BUILDER.comment("Whether wind display digits change color based on wind speed").define("dynamictextcolor", false);
        SPEC = BUILDER.build();
    }

    public static enum WindUnits {
        MPH,
        KMH,
        MPS,
        BEAUFORT,
        KTS;

    }

    public static enum TempUnits {
        CELSIUS,
        FAHRENHEIT,
        KELVIN;

    }
}

