/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.elton.windmeter.block.custom.CupAnemometerBlock;
import net.elton.windmeter.block.custom.GardenWindmillBlock;
import net.elton.windmeter.block.custom.GardenWindmillTowerBlock;
import net.elton.windmeter.block.custom.ProbeBlock;
import net.elton.windmeter.block.custom.WeatherDisplayBlock;
import net.elton.windmeter.block.custom.WindDisplayBlock;
import net.elton.windmeter.block.custom.WindSockBlock;
import net.elton.windmeter.block.custom.WindSockPoleBlock;
import net.elton.windmeter.block.custom.WindVaneBlock;
import net.elton.windmeter.block.custom.WindmeterBlock;
import net.elton.windmeter.block.custom.WindmeterHDBlock;
import net.elton.windmeter.item.ModItems;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"windmeter");
    public static final DeferredBlock<Block> WINDMETER_BLOCK = ModBlocks.registerBlock("wind_meter", () -> new WindmeterBlock(BlockBehaviour.Properties.of().noOcclusion().strength(4.0f).sound(SoundType.METAL).pushReaction(PushReaction.DESTROY)){

        protected MapCodec<? extends WindmeterBlock> codec() {
            return null;
        }
    });
    public static final DeferredBlock<Block> WINDMETER_HD_BLOCK = ModBlocks.registerBlock("wind_meter_hd", () -> new WindmeterHDBlock(BlockBehaviour.Properties.of().noOcclusion().strength(-1.0f, 3600000.0f).sound(SoundType.METAL).pushReaction(PushReaction.BLOCK)){

        protected MapCodec<? extends WindmeterHDBlock> codec() {
            return null;
        }
    });
    public static final DeferredBlock<Block> CUP_ANEMOMETER_BLOCK = ModBlocks.registerBlock("cup_anemometer", () -> new CupAnemometerBlock(BlockBehaviour.Properties.of().noOcclusion().strength(3.0f).sound(SoundType.METAL).pushReaction(PushReaction.DESTROY)){

        protected MapCodec<? extends CupAnemometerBlock> codec() {
            return null;
        }
    });
    public static final DeferredBlock<Block> WIND_VANE_BLOCK = ModBlocks.registerBlock("wind_vane", () -> new WindVaneBlock(BlockBehaviour.Properties.of().noOcclusion().strength(1.75f).sound(SoundType.METAL).pushReaction(PushReaction.DESTROY)){

        protected MapCodec<? extends WindVaneBlock> codec() {
            return null;
        }
    });
    public static final DeferredBlock<Block> WIND_SOCK_BLOCK = ModBlocks.registerBlock("wind_sock", () -> new WindSockBlock(BlockBehaviour.Properties.of().noOcclusion().strength(5.0f).sound(SoundType.METAL).pushReaction(PushReaction.DESTROY)){

        protected MapCodec<? extends WindSockBlock> codec() {
            return null;
        }
    });
    public static final DeferredBlock<Block> WIND_SOCK_POLE_BLOCK = ModBlocks.registerBlock("wind_sock_pole", () -> new WindSockPoleBlock(BlockBehaviour.Properties.of().noOcclusion().strength(6.0f).sound(SoundType.METAL)){

        protected MapCodec<? extends WindSockPoleBlock> codec() {
            return null;
        }
    });
    public static final DeferredBlock<Block> PROBE_BLOCK = ModBlocks.registerBlock("probe", () -> new ProbeBlock(BlockBehaviour.Properties.of().noOcclusion().strength(8.0f).sound(SoundType.METAL).pushReaction(PushReaction.DESTROY)){

        protected MapCodec<? extends ProbeBlock> codec() {
            return null;
        }
    });
    public static final DeferredBlock<Block> GARDEN_WINDMILL_BLOCK = ModBlocks.registerBlock("garden_windmill", () -> new GardenWindmillBlock(BlockBehaviour.Properties.of().noOcclusion().strength(3.0f).sound(SoundType.METAL).pushReaction(PushReaction.DESTROY)){

        protected MapCodec<? extends GardenWindmillBlock> codec() {
            return null;
        }
    });
    public static final DeferredBlock<Block> GARDEN_WINDMILL_TOWER_BLOCK = ModBlocks.registerBlock("garden_windmill_tower", () -> new GardenWindmillTowerBlock(BlockBehaviour.Properties.of().noOcclusion().strength(5.0f).sound(SoundType.METAL)){

        protected MapCodec<? extends GardenWindmillTowerBlock> codec() {
            return null;
        }
    });
    public static final DeferredBlock<Block> WIND_DISPLAY_BLOCK = ModBlocks.registerBlock("wind_display", () -> new WindDisplayBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).noOcclusion().strength(3.0f).sound(SoundType.METAL).pushReaction(PushReaction.DESTROY).lightLevel(state -> 8).destroyTime(2.0f)){

        protected MapCodec<? extends WindDisplayBlock> codec() {
            return null;
        }
    });
    public static final DeferredBlock<Block> WEATHER_DISPLAY_BLOCK = ModBlocks.registerBlock("weather_display", () -> new WeatherDisplayBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).noOcclusion().strength(3.0f).sound(SoundType.METAL).pushReaction(PushReaction.DESTROY).lightLevel(state -> 10).destroyTime(2.0f)){

        protected MapCodec<? extends WeatherDisplayBlock> codec() {
            return null;
        }
    });

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

