/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.custom;

import com.mojang.serialization.MapCodec;
import dev.protomanly.pmweather.config.ClientConfig;
import dev.protomanly.pmweather.weather.WindEngine;
import java.util.List;
import net.elton.windmeter.block.ModBlocks;
import net.elton.windmeter.block.entity.WindSockBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindSockBlock
extends Block
implements EntityBlock {
    public static final MapCodec<WindSockBlock> CODEC = WindSockBlock.simpleCodec(WindSockBlock::new);
    public static final VoxelShape SHAPE = WindSockBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    protected WindSockBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof WindSockBlockEntity) {
            WindSockBlockEntity blockEntity = (WindSockBlockEntity)be;
            if (level.isClientSide()) {
                Vec3 wind = WindEngine.getWind((BlockPos)pos, (Level)level);
                double windspeed = wind.length();
                float winddir = Math.floorMod((int)Math.toDegrees(Math.atan2(-wind.x, wind.z)), 360);
                if (ClientConfig.metric) {
                    player.sendSystemMessage((Component)Component.literal((String)String.format("Wind from %.0f\u00b0", Math.floor(winddir))));
                } else {
                    player.sendSystemMessage((Component)Component.literal((String)String.format("Wind from %.0f\u00b0", Math.floor(winddir))));
                }
            }
        }
        return InteractionResult.SUCCESS_NO_ITEM_USED;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new WindSockBlockEntity(blockPos, blockState);
    }

    public boolean canSurvive(BlockState p_60525_, LevelReader p_60526_, BlockPos p_60527_) {
        DeferredBlock<Block> windSockPoleBlock = ModBlocks.WIND_SOCK_POLE_BLOCK;
        return p_60526_.getBlockState(p_60527_.below()).is(windSockPoleBlock);
    }

    protected void onRemove(BlockState state, @NotNull Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (state.getBlock() != newState.getBlock()) {
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.windmeter.wind_sock.tooltip"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return (level0, blockPos, blockState, blockEntity) -> ((WindSockBlockEntity)blockEntity).tick(level0, blockPos, blockState);
    }
}

