/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.entity.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.elton.windmeter.WindMeter;
import net.elton.windmeter.block.entity.CupAnemometerBlockEntity;
import net.elton.windmeter.block.entity.renderer.CupAnemometerModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CupAnemometerBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static Map<String, ResourceLocation> resLocMap = Maps.newHashMap();
    private static Map<String, Material> materialMap = Maps.newHashMap();
    protected final CupAnemometerModel model = new CupAnemometerModel(Minecraft.getInstance().getEntityModels().bakeLayer(CupAnemometerModel.LAYER_LOCATION));

    public static Material getMaterial(String path) {
        return materialMap.computeIfAbsent(path, m -> CupAnemometerBlockEntityRenderer.createMaterial(path));
    }

    public static Material createMaterial(String path) {
        return new Material(TextureAtlas.LOCATION_BLOCKS, CupAnemometerBlockEntityRenderer.getTexture(path));
    }

    public static ResourceLocation getTexture(String path) {
        return resLocMap.computeIfAbsent(path, k -> WindMeter.getPath("textures/block/cup_anemometer.png"));
    }

    public static void renderModel(Material material, Model model, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        model.renderToBuffer(poseStack, buffer.getBuffer(model.renderType(material.texture())), combinedLightIn, combinedOverlayIn, -1);
    }

    public CupAnemometerBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLightIn, int combinedOverlayIn) {
        this.model.mast.getAllParts().forEach(ModelPart::resetPose);
        this.model.vane.getAllParts().forEach(ModelPart::resetPose);
        this.model.rotor.getAllParts().forEach(ModelPart::resetPose);
        ModelPart mp = this.model.mast;
        mp.x += 6.0f;
        mp.z += 8.0f;
        mp.xRot += (float)Math.toRadians(180.0);
        mp.yRot += (float)Math.toRadians(180.0);
        mp.y += -3.0f;
        mp = this.model.vane;
        mp.x += 8.0f;
        mp.z += 8.0f;
        mp.xRot += (float)Math.toRadians(180.0);
        mp.yRot += (float)Math.toRadians(180.0);
        mp.y += -1.0f;
        mp = this.model.rotor;
        mp.x += 8.0f;
        mp.z += 8.0f;
        mp.xRot += (float)Math.toRadians(180.0);
        mp.yRot += (float)Math.toRadians(180.0);
        mp.y += -5.0f;
        if (blockEntity instanceof CupAnemometerBlockEntity) {
            CupAnemometerBlockEntity cupAnemometerBlockEntity = (CupAnemometerBlockEntity)((Object)blockEntity);
            float lerpAngle = Mth.lerp((float)partialTicks, (float)cupAnemometerBlockEntity.prevSmoothAngle, (float)cupAnemometerBlockEntity.smoothAngle);
            this.model.rotor.yRot = (float)Math.toRadians(lerpAngle);
            this.model.vane.yRot = -((float)Math.toRadians(cupAnemometerBlockEntity.vaneAngle + 180.0f));
        }
        CupAnemometerBlockEntityRenderer.renderModel(CupAnemometerBlockEntityRenderer.getMaterial("cup_anemometer"), (Model)this.model, poseStack, multiBufferSource, combinedLightIn, combinedOverlayIn);
    }
}

