/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.item.custom;

import dev.protomanly.pmweather.weather.WindEngine;
import java.util.List;
import net.elton.windmeter.WindmeterClientConfig;
import net.elton.windmeter.component.ModDataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HandheldAnemometer
extends Item {
    public HandheldAnemometer(Item.Properties properties) {
        super(properties);
        double windmax = 0.0;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (level.getGameTime() % 10L == 0L) {
            ServerLevel serverlevel;
            boolean lvl1 = true;
            boolean lvl2 = true;
            boolean lvl3 = true;
            boolean lvl4 = true;
            boolean lvl5 = true;
            boolean nonselected = true;
            if (slotId == 40) {
                isSelected = true;
            }
            if (stack.get(ModDataComponents.CURR_WS) != null && level instanceof ServerLevel) {
                serverlevel = (ServerLevel)level;
                if (!isSelected && nonselected && (Integer)stack.get(ModDataComponents.CURR_WS) != 0) {
                    stack.set(ModDataComponents.CURR_WS, (Object)0);
                    lvl1 = true;
                    lvl2 = true;
                    lvl3 = true;
                    lvl4 = true;
                    lvl5 = true;
                    nonselected = false;
                }
            }
            if (level.isClientSide() && isSelected) {
                double WindSpeedToWrite;
                Vec3 posVec;
                double windspeed;
                String wsunits = "";
                double windmax = 0.0;
                if (stack.get(ModDataComponents.MAX_WS) != null) {
                    windmax = ((Integer)stack.get(ModDataComponents.MAX_WS)).intValue();
                }
                if ((windspeed = WindEngine.getWind((Vec3)(posVec = new Vec3((double)entity.getBlockX(), (double)entity.getBlockY(), (double)entity.getBlockZ())), (Level)level).length()) > windmax) {
                    windmax = windspeed;
                }
                double WindMaxToWrite = switch (WindmeterClientConfig.windUnits) {
                    case WindmeterClientConfig.WindUnits.KMH -> {
                        wsunits = "km/h";
                        WindSpeedToWrite = windspeed * 1.609;
                        yield windmax * 1.609;
                    }
                    case WindmeterClientConfig.WindUnits.MPS -> {
                        wsunits = "m/s";
                        WindSpeedToWrite = windspeed * 0.44704;
                        yield windmax * 0.44704;
                    }
                    case WindmeterClientConfig.WindUnits.BEAUFORT -> {
                        wsunits = "bft";
                        WindSpeedToWrite = Math.pow(windspeed * 0.44704 / 0.836, 0.6666666666666666);
                        yield Math.pow(windmax * 0.44704 / 0.836, 0.6666666666666666);
                    }
                    case WindmeterClientConfig.WindUnits.KTS -> {
                        wsunits = "kts";
                        WindSpeedToWrite = windspeed * 0.868976;
                        yield windmax * 0.868976;
                    }
                    default -> {
                        wsunits = "mph";
                        WindSpeedToWrite = windspeed;
                        yield windmax;
                    }
                };
                Player player = (Player)entity;
                player.displayClientMessage((Component)Component.translatable((String)String.format("curr: %.1f %s, max: %.0f %s", WindSpeedToWrite, wsunits, WindMaxToWrite, wsunits)), true);
            }
            if (level instanceof ServerLevel) {
                serverlevel = (ServerLevel)level;
                if (isSelected) {
                    nonselected = true;
                    Vec3 posVec = new Vec3((double)entity.getBlockX(), (double)entity.getBlockY(), (double)entity.getBlockZ());
                    double windspeed = WindEngine.getWind((Vec3)posVec, (Level)level).length();
                    if (windspeed == 0.0 && lvl1) {
                        stack.set(ModDataComponents.CURR_WS, (Object)0);
                        lvl1 = true;
                        lvl2 = true;
                        lvl3 = true;
                        lvl4 = true;
                        lvl5 = true;
                    }
                    if (windspeed > 0.0 && windspeed <= 10.0 && lvl1) {
                        stack.set(ModDataComponents.CURR_WS, (Object)1);
                        lvl1 = false;
                        lvl2 = true;
                        lvl3 = true;
                        lvl4 = true;
                        lvl5 = true;
                    }
                    if (windspeed > 10.0 && windspeed <= 20.0 && lvl2) {
                        stack.set(ModDataComponents.CURR_WS, (Object)2);
                        lvl2 = false;
                        lvl1 = true;
                        lvl3 = true;
                        lvl4 = true;
                        lvl5 = true;
                    }
                    if (windspeed > 20.0 && windspeed <= 30.0 && lvl3) {
                        stack.set(ModDataComponents.CURR_WS, (Object)3);
                        lvl3 = false;
                        lvl1 = true;
                        lvl2 = true;
                        lvl4 = true;
                        lvl5 = true;
                    }
                    if (windspeed > 30.0 && windspeed <= 50.0 && lvl4) {
                        stack.set(ModDataComponents.CURR_WS, (Object)4);
                        lvl4 = false;
                        lvl1 = true;
                        lvl3 = true;
                        lvl2 = true;
                        lvl5 = true;
                    }
                    if (windspeed > 50.0 && lvl5) {
                        stack.set(ModDataComponents.CURR_WS, (Object)5);
                        lvl5 = false;
                        lvl1 = true;
                        lvl3 = true;
                        lvl2 = true;
                        lvl4 = true;
                    }
                    if (!Double.isNaN(windspeed)) {
                        if (stack.get(ModDataComponents.MAX_WS) == null) {
                            stack.set(ModDataComponents.MAX_WS, (Object)0);
                        }
                        if (stack.get(ModDataComponents.MAX_WS) != null && windspeed > (double)((Integer)stack.get(ModDataComponents.MAX_WS)).intValue()) {
                            stack.set(ModDataComponents.MAX_WS, (Object)((int)windspeed));
                        }
                    }
                }
            }
        }
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (stack.get(ModDataComponents.MAX_WS) != null) {
            String wsunits = "";
            double windmax = ((Integer)stack.get(ModDataComponents.MAX_WS)).intValue();
            double WindMaxToWrite = 0.0;
            switch (WindmeterClientConfig.windUnits) {
                case KMH: {
                    wsunits = "km/h";
                    WindMaxToWrite = windmax * 1.609;
                    break;
                }
                case MPS: {
                    wsunits = "m/s";
                    WindMaxToWrite = windmax * 0.44704;
                    break;
                }
                case BEAUFORT: {
                    wsunits = "bft";
                    WindMaxToWrite = Math.pow(windmax * 0.44704 / 0.836, 0.6666666666666666);
                    break;
                }
                case KTS: {
                    wsunits = "kts";
                    WindMaxToWrite = windmax * 0.868976;
                    break;
                }
                default: {
                    wsunits = "mph";
                    WindMaxToWrite = windmax;
                }
            }
            tooltipComponents.add((Component)Component.literal((String)String.format("max wind speed: %.0f %s", WindMaxToWrite, wsunits)));
            tooltipComponents.add((Component)Component.literal((String)"Crouch+right click to reset"));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown() && !level.isClientSide()) {
            context.getItemInHand().set(ModDataComponents.MAX_WS, (Object)0);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.getItem() != newStack.getItem();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (player != null && player.isCrouching() && !level.isClientSide()) {
            player.getItemInHand(usedHand).set(ModDataComponents.MAX_WS, (Object)0);
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
    }
}

