/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.screen.custon;

import com.mojang.blaze3d.systems.RenderSystem;
import net.elton.windmeter.WindmeterClientConfig;
import net.elton.windmeter.block.entity.WindDisplayBlockEntity;
import net.elton.windmeter.screen.custon.WindDisplayMenu;
import net.elton.windmeter.util.WindMeterUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class WindDisplayScreen
extends AbstractContainerScreen<WindDisplayMenu> {
    private static final Component TITLE = Component.translatable((String)"gui.windmeter.wind_display_screen");
    private static final Component BUTTON10 = Component.translatable((String)"gui.windmeter.wind_display_screen.button10.button_10");
    private static final Component BUTTON1 = Component.translatable((String)"gui.windmeter.wind_display_screen.button1.button_1");
    private static final Component BUTTON100 = Component.translatable((String)"gui.windmeter.wind_display_screen.button100.button_100");
    private static final Component BUTTONS10 = Component.translatable((String)"gui.windmeter.wind_display_screen.buttons10.button_s10");
    private static final Component BUTTONS1 = Component.translatable((String)"gui.windmeter.wind_display_screen.buttons1.button_s1");
    private static final Component BUTTONS100 = Component.translatable((String)"gui.windmeter.wind_display_screen.buttons100.button_s100");
    private static final Component BUTTON0 = Component.translatable((String)"gui.windmeter.wind_display_screen.button0.button_0");
    private static final Component BUTTON_CONFIRM = Component.translatable((String)"gui.windmeter.wind_display_screen.button_confirm.button_confirm");
    private static final Component BUTTONR10 = Component.translatable((String)"gui.windmeter.wind_display_screen.buttonr10.button_r10");
    private static final Component BUTTONR1 = Component.translatable((String)"gui.windmeter.wind_display_screen.buttonr1.button_r1");
    private static final Component BUTTONR100 = Component.translatable((String)"gui.windmeter.wind_display_screen.buttonr100.button_r100");
    private static final Component BUTTONRS10 = Component.translatable((String)"gui.windmeter.wind_display_screen.buttonrs10.button_rs10");
    private static final Component BUTTONRS1 = Component.translatable((String)"gui.windmeter.wind_display_screen.buttonrs1.button_rs1");
    private static final Component BUTTONRS100 = Component.translatable((String)"gui.windmeter.wind_display_screen.buttonrs100.button_rs100");
    private static final Component BUTTONR0 = Component.translatable((String)"gui.windmeter.wind_display_screen.buttonr0.button_r0");
    private WindDisplayBlockEntity blockEntity;
    private int leftPos;
    private int topPos;
    private int channel_to_set;
    private int redstoneWS_to_set;
    private int redstoneWS_to_send;
    private int max_redstoneWS_to_set;
    private int histeresis_number;
    private String chStatus = "Selected channel is transmitting";
    private Button button10;
    private Button button1;
    private Button button100;
    private Button buttonS10;
    private Button buttonS1;
    private Button buttonS100;
    private Button button0;
    private Button buttonR10;
    private Button buttonR1;
    private Button buttonR100;
    private Button buttonRS10;
    private Button buttonRS1;
    private Button buttonRS100;
    private Button buttonR0;
    private Button buttonConfirm;
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"windmeter", (String)"textures/gui/windmeter/display_gui.png");
    WindmeterClientConfig.WindUnits windUnits = WindmeterClientConfig.windUnits;
    private String units = "";

    public WindDisplayScreen(WindDisplayMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 256;
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.channel_to_set = ((WindDisplayMenu)this.menu).getMenuChannel();
        this.redstoneWS_to_set = ((WindDisplayMenu)this.menu).getMenuRedstoneWS();
        if (this.minecraft == null) {
            return;
        }
        ClientLevel level = this.minecraft.level;
        if (level == null) {
            return;
        }
        switch (this.windUnits) {
            case KMH: {
                this.units = "kmh";
                this.redstoneWS_to_set = (int)((double)this.redstoneWS_to_set * 1.609 + 0.5);
                this.histeresis_number = 6;
                this.max_redstoneWS_to_set = 1609;
                break;
            }
            case MPS: {
                this.units = "m/s";
                this.redstoneWS_to_set = (int)((double)this.redstoneWS_to_set * 0.44704 + 0.5);
                this.histeresis_number = 2;
                this.max_redstoneWS_to_set = 447;
                break;
            }
            case BEAUFORT: {
                this.units = "bft";
                this.redstoneWS_to_set = (int)(Math.pow((double)this.redstoneWS_to_set * 0.44704 / 0.836, 0.6666666666666666) + 0.5);
                this.histeresis_number = (int)(Math.pow(2.1389473684210527, 0.6666666666666666) + 0.5);
                this.max_redstoneWS_to_set = 65;
                break;
            }
            case KTS: {
                this.units = "kts";
                this.redstoneWS_to_set = (int)((double)this.redstoneWS_to_set * 0.868976 + 0.5);
                this.histeresis_number = 3;
                this.max_redstoneWS_to_set = 868;
                break;
            }
            default: {
                this.units = "mph";
                this.redstoneWS_to_set = (int)((double)this.redstoneWS_to_set + 0.5);
                this.histeresis_number = 4;
                this.max_redstoneWS_to_set = 1000;
            }
        }
        this.button1 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTON1, this::handleButton1).bounds(this.leftPos + 140, this.topPos + 19, 30, 20).tooltip(Tooltip.create((Component)BUTTON1)).build());
        this.button10 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTON10, this::handleButton10).bounds(this.leftPos + 172, this.topPos + 19, 30, 20).tooltip(Tooltip.create((Component)BUTTON10)).build());
        this.button100 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTON100, this::handleButton100).bounds(this.leftPos + 204, this.topPos + 19, 30, 20).tooltip(Tooltip.create((Component)BUTTON100)).build());
        this.buttonS1 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTONS1, this::handleButtonS1).bounds(this.leftPos + 86, this.topPos + 19, 30, 20).tooltip(Tooltip.create((Component)BUTTONS1)).build());
        this.buttonS10 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTONS10, this::handleButtonS10).bounds(this.leftPos + 54, this.topPos + 19, 30, 20).tooltip(Tooltip.create((Component)BUTTONS10)).build());
        this.buttonS100 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTONS100, this::handleButtonS100).bounds(this.leftPos + 22, this.topPos + 19, 30, 20).tooltip(Tooltip.create((Component)BUTTONS100)).build());
        this.button0 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTON0, this::handleButton0).bounds(this.leftPos + 36, this.topPos + 40, 80, 20).tooltip(Tooltip.create((Component)BUTTON0)).build());
        this.buttonConfirm = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTON_CONFIRM, this::handleButtonConfirm).bounds(this.leftPos + 140, this.topPos + 40, 80, 20).tooltip(Tooltip.create((Component)BUTTON_CONFIRM)).build());
        this.buttonR1 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTONR1, this::handleButtonR1).bounds(this.leftPos + 146, this.topPos + 105, 30, 20).tooltip(Tooltip.create((Component)BUTTONR1)).build());
        this.buttonR10 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTONR10, this::handleButtonR10).bounds(this.leftPos + 178, this.topPos + 105, 30, 20).tooltip(Tooltip.create((Component)BUTTONR10)).build());
        this.buttonR100 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTONR100, this::handleButtonR100).bounds(this.leftPos + 210, this.topPos + 105, 30, 20).tooltip(Tooltip.create((Component)BUTTONR100)).build());
        this.buttonRS1 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTONRS1, this::handleButtonRS1).bounds(this.leftPos + 80, this.topPos + 105, 30, 20).tooltip(Tooltip.create((Component)BUTTONRS1)).build());
        this.buttonRS10 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTONRS10, this::handleButtonRS10).bounds(this.leftPos + 48, this.topPos + 105, 30, 20).tooltip(Tooltip.create((Component)BUTTONRS10)).build());
        this.buttonRS100 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTONRS100, this::handleButtonRS100).bounds(this.leftPos + 16, this.topPos + 105, 30, 20).tooltip(Tooltip.create((Component)BUTTONRS100)).build());
        this.buttonR0 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTONR0, this::handleButtonR0).bounds(this.leftPos + 30, this.topPos + 126, 80, 20).tooltip(Tooltip.create((Component)BUTTONR0)).build());
    }

    private void handleButton10(Button button) {
        int ch = ((WindDisplayMenu)this.menu).getMenuChannel();
        if (this.channel_to_set <= 90) {
            this.channel_to_set += 10;
        } else if (this.channel_to_set >= 91) {
            this.channel_to_set = 100;
        }
    }

    private void handleButton1(Button button) {
        int ch = ((WindDisplayMenu)this.menu).getMenuChannel();
        if (this.channel_to_set <= 99) {
            ++this.channel_to_set;
        }
    }

    private void handleButton100(Button button) {
        int ch = ((WindDisplayMenu)this.menu).getMenuChannel();
        if (this.channel_to_set <= 0) {
            this.channel_to_set += 100;
        } else if (this.channel_to_set >= 1) {
            this.channel_to_set = 100;
        }
    }

    private void handleButtonS1(Button button) {
        int ch = ((WindDisplayMenu)this.menu).getMenuChannel();
        if (this.channel_to_set >= 1) {
            --this.channel_to_set;
        }
    }

    private void handleButtonS10(Button button) {
        int ch = ((WindDisplayMenu)this.menu).getMenuChannel();
        if (this.channel_to_set >= 10) {
            this.channel_to_set -= 10;
        } else if (this.channel_to_set < 10) {
            this.channel_to_set = 0;
        }
    }

    private void handleButtonS100(Button button) {
        int ch = ((WindDisplayMenu)this.menu).getMenuChannel();
        if (this.channel_to_set >= 100) {
            this.channel_to_set -= 100;
        } else if (this.channel_to_set < 100) {
            this.channel_to_set = 0;
        }
    }

    private void handleButton0(Button button) {
        this.channel_to_set = 0;
    }

    private void handleButtonConfirm(Button button) {
        switch (this.windUnits) {
            case KMH: {
                this.redstoneWS_to_send = (int)((double)this.redstoneWS_to_set / 1.609 + 0.5);
                break;
            }
            case MPS: {
                this.redstoneWS_to_send = (int)((double)this.redstoneWS_to_set / 0.44704 + 0.5);
                break;
            }
            case BEAUFORT: {
                this.redstoneWS_to_send = (int)(0.836 * Math.pow(this.redstoneWS_to_set, 1.5) / 0.44704 + 0.5);
                break;
            }
            case KTS: {
                this.redstoneWS_to_send = (int)((double)this.redstoneWS_to_set / 0.868976 + 0.5);
                break;
            }
            default: {
                this.redstoneWS_to_send = this.redstoneWS_to_set;
            }
        }
        ((WindDisplayMenu)this.menu).setMenuChannel(this.channel_to_set, this.redstoneWS_to_send);
    }

    private void handleButtonR10(Button button) {
        int ch = ((WindDisplayMenu)this.menu).getMenuChannel();
        if (this.redstoneWS_to_set <= this.max_redstoneWS_to_set - 10) {
            this.redstoneWS_to_set += 10;
        } else if (this.redstoneWS_to_set >= this.max_redstoneWS_to_set - 9) {
            this.redstoneWS_to_set = this.max_redstoneWS_to_set;
        }
    }

    private void handleButtonR1(Button button) {
        int ch = ((WindDisplayMenu)this.menu).getMenuChannel();
        if (this.redstoneWS_to_set < this.histeresis_number) {
            this.redstoneWS_to_set = this.histeresis_number;
        } else if (this.redstoneWS_to_set <= this.max_redstoneWS_to_set - 1) {
            ++this.redstoneWS_to_set;
        }
    }

    private void handleButtonR100(Button button) {
        int ch = ((WindDisplayMenu)this.menu).getMenuChannel();
        if (this.redstoneWS_to_set <= this.max_redstoneWS_to_set - 100) {
            this.redstoneWS_to_set += 100;
        } else if (this.redstoneWS_to_set >= this.max_redstoneWS_to_set - 99) {
            this.redstoneWS_to_set = this.max_redstoneWS_to_set;
        }
    }

    private void handleButtonRS1(Button button) {
        int ch = ((WindDisplayMenu)this.menu).getMenuChannel();
        if (this.redstoneWS_to_set >= this.histeresis_number + 1) {
            --this.redstoneWS_to_set;
        } else if (this.redstoneWS_to_set <= this.histeresis_number) {
            this.redstoneWS_to_set = 0;
        }
    }

    private void handleButtonRS10(Button button) {
        int ch = ((WindDisplayMenu)this.menu).getMenuChannel();
        if (this.redstoneWS_to_set >= this.histeresis_number + 10) {
            this.redstoneWS_to_set -= 10;
        } else if (this.redstoneWS_to_set < 10 + this.histeresis_number) {
            this.redstoneWS_to_set = 0;
        }
    }

    private void handleButtonRS100(Button button) {
        int ch = ((WindDisplayMenu)this.menu).getMenuChannel();
        if (this.redstoneWS_to_set >= this.histeresis_number + 100) {
            this.redstoneWS_to_set -= 100;
        } else if (this.redstoneWS_to_set < 100 + this.histeresis_number) {
            this.redstoneWS_to_set = 0;
        }
    }

    private void handleButtonR0(Button button) {
        this.redstoneWS_to_set = 0;
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2 - 80;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        this.renderBackground(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.deleteTexture((int)0);
        int TextShift = this.font.width("" + this.channel_to_set);
        int TextShift2 = this.font.width("Channel setup") / 2;
        int TextShift4 = this.font.width(this.chStatus) / 2;
        int TextShiftR = this.font.width("" + this.redstoneWS_to_set);
        int TextShiftR2 = this.font.width("Redstone wind speed output [" + this.units + "]") / 2;
        super.render(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        guiGraphics.drawString(this.font, "%d".formatted(this.channel_to_set), this.leftPos + 128 - TextShift + 9, this.topPos + 25, 16737095, false);
        guiGraphics.drawString(this.font, "Channel setup", this.leftPos + 128 - TextShift2, this.topPos + 9, 0xFFFFFF, false);
        guiGraphics.drawString(this.font, "%d".formatted(this.redstoneWS_to_set), this.leftPos + 126 - TextShiftR + 14, this.topPos + 111, 16737095, false);
        guiGraphics.drawString(this.font, "Redstone wind speed output [" + this.units + "]", this.leftPos + 128 - TextShiftR2, this.topPos + 94, 0xFFFFFF, false);
        if (WindMeterUtils.posArrayXClient.get(this.channel_to_set) != 0 || WindMeterUtils.posArrayYClient.get(this.channel_to_set) != 0 || WindMeterUtils.posArrayZClient.get(this.channel_to_set) != 0) {
            guiGraphics.drawString(this.font, this.chStatus, this.leftPos + 128 - TextShift4, this.topPos - 10, 0xFFFFFF, false);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

