/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.Data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.elton.windmeter.network.PosDataWM;
import net.elton.windmeter.util.WindMeterUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.network.PacketDistributor;

public class WindmeterData
extends SavedData {
    public List<Integer> posArrayX = new ArrayList<Integer>(Collections.nCopies(102, 0));
    public List<Integer> posArrayY = new ArrayList<Integer>(Collections.nCopies(102, 0));
    public List<Integer> posArrayZ = new ArrayList<Integer>(Collections.nCopies(102, 0));
    public static final SavedData.Factory<WindmeterData> FACTORY = new SavedData.Factory(WindmeterData::create, WindmeterData::load, null);

    public static WindmeterData create() {
        return new WindmeterData();
    }

    public static WindmeterData load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        WindmeterData data = WindmeterData.create();
        data.posArrayX = Arrays.stream(tag.getIntArray("posDataX")).boxed().collect(Collectors.toList());
        data.posArrayY = Arrays.stream(tag.getIntArray("posDataY")).boxed().collect(Collectors.toList());
        data.posArrayZ = Arrays.stream(tag.getIntArray("posDataZ")).boxed().collect(Collectors.toList());
        if (data.posArrayX.size() < 102) {
            ArrayList<Integer> arrayToFill = new ArrayList<Integer>(Collections.nCopies(102 - data.posArrayX.size(), 0));
            data.posArrayX.addAll(arrayToFill);
            data.posArrayY.addAll(arrayToFill);
            data.posArrayZ.addAll(arrayToFill);
        }
        if (data.posArrayX.size() > 102) {
            data.posArrayX.subList(102, data.posArrayX.size()).clear();
            data.posArrayY.subList(102, data.posArrayX.size()).clear();
            data.posArrayZ.subList(102, data.posArrayX.size()).clear();
        }
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putIntArray("posDataX", this.posArrayX);
        tag.putIntArray("posDataY", this.posArrayY);
        tag.putIntArray("posDataZ", this.posArrayZ);
        return tag;
    }

    public void writePositionInsta(int channel, int x, int y, int z, Level level) {
        if (WindMeterUtils.isValidChannel(channel) && this.posArrayX.get(channel) == 0 && this.posArrayY.get(channel) == 0 && this.posArrayZ.get(channel) == 0) {
            this.posArrayX.set(channel, x);
            this.posArrayY.set(channel, y);
            this.posArrayZ.set(channel, z);
            if (!level.isClientSide) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new PosDataWM(this.posArrayX.subList(0, 102), this.posArrayY.subList(0, 102), this.posArrayZ.subList(0, 102)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                System.out.println("Sending windmeter DATA to CLIENT: " + String.valueOf(this.posArrayX) + " " + String.valueOf(this.posArrayY) + " " + String.valueOf(this.posArrayZ));
            }
            System.out.println("Saving windmeter channel pos util X: " + String.valueOf(this.posArrayX));
            System.out.println("Saving windmeter channel pos util Y: " + String.valueOf(this.posArrayY));
            System.out.println("Saving windmeter channel pos util Z: " + String.valueOf(this.posArrayZ));
            this.setDirty();
        }
        if (!level.isClientSide && channel == 0) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new PosDataWM(this.posArrayX.subList(0, 102), this.posArrayY.subList(0, 102), this.posArrayZ.subList(0, 102)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            System.out.println("Sending windmeter DATA to CLIENT: " + String.valueOf(this.posArrayX));
            System.out.println("Sending windmeter DATA to CLIENT: " + String.valueOf(this.posArrayY));
            System.out.println("Sending windmeter DATA to CLIENT: " + String.valueOf(this.posArrayZ));
            this.setDirty();
        }
    }

    public void FreeChannel(int channel, BlockPos pos) {
        if (pos.getX() == this.posArrayX.get(channel).intValue() && pos.getY() == this.posArrayY.get(channel).intValue() && pos.getZ() == this.posArrayZ.get(channel).intValue()) {
            this.posArrayX.set(channel, 0);
            this.posArrayY.set(channel, 0);
            this.posArrayZ.set(channel, 0);
            System.out.println("Windmeter channel cleared DATA");
            System.out.println("Windmeter cleared x DATA: " + String.valueOf(this.posArrayX));
            System.out.println("Windmeter cleared y DATA: " + String.valueOf(this.posArrayY));
            System.out.println("Windmeter cleared z DATA: " + String.valueOf(this.posArrayZ));
            System.out.println("Clearing windmeter channel DATA: " + String.valueOf(this.posArrayX) + " " + String.valueOf(this.posArrayY) + " " + String.valueOf(this.posArrayZ));
            this.setDirty();
        }
    }

    public void foo() {
        this.setDirty();
    }

    public static WindmeterData requestData(MinecraftServer server) {
        WindmeterData savedData = (WindmeterData)server.overworld().getDataStorage().computeIfAbsent(FACTORY, "anemometers");
        return savedData;
    }
}

