/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.custom;

import com.mojang.serialization.MapCodec;
import dev.protomanly.pmweather.weather.WindEngine;
import java.util.List;
import net.elton.windmeter.WindmeterClientConfig;
import net.elton.windmeter.block.entity.ProbeBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProbeBlock
extends Block
implements EntityBlock {
    public static final MapCodec<ProbeBlock> CODEC = ProbeBlock.simpleCodec(ProbeBlock::new);
    public static final VoxelShape SHAPE = ProbeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    protected ProbeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof ProbeBlockEntity) {
            ProbeBlockEntity blockEntity = (ProbeBlockEntity)be;
            float factor_wind = 1.0f;
            float factor_temp = 0.0f;
            float factor_temp2 = 0.0f;
            double WindMaxToWrite = 0.0;
            double WindSpeedToWrite = 0.0;
            String wsunits = "";
            String temp_units = "";
            if (level.isClientSide()) {
                WindmeterClientConfig.WindUnits windUnits = WindmeterClientConfig.windUnits;
                WindmeterClientConfig.TempUnits tempUnits = WindmeterClientConfig.tempUnits;
                switch (windUnits) {
                    case KMH: {
                        wsunits = "km/h";
                        WindSpeedToWrite = blockEntity.WindSpeed * 1.609;
                        WindMaxToWrite = blockEntity.WindMax * 1.609;
                        break;
                    }
                    case MPS: {
                        wsunits = "m/s";
                        WindSpeedToWrite = blockEntity.WindSpeed * 0.44704;
                        WindMaxToWrite = blockEntity.WindMax * 0.44704;
                        break;
                    }
                    case BEAUFORT: {
                        wsunits = "bft";
                        WindSpeedToWrite = Math.pow(blockEntity.WindSpeed * 0.44704 / 0.836, 0.6666666666666666);
                        WindMaxToWrite = Math.pow(blockEntity.WindMax * 0.44704 / 0.836, 0.6666666666666666);
                        break;
                    }
                    case KTS: {
                        wsunits = "kts";
                        WindSpeedToWrite = blockEntity.WindSpeed * 0.868976;
                        WindMaxToWrite = blockEntity.WindMax * 0.868976;
                        break;
                    }
                    default: {
                        wsunits = "mph";
                        WindSpeedToWrite = blockEntity.WindSpeed;
                        WindMaxToWrite = blockEntity.WindMax;
                    }
                }
                switch (tempUnits) {
                    case FAHRENHEIT: {
                        factor_temp = 1.8f;
                        factor_temp2 = 32.0f;
                        temp_units = "\u00b0F";
                        break;
                    }
                    case KELVIN: {
                        factor_temp = 1.0f;
                        factor_temp2 = 273.15f;
                        temp_units = "K";
                        break;
                    }
                    default: {
                        factor_temp = 1.0f;
                        temp_units = "\u00b0C";
                    }
                }
            }
            if (!player.isShiftKeyDown()) {
                if (!level.isClientSide()) {
                    if (blockEntity.current_time - blockEntity.probeTime < 6000L && blockEntity.IsValidPlacement) {
                        player.sendSystemMessage((Component)Component.literal((String)"Probe is recording"));
                    } else {
                        player.sendSystemMessage((Component)Component.literal((String)"Probe is no longer recording"));
                    }
                }
                if (level.isClientSide()) {
                    Vec3 wind = WindEngine.getWind((BlockPos)pos, (Level)level);
                    float winddir = Math.floorMod((int)Math.toDegrees(Math.atan2(-wind.x, wind.z)), 360);
                    player.sendSystemMessage((Component)Component.literal((String)String.format("Wind: %s %s, from %.0f\u00b0\nTemperature: %.1f%s\nDew point: %.1f%s", (int)Math.floor(WindSpeedToWrite), wsunits, Math.floor(winddir), Float.valueOf(blockEntity.temperature * factor_temp + factor_temp2), temp_units, Float.valueOf(blockEntity.dew * factor_temp + factor_temp2), temp_units)));
                }
            }
            if (player.isShiftKeyDown()) {
                if (!level.isClientSide() && blockEntity.drops == 1) {
                    if (blockEntity.current_time - blockEntity.probeTime > 6000L && blockEntity.WindMax > 110.0) {
                        int t320 = blockEntity.time320mph;
                        int t260 = blockEntity.time260mph;
                        int t220 = blockEntity.time220mph;
                        int t150 = blockEntity.time150mph;
                        int t110 = blockEntity.time110mph;
                        String reward_string = "High winds recorded";
                        int j = 0;
                        int k = 0;
                        int l = 0;
                        int m = 0;
                        int n = 0;
                        int o = 0;
                        int xp_value = 0;
                        if (blockEntity.WindMax > 110.0) {
                            n = 1 + t110 / 4;
                        }
                        xp_value += 5 * n;
                        if (blockEntity.WindMax > 150.0) {
                            m = 1 + t150 / 5;
                        }
                        xp_value += 5 * m;
                        if (blockEntity.WindMax > 220.0) {
                            l = 1 + t220 / 5;
                            xp_value += 10 * l;
                            reward_string = "Extreme winds recorded";
                        }
                        if (blockEntity.WindMax > 260.0) {
                            k = 1 + t260 / 5;
                        }
                        xp_value += 20 * k;
                        if (blockEntity.WindMax > 320.0) {
                            j = 1 + t320 / 5;
                            xp_value += 20 * j;
                            reward_string = "Ludicrous winds recorded";
                        }
                        if (blockEntity.WindMax > 400.0) {
                            o = 1;
                        }
                        ExperienceOrb entity = new ExperienceOrb(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), xp_value);
                        level.addFreshEntity((Entity)entity);
                        ProbeBlock.popResource((Level)level, (BlockPos)pos.above(), (ItemStack)new ItemStack((ItemLike)Items.NETHERITE_SCRAP, j));
                        ProbeBlock.popResource((Level)level, (BlockPos)pos.above(), (ItemStack)new ItemStack((ItemLike)Items.NETHERITE_INGOT, o));
                        ProbeBlock.popResource((Level)level, (BlockPos)pos.above(), (ItemStack)new ItemStack((ItemLike)Items.EMERALD, k));
                        ProbeBlock.popResource((Level)level, (BlockPos)pos.above(), (ItemStack)new ItemStack((ItemLike)Items.DIAMOND, l));
                        ProbeBlock.popResource((Level)level, (BlockPos)pos.above(), (ItemStack)new ItemStack((ItemLike)Items.GOLD_INGOT, m));
                        ProbeBlock.popResource((Level)level, (BlockPos)pos.above(), (ItemStack)new ItemStack((ItemLike)Items.IRON_INGOT, n));
                        level.playSound((Player)null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.2f + level.random.nextFloat() * 0.4f);
                        player.sendSystemMessage((Component)Component.literal((String)(reward_string + ",\ndropping appropriate reward")));
                        blockEntity.drops = 0;
                        blockEntity.setChanged();
                    }
                }
                if (level.isClientSide()) {
                    player.sendSystemMessage((Component)Component.literal((String)String.format("Wind max: %s %s\nTemperature min/max [%s]: %.1f/%.1f\nDew point min/max [%s]: %.1f/%.1f", (int)Math.floor(WindMaxToWrite), wsunits, temp_units, Float.valueOf(blockEntity.temperatureMin * factor_temp + factor_temp2), Float.valueOf(blockEntity.temperatureMax * factor_temp + factor_temp2), temp_units, Float.valueOf(blockEntity.dewMin * factor_temp + factor_temp2), Float.valueOf(blockEntity.dewMax * factor_temp + factor_temp2))));
                }
            }
        }
        return InteractionResult.SUCCESS_NO_ITEM_USED;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ProbeBlockEntity(blockPos, blockState);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.windmeter.probe.tooltip"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (state.getBlock() != newState.getBlock()) {
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return (level0, blockPos, blockState, blockEntity) -> ((ProbeBlockEntity)blockEntity).tick(level0, blockPos, blockState);
    }
}

