/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.custom;

import com.mojang.serialization.MapCodec;
import dev.protomanly.pmweather.weather.WindEngine;
import java.util.List;
import net.elton.windmeter.block.entity.WindVaneBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindVaneBlock
extends Block
implements EntityBlock {
    public static final MapCodec<WindVaneBlock> CODEC = WindVaneBlock.simpleCodec(WindVaneBlock::new);
    public static final VoxelShape SHAPE = WindVaneBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0);

    protected WindVaneBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof WindVaneBlockEntity) {
            WindVaneBlockEntity blockEntity = (WindVaneBlockEntity)be;
            if (level.isClientSide() && !player.isShiftKeyDown()) {
                Vec3 wind = WindEngine.getWind((BlockPos)pos, (Level)level);
                float winddir = Math.floorMod((int)Math.toDegrees(Math.atan2(-wind.x, wind.z)), 360);
                player.sendSystemMessage((Component)Component.literal((String)String.format("Wind from %.0f\u00b0", Math.floor(winddir))));
            }
        }
        return InteractionResult.SUCCESS_NO_ITEM_USED;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new WindVaneBlockEntity(blockPos, blockState);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.windmeter.wind_vane.tooltip"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (state.getBlock() != newState.getBlock()) {
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return (level0, blockPos, blockState, blockEntity) -> ((WindVaneBlockEntity)blockEntity).tick(level0, blockPos, blockState);
    }
}

