/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.custom;

import com.mojang.serialization.MapCodec;
import dev.protomanly.pmweather.weather.WindEngine;
import java.util.List;
import java.util.Objects;
import net.elton.windmeter.Data.WindmeterData;
import net.elton.windmeter.WindmeterClientConfig;
import net.elton.windmeter.block.entity.WindmeterBlockEntity;
import net.elton.windmeter.network.ChannelDataWM;
import net.elton.windmeter.network.ClientPayloadHandler;
import net.elton.windmeter.network.PosDataWM;
import net.elton.windmeter.network.ServerPayloadHandler;
import net.elton.windmeter.util.WindMeterUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindmeterBlock
extends Block
implements EntityBlock {
    public static final MapCodec<WindmeterBlock> CODEC = WindmeterBlock.simpleCodec(WindmeterBlock::new);
    public static final VoxelShape SHAPE = WindmeterBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0);

    protected WindmeterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof WindmeterBlockEntity) {
            WindmeterBlockEntity blockEntity = (WindmeterBlockEntity)be;
            if (player.isShiftKeyDown() && !level.isClientSide()) {
                ((ServerPlayer)player).openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)blockEntity, (Component)Component.literal((String)"Windmeter")), pos);
                return InteractionResult.SUCCESS;
            }
            if (level.isClientSide() && !player.isShiftKeyDown()) {
                String wsunits;
                WindmeterClientConfig.WindUnits windUnits = WindmeterClientConfig.windUnits;
                Vec3 wind = WindEngine.getWind((BlockPos)pos, (Level)level);
                double windspeed = wind.length();
                float winddir = Math.floorMod((int)Math.toDegrees(Math.atan2(-wind.x, wind.z)), 360);
                switch (windUnits) {
                    case KMH: {
                        wsunits = "km/h";
                        windspeed *= 1.609;
                        break;
                    }
                    case MPS: {
                        wsunits = "m/s";
                        windspeed *= 0.44704;
                        break;
                    }
                    case BEAUFORT: {
                        wsunits = "bft";
                        windspeed = Math.pow(windspeed * 0.44704 / 0.836, 0.6666666666666666);
                        break;
                    }
                    case KTS: {
                        wsunits = "kts";
                        windspeed *= 0.868976;
                        break;
                    }
                    default: {
                        wsunits = "mph";
                    }
                }
                player.sendSystemMessage((Component)Component.literal((String)String.format("%s %s, from %.0f\u00b0", (int)Math.floor(windspeed), wsunits, Math.floor(winddir))));
            }
            int channel = blockEntity.getChannel();
            if (!player.isShiftKeyDown()) {
                if (level.isClientSide()) {
                    player.sendSystemMessage((Component)Component.literal((String)"Client ch %d".formatted(channel)));
                }
                if (!level.isClientSide()) {
                    player.sendSystemMessage((Component)Component.literal((String)"Server ch %d".formatted(channel)));
                }
            }
        }
        return InteractionResult.SUCCESS_NO_ITEM_USED;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new WindmeterBlockEntity(blockPos, blockState);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.windmeter.wind_meter.tooltip"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    protected void onRemove(BlockState state, @NotNull Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof WindmeterBlockEntity) {
            WindmeterBlockEntity windmeterBlockEntity = (WindmeterBlockEntity)blockEntity;
            int channel_to_clear = windmeterBlockEntity.getChannel();
            WindMeterUtils.FreeChannel(channel_to_clear, pos);
            windmeterBlockEntity.ClearChannel(0);
            if (!level.isClientSide) {
                WindmeterData.requestData(Objects.requireNonNull(level.getServer())).FreeChannel(channel_to_clear, pos);
            }
            if (FMLEnvironment.dist != Dist.DEDICATED_SERVER) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ChannelDataWM(0, 0, 0, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ServerPayloadHandler.ChannelDataUpdate[0] = 0;
                ServerPayloadHandler.ChannelDataUpdate[1] = 0;
                ServerPayloadHandler.ChannelDataUpdate[2] = 0;
                ServerPayloadHandler.ChannelDataUpdate[3] = 0;
                ClientPayloadHandler.ChannelDataUpdate[0] = 0;
                ClientPayloadHandler.ChannelDataUpdate[1] = 0;
                ClientPayloadHandler.ChannelDataUpdate[2] = 0;
                ClientPayloadHandler.ChannelDataUpdate[3] = 0;
            }
            if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
                System.out.println("BLOCK BROKEN SERVER");
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new PosDataWM(WindmeterData.requestData((MinecraftServer)level.getServer()).posArrayX, WindmeterData.requestData((MinecraftServer)level.getServer()).posArrayY, WindmeterData.requestData((MinecraftServer)level.getServer()).posArrayZ), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ServerPayloadHandler.ChannelDataUpdate[0] = 0;
                ServerPayloadHandler.ChannelDataUpdate[1] = 0;
                ServerPayloadHandler.ChannelDataUpdate[2] = 0;
                ServerPayloadHandler.ChannelDataUpdate[3] = 0;
                ClientPayloadHandler.ChannelDataUpdate[0] = 0;
                ClientPayloadHandler.ChannelDataUpdate[1] = 0;
                ClientPayloadHandler.ChannelDataUpdate[2] = 0;
                ClientPayloadHandler.ChannelDataUpdate[3] = 0;
            }
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return (level0, blockPos, blockState, blockEntity) -> ((WindmeterBlockEntity)blockEntity).tick(level0, blockPos, blockState);
    }
}

