/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.entity;

import dev.protomanly.pmweather.weather.WindEngine;
import java.util.Objects;
import net.elton.windmeter.Data.WindmeterData;
import net.elton.windmeter.WindmeterClientConfig;
import net.elton.windmeter.block.custom.WindDisplayBlock;
import net.elton.windmeter.block.entity.ModBlockEntities;
import net.elton.windmeter.network.ChannelDataDisp;
import net.elton.windmeter.network.ClientPayloadHandlerDisp;
import net.elton.windmeter.network.ServerPayloadHandlerDisp;
import net.elton.windmeter.screen.custon.WindDisplayMenu;
import net.elton.windmeter.util.WindMeterUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindDisplayBlockEntity
extends BlockEntity
implements MenuProvider {
    int[] posArray = new int[]{0, 0, 0};
    private int ticks = 0;
    private long prevGameTime;
    int xPos = 0;
    int yPos = 0;
    int zPos = 0;
    int xPosW = 0;
    int yPosW = 0;
    int zPosW = 0;
    private boolean redstoneOut = false;
    public int channel = 0;
    public int redstoneWS = 0;
    public float smoothAngle = 0.0f;
    public float prevSmoothAngle = 0.0f;
    public float winddir = 0.0f;
    public float angleDiff = 0.0f;
    private final MinecraftServer server;
    public String world_name;
    public float vaneAngle = 0.0f;
    public double WindSpeed = 0.0;
    public float vaneAngleToOutput = 0.0f;
    public double WindSpeedToOutput = 0.0;
    public double WindMax = 0.0;
    public int name_display = 1;
    public int text_color_ws = WindmeterClientConfig.screenColor;
    public int text_color_wmax = WindmeterClientConfig.screenColor;

    public WindDisplayBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.WIND_DISPLAY_BE.get(), pos, blockState);
        this.xPos = pos.getX();
        this.yPos = pos.getY();
        this.zPos = pos.getZ();
        this.server = ServerLifecycleHooks.getCurrentServer();
        this.world_name = this.server != null && this.name_display == 1 ? (this.server.getWorldData().getLevelName() != null ? this.server.getWorldData().getLevelName() : "PM WEATHER") : "PM WEATHER";
        if (this.world_name == null) {
            this.world_name = "PM WEATHER";
        }
    }

    public void ClearChannel(int x, int y, int z) {
        this.xPos = 0;
        this.yPos = 0;
        this.zPos = 0;
    }

    public int getChannel() {
        return this.channel;
    }

    public int getRedstoneWS() {
        return this.redstoneWS;
    }

    void changetextColor(double windspeed, double windmax) {
        if (WindmeterClientConfig.dynamicTextColor) {
            if (windspeed < 32.0) {
                this.text_color_ws = 2580981;
            }
            if (windmax < 32.0) {
                this.text_color_wmax = 2580981;
            }
            if (windspeed >= 32.0 && windspeed < 60.0) {
                this.text_color_ws = 2605813;
            }
            if (windmax >= 32.0 && windmax < 60.0) {
                this.text_color_wmax = 2605813;
            }
            if (windspeed >= 60.0 && windspeed < 80.0) {
                this.text_color_ws = 2618673;
            }
            if (windmax >= 60.0 && windmax < 80.0) {
                this.text_color_wmax = 2618673;
            }
            if (windspeed >= 80.0 && windspeed < 120.0) {
                this.text_color_ws = 10018335;
            }
            if (windmax >= 80.0 && windmax < 120.0) {
                this.text_color_wmax = 10018335;
            }
            if (windspeed >= 120.0 && windspeed < 150.0) {
                this.text_color_ws = 16118311;
            }
            if (windmax >= 120.0 && windmax < 150.0) {
                this.text_color_wmax = 16118311;
            }
            if (windspeed >= 150.0 && windspeed < 180.0) {
                this.text_color_ws = 16098855;
            }
            if (windmax >= 150.0 && windmax < 180.0) {
                this.text_color_wmax = 16098855;
            }
            if (windspeed >= 180.0 && windspeed < 210.0) {
                this.text_color_ws = 16066343;
            }
            if (windmax >= 180.0 && windmax < 210.0) {
                this.text_color_wmax = 16066343;
            }
            if (windspeed >= 210.0 && windspeed < 255.0) {
                this.text_color_ws = 16066522;
            }
            if (windmax >= 210.0 && windmax < 255.0) {
                this.text_color_wmax = 16066522;
            }
            if (windspeed >= 255.0) {
                this.text_color_ws = 8462302;
            }
            if (windmax >= 255.0) {
                this.text_color_wmax = 8462302;
            }
        } else if (this.text_color_ws != WindmeterClientConfig.screenColor) {
            this.text_color_ws = WindmeterClientConfig.screenColor;
            this.text_color_wmax = WindmeterClientConfig.screenColor;
        }
    }

    void getWindSpeed(Level plevel, BlockPos pos) {
        BlockPos pos1 = new BlockPos(this.xPosW, this.yPosW, this.zPosW);
        Vec3 pos_test = new Vec3((double)this.xPosW, (double)this.yPosW, (double)this.zPosW);
        BlockEntity be = plevel.getBlockEntity(pos1);
        if (this.channel != 0 && (this.xPosW != 0 || this.yPosW != 0 || this.zPosW != 0) && Objects.requireNonNull(this.level).dimension() == Level.OVERWORLD) {
            double windspeed;
            Vec3 wind = WindEngine.getWind((BlockPos)pos1, (Level)this.level);
            this.winddir = Math.floorMod((int)Math.toDegrees(Math.atan2(-wind.x, wind.z)), 360);
            this.WindSpeed = windspeed = wind.length();
            if (this.level.isClientSide) {
                this.angleDiff = this.winddir - this.vaneAngle;
                if (this.angleDiff > 360.0f) {
                    this.vaneAngle = this.winddir;
                    if (this.channel > 100) {
                        this.channel = 0;
                    }
                }
                if (this.angleDiff < -360.0f) {
                    this.vaneAngle = this.winddir;
                }
                double windSpeedFactor = Math.pow(windspeed, 2.0) / (Math.pow(windspeed, 2.0) + 20000.0);
                double windSpeedFactor2 = Math.pow(windspeed, 2.0) / (Math.pow(windspeed, 2.0) + 2000.0);
                if (!Double.isNaN(windSpeedFactor2)) {
                    if (Math.abs(this.angleDiff) > 0.0f) {
                        if (this.angleDiff > 180.0f) {
                            angleDiff2 = 360.0f - this.angleDiff;
                            this.vaneAngle -= (float)(windSpeedFactor2 * angleDiff2 + (Math.random() - 0.5) * windSpeedFactor * 45.0);
                        } else if (this.angleDiff < -180.0f) {
                            angleDiff2 = 360.0f + this.angleDiff;
                            this.vaneAngle += (float)(windSpeedFactor2 * angleDiff2 + (Math.random() - 0.5) * windSpeedFactor * 45.0);
                        } else {
                            this.vaneAngle += (float)((double)this.angleDiff * windSpeedFactor2 + (Math.random() - 0.5) * windSpeedFactor * 45.0);
                        }
                    } else {
                        return;
                    }
                    if (this.vaneAngle >= 360.0f) {
                        int divider = (int)((double)this.vaneAngle + 0.5) / 360;
                        this.vaneAngle -= (float)(divider * 360);
                    }
                    if (this.vaneAngle < 0.0f) {
                        this.vaneAngle = 360.0f - this.vaneAngle;
                    }
                }
            }
        } else {
            this.WindSpeed = -1.0;
            this.vaneAngle = 0.0f;
        }
    }

    public void randomSearchForAnemometers() {
        if (!(this.level.getGameTime() - this.prevGameTime != 20L && this.level.getGameTime() % 40L != 0L || this.channel == 0 && this.WindSpeed != -1.0)) {
            if (!this.level.isClientSide()) {
                WindmeterData data = WindmeterData.requestData(this.server);
                this.xPosW = data.posArrayX.get(this.channel);
                this.yPosW = data.posArrayY.get(this.channel);
                this.zPosW = data.posArrayZ.get(this.channel);
                this.setChanged();
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
            if (this.level.isClientSide()) {
                this.xPosW = WindMeterUtils.getWMPosX(this.channel);
                this.yPosW = WindMeterUtils.getWMPosY(this.channel);
                this.zPosW = WindMeterUtils.getWMPosZ(this.channel);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void GetChannelFromClient() {
        if (this.level.isClientSide() || this.level.getGameTime() % 10L != 0L || ServerPayloadHandlerDisp.ChannelDataUpdateDisplay[0] == this.channel && this.WindSpeed != -1.0 && ServerPayloadHandlerDisp.ChannelDataUpdateDisplay[4] == this.redstoneWS) return;
        BlockPos pos3 = new BlockPos(this.xPos, this.yPos, this.zPos);
        BlockEntity be = this.level.getBlockEntity(pos3);
        if (!(be instanceof WindDisplayBlockEntity)) return;
        WindDisplayBlockEntity blockEntity = (WindDisplayBlockEntity)be;
        if (ServerPayloadHandlerDisp.ChannelDataUpdateDisplay[1] != this.xPos || ServerPayloadHandlerDisp.ChannelDataUpdateDisplay[2] != this.yPos || ServerPayloadHandlerDisp.ChannelDataUpdateDisplay[3] != this.zPos) return;
        this.channel = ServerPayloadHandlerDisp.ChannelDataUpdateDisplay[0];
        this.redstoneWS = ServerPayloadHandlerDisp.ChannelDataUpdateDisplay[4];
        this.xPosW = WindmeterData.requestData((MinecraftServer)this.server).posArrayX.get(this.channel);
        this.yPosW = WindmeterData.requestData((MinecraftServer)this.server).posArrayY.get(this.channel);
        this.zPosW = WindmeterData.requestData((MinecraftServer)this.server).posArrayZ.get(this.channel);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ChannelDataDisp(this.channel, this.xPos, this.yPos, this.zPos, this.redstoneWS), (CustomPacketPayload[])new CustomPacketPayload[0]);
        WindMeterUtils.ClearPayloads();
        System.out.println("CHANNEL IS: " + this.channel);
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void SendChannelToClient() {
        if (!this.level.isClientSide() || this.level.getGameTime() % 40L != 0L || ClientPayloadHandlerDisp.ChannelDataUpdateDisplay[0] == this.channel && this.WindSpeed != -1.0 && ClientPayloadHandlerDisp.ChannelDataUpdateDisplay[4] == this.redstoneWS) return;
        BlockPos pos3 = new BlockPos(this.xPos, this.yPos, this.zPos);
        BlockEntity be = this.level.getBlockEntity(pos3);
        if (!(be instanceof WindDisplayBlockEntity)) return;
        WindDisplayBlockEntity blockEntity = (WindDisplayBlockEntity)be;
        if (ClientPayloadHandlerDisp.ChannelDataUpdateDisplay[1] != this.xPos || ClientPayloadHandlerDisp.ChannelDataUpdateDisplay[2] != this.yPos || ClientPayloadHandlerDisp.ChannelDataUpdateDisplay[3] != this.zPos) return;
        this.channel = ClientPayloadHandlerDisp.ChannelDataUpdateDisplay[0];
        this.redstoneWS = ClientPayloadHandlerDisp.ChannelDataUpdateDisplay[4];
        this.xPosW = WindMeterUtils.getWMPosX(this.channel);
        this.yPosW = WindMeterUtils.getWMPosY(this.channel);
        this.zPosW = WindMeterUtils.getWMPosZ(this.channel);
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public void tick(Level plevel, BlockPos pblockPos, BlockState pblockState) {
        if (this.level == null) {
            return;
        }
        this.GetChannelFromClient();
        this.SendChannelToClient();
        this.getWindSpeed(plevel, pblockPos);
        this.randomSearchForAnemometers();
        double windspeed = this.WindSpeed;
        if ((int)(this.WindMax + 0.5) < (int)(windspeed + 0.5)) {
            this.WindMax = windspeed;
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.setChanged();
        }
        if (this.level.getGameTime() % 10L == 0L) {
            if (this.redstoneWS > 0) {
                if (this.WindSpeed > (double)this.redstoneWS && !this.redstoneOut && !((Boolean)pblockState.getValue((Property)WindDisplayBlock.POWERED)).booleanValue()) {
                    pblockState.setValue((Property)WindDisplayBlock.POWERED, (Comparable)Boolean.valueOf(true));
                    this.pull(pblockState, this.level, pblockPos, null);
                    this.redstoneOut = true;
                } else if (this.WindSpeed < (double)(this.redstoneWS - 2) && this.redstoneOut && ((Boolean)pblockState.getValue((Property)WindDisplayBlock.POWERED)).booleanValue()) {
                    pblockState.setValue((Property)WindDisplayBlock.POWERED, (Comparable)Boolean.valueOf(false));
                    this.redstoneOut = false;
                    this.pull(pblockState, this.level, pblockPos, null);
                }
            } else if (this.redstoneOut) {
                pblockState.setValue((Property)WindDisplayBlock.POWERED, (Comparable)Boolean.valueOf(false));
                this.redstoneOut = false;
                this.pull(pblockState, this.level, pblockPos, null);
            }
            this.vaneAngleToOutput = this.vaneAngle;
            this.WindSpeedToOutput = this.WindSpeed;
            if (this.level.isClientSide) {
                this.changetextColor(this.WindSpeedToOutput, this.WindMax);
            }
        }
    }

    public double OutputWind() {
        return this.WindSpeed;
    }

    public float OutputDir() {
        return this.vaneAngle;
    }

    public int ResetWindMax() {
        this.WindMax = 0.0;
        this.setChanged();
        return (int)this.WindMax;
    }

    public void pull(BlockState state, Level level, BlockPos pos, @javax.annotation.Nullable Player player) {
        state = (BlockState)state.cycle((Property)WindDisplayBlock.POWERED);
        level.setBlock(pos, state, 3);
        Block pblock = state.getBlock();
        Direction direction = (Direction)state.getValue((Property)WindDisplayBlock.FACING);
        BlockPos blockpos = pos.relative(direction.getOpposite());
        for (Direction dir : Direction.values()) {
            level.updateNeighborsAt(pos.relative(dir), pblock);
        }
        level.gameEvent((Entity)player, (Holder)((Boolean)state.getValue((Property)WindDisplayBlock.POWERED) != false ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE), pos);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag postag = new CompoundTag();
        this.saveAdditional(postag, registries);
        return postag;
    }

    public void handleUpdateTag(CompoundTag postag, HolderLookup.Provider registries) {
        this.zPosW = postag.getInt("zPosW");
        this.yPosW = postag.getInt("yPosW");
        this.xPosW = postag.getInt("xPosW");
        this.posArray = postag.getIntArray("posArray");
        this.WindMax = postag.getDouble("WindMax");
        this.channel = postag.getInt("channel");
        this.redstoneWS = postag.getInt("redstoneWS");
        this.redstoneOut = postag.getBoolean("redstoneOut");
        super.handleUpdateTag(postag, registries);
    }

    public void saveAdditional(CompoundTag postag, HolderLookup.Provider registries) {
        postag.putIntArray("posArray", this.posArray);
        postag.putDouble("WindMax", this.WindMax);
        postag.putInt("channel", this.channel);
        postag.putInt("redstoneWS", this.redstoneWS);
        postag.putBoolean("redstoneOut", this.redstoneOut);
        super.saveAdditional(postag, registries);
    }

    public void loadAdditional(@NotNull CompoundTag postag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(postag, registries);
        this.WindMax = postag.getDouble("WindMax");
        this.channel = postag.getInt("channel");
        this.redstoneWS = postag.getInt("redstoneWS");
        this.redstoneOut = postag.getBoolean("redstoneOut");
    }

    public Component getDisplayName() {
        return Component.literal((String)"Wind display channel setup");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new WindDisplayMenu(i, inventory, this);
    }
}

