/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class WindmeterHDModel<T extends Entity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"windmeter", (String)"wind_meter_hd"), "main");
    public final ModelPart mast;
    public final ModelPart nacelle;
    public final ModelPart rotor;

    public WindmeterHDModel(ModelPart root) {
        this.mast = root.getChild("mast");
        this.nacelle = root.getChild("nacelle");
        this.rotor = this.nacelle.getChild("rotor");
    }

    public ModelPart root() {
        return this.nacelle;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition mast = partdefinition.addOrReplaceChild("mast", CubeListBuilder.create().texOffs(4, 2).addBox(0.5f, -10.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 2).addBox(-0.5f, -11.0f, -0.5f, 1.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition nacelle = partdefinition.addOrReplaceChild("nacelle", CubeListBuilder.create().texOffs(4, 0).addBox(-1.5f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(4, 5).addBox(-0.5f, 0.5f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(11, 13).addBox(-3.3f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(-0.1f)).texOffs(3, 13).addBox(-6.0f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f)).texOffs(4, 8).addBox(-7.5f, -2.5f, 0.0f, 3.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)10.5f, (float)0.0f));
        PartDefinition rotor = nacelle.addOrReplaceChild("rotor", CubeListBuilder.create().texOffs(8, 2).addBox(2.3f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.2f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition blade4_r1 = rotor.addOrReplaceChild("blade4_r1", CubeListBuilder.create().texOffs(8, 2).addBox(0.0f, 0.5f, -1.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.8f, (float)0.0f, (float)-0.2f, (float)1.5708f, (float)0.0f, (float)-0.7854f));
        PartDefinition blade3_r1 = rotor.addOrReplaceChild("blade3_r1", CubeListBuilder.create().texOffs(8, 2).addBox(0.0f, 0.5f, -1.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.8f, (float)0.2f, (float)0.0f, (float)-3.1416f, (float)0.7854f, (float)0.0f));
        PartDefinition blade2_r1 = rotor.addOrReplaceChild("blade2_r1", CubeListBuilder.create().texOffs(8, 2).addBox(0.0f, 0.5f, -1.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.8f, (float)0.0f, (float)0.2f, (float)-1.5708f, (float)0.0f, (float)0.7854f));
        PartDefinition blade1_r1 = rotor.addOrReplaceChild("blade1_r1", CubeListBuilder.create().texOffs(8, 2).addBox(0.0f, 0.5f, -1.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.8f, (float)-0.2f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)18, (int)18);
    }

    public void setupAnim(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.mast.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.nacelle.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

