/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.entity;

import dev.protomanly.pmweather.weather.WindEngine;
import net.elton.windmeter.block.entity.ModBlockEntities;
import net.elton.windmeter.util.WindmeterServerConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class GardenWindmillBlockEntity
extends BlockEntity {
    private final MinecraftServer server;
    int xPos = 0;
    int yPos = 0;
    int zPos = 0;
    private int requested_channel = 0;
    private int count = 0;
    private int skyCount = 0;
    private long prevGameTime = 0L;
    private boolean IsValidPlacement = false;
    private boolean IsValidChannel = false;
    private int channel_changed = 0;
    private int channel = 0;
    public float smoothAngle = 0.0f;
    public float prevSmoothAngle = 0.0f;
    public float smoothAngleRotationalVel = 0.0f;
    public float winddir = 0.0f;
    public float angleDiff = 0.0f;
    public float vaneAngle = 0.0f;
    public float nacelleAngle = 0.0f;
    public float towerAngleX = 0.0f;
    public float towerAngleZ = 0.0f;
    public double WindSpeed = 0.0;
    public double RotorWindSpeed = 0.0;
    public int wobbleAngle = 0;
    public int damagedLevel = 0;
    private int time_divisor = 1;
    double variance2 = 0.0;
    private double damageWSpeed1 = 110.0 + Math.random() * 30.0;
    private double damageWSpeed2 = 144.0 + Math.random() * 30.0;

    public GardenWindmillBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.GARDEN_WINDMILL_BE.get(), pos, blockState);
        this.xPos = pos.getX();
        this.yPos = pos.getY();
        this.zPos = pos.getZ();
        this.server = ServerLifecycleHooks.getCurrentServer();
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        double windspeed;
        if (this.level == null) {
            return;
        }
        if (!blockState.canSurvive((LevelReader)level, blockPos)) {
            level.destroyBlock(blockPos, true);
        }
        Vec3 wind = WindEngine.getWind((BlockPos)blockPos, (Level)level);
        this.winddir = Math.floorMod((int)Math.toDegrees(Math.atan2(-wind.x, wind.z)), 360);
        this.WindSpeed = windspeed = wind.length();
        if (!WindmeterServerConfig.windmillDamage && this.damagedLevel != -1) {
            this.damagedLevel = -1;
        }
        if (WindmeterServerConfig.windmillDamage && this.damagedLevel == -1) {
            this.damagedLevel = 0;
        }
        if (!Double.isNaN(this.WindSpeed)) {
            if (this.WindSpeed > this.damageWSpeed1 && this.damagedLevel != 1 && this.damagedLevel != 2 && this.damagedLevel != -1) {
                this.damagedLevel = 1;
            }
            if (this.WindSpeed > this.damageWSpeed2 && this.damagedLevel != 2 && this.damagedLevel != -1) {
                this.damagedLevel = 2;
            }
            if (this.damagedLevel == 1 && this.wobbleAngle != 4) {
                this.wobbleAngle = 4;
                this.setChanged();
            }
            if (this.damagedLevel == 2 && this.wobbleAngle != 15) {
                this.wobbleAngle = 15;
                double ratio = 0.0;
                if (Math.abs(wind.z) > Math.abs(wind.x)) {
                    ratio = Math.abs(wind.x / wind.z);
                    this.towerAngleX = Math.signum((float)wind.z) * 10.0f;
                    this.towerAngleZ = Math.signum((float)wind.x) * (float)ratio * 10.0f;
                } else {
                    ratio = Math.abs(wind.z / wind.x);
                    this.towerAngleX = Math.signum((float)wind.z) * (float)ratio * 10.0f;
                    this.towerAngleZ = Math.signum((float)wind.x) * 10.0f;
                }
                this.setChanged();
            }
            if (this.damagedLevel < 2 || this.WindSpeed > 40.0) {
                if (!level.isClientSide()) {
                    this.vaneAngle = this.winddir;
                }
                float deflectionAngle = (float)Math.toDegrees(Math.atan(Math.pow(this.WindSpeed, 4.0) / 6000000.0));
                if (this.damagedLevel < 2) {
                    this.nacelleAngle = this.vaneAngle + deflectionAngle;
                    this.RotorWindSpeed = windspeed * Math.cos(Math.toRadians(deflectionAngle));
                } else {
                    this.nacelleAngle = this.vaneAngle + 90.0f;
                }
            }
            if (level.isClientSide()) {
                if (this.wobbleAngle < 15 || this.WindSpeed > 60.0) {
                    this.angleDiff = this.winddir - this.vaneAngle;
                    if (this.angleDiff > 360.0f) {
                        this.vaneAngle = this.winddir;
                    }
                    if (this.angleDiff < -360.0f) {
                        this.vaneAngle = this.winddir;
                    }
                    double windSpeedFactor = Math.pow(windspeed, 2.0) / (Math.pow(windspeed, 2.0) + 20000.0);
                    double windSpeedFactor2 = Math.pow(windspeed, 2.0) / (Math.pow(windspeed, 2.0) + 2000.0);
                    if (!Double.isNaN(windSpeedFactor2)) {
                        this.time_divisor = 1 + (int)(150.0 / (this.WindSpeed + 1.0));
                        if (level.getGameTime() % (long)this.time_divisor == 0L) {
                            this.variance2 = (Math.random() - 0.5) * windSpeedFactor * 30.0;
                        }
                        if (this.angleDiff > 180.0f) {
                            double angleDiff2 = 360.0f - this.angleDiff;
                            this.vaneAngle -= (float)(windSpeedFactor2 * angleDiff2 + this.variance2);
                        } else if (this.angleDiff < -180.0f) {
                            double angleDiff2 = 360.0f + this.angleDiff;
                            this.vaneAngle += (float)(windSpeedFactor2 * angleDiff2 + this.variance2);
                        } else {
                            this.vaneAngle += (float)((double)this.angleDiff * windSpeedFactor2 + this.variance2);
                        }
                    }
                    if (this.vaneAngle < 0.0f) {
                        this.vaneAngle = 360.0f - this.vaneAngle;
                    }
                }
                if (this.wobbleAngle == 15) {
                    this.RotorWindSpeed = 0.0;
                }
                double rotMax = 30.0;
                double maxSpeed = this.RotorWindSpeed * 1.609 / 0.5 * 1000.0 / (Math.PI * 2) * 360.0;
                if ((double)this.smoothAngleRotationalVel < maxSpeed) {
                    this.smoothAngleRotationalVel += (float)this.RotorWindSpeed / 100.0f;
                }
                if ((double)this.smoothAngleRotationalVel > rotMax) {
                    this.smoothAngleRotationalVel = (float)rotMax;
                }
                if (this.smoothAngle >= 180.0f) {
                    this.smoothAngle -= 360.0f;
                }
                this.prevSmoothAngle = this.smoothAngle;
                this.smoothAngle += this.smoothAngleRotationalVel;
                this.smoothAngleRotationalVel -= 0.01f;
                this.smoothAngleRotationalVel *= 0.99f;
                if (this.smoothAngleRotationalVel <= 0.0f) {
                    this.smoothAngleRotationalVel = 0.0f;
                }
            }
        }
    }

    public double OutputWind() {
        return this.WindSpeed;
    }

    public float OutputDir() {
        return this.vaneAngle;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag postag = new CompoundTag();
        this.saveAdditional(postag, registries);
        return postag;
    }

    public void handleUpdateTag(CompoundTag postag, HolderLookup.Provider registries) {
        super.handleUpdateTag(postag, registries);
    }

    public void saveAdditional(CompoundTag postag, HolderLookup.Provider registries) {
        super.saveAdditional(postag, registries);
        postag.putFloat("towerAngleX", this.towerAngleX);
        postag.putFloat("towerAngleZ", this.towerAngleZ);
        postag.putFloat("vaneAngle", this.vaneAngle);
        postag.putFloat("nacelleAngle", this.nacelleAngle);
        postag.putFloat("wobbleAngle", (float)this.wobbleAngle);
        postag.putInt("damagedLevel", this.damagedLevel);
        postag.putDouble("damageWSpeed1", this.damageWSpeed1);
        postag.putDouble("damageWSpeed2", this.damageWSpeed2);
    }

    public void loadAdditional(@NotNull CompoundTag postag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(postag, registries);
        this.towerAngleX = postag.getFloat("towerAngleX");
        this.towerAngleZ = postag.getFloat("towerAngleZ");
        this.vaneAngle = postag.getFloat("vaneAngle");
        this.nacelleAngle = postag.getFloat("nacelleAngle");
        this.wobbleAngle = postag.getInt("wobbleAngle");
        this.damagedLevel = postag.getInt("damagedLevel");
        this.damageWSpeed1 = postag.getDouble("damageWSpeed1");
        this.damageWSpeed2 = postag.getDouble("damageWSpeed2");
    }
}

