/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.entity;

import dev.protomanly.pmweather.weather.WindEngine;
import java.util.Objects;
import net.elton.windmeter.Data.WindmeterData;
import net.elton.windmeter.block.entity.ModBlockEntities;
import net.elton.windmeter.network.ChannelDataWM;
import net.elton.windmeter.network.ClientPayloadHandler;
import net.elton.windmeter.network.ServerPayloadHandler;
import net.elton.windmeter.screen.custon.WindmeterHDMenu;
import net.elton.windmeter.util.WindMeterUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindmeterHDBlockEntity
extends BlockEntity
implements MenuProvider {
    private final MinecraftServer server;
    int xPos = 0;
    int yPos = 0;
    int zPos = 0;
    private int requested_channel = 0;
    private int count = 0;
    private int skyCount = 0;
    private long prevGameTime = 0L;
    private boolean IsValidPlacement = false;
    private boolean IsValidChannel = false;
    private int channel_changed = 0;
    private int channel = 0;
    public float smoothAngle = 0.0f;
    public float prevSmoothAngle = 0.0f;
    public float smoothAngleRotationalVel = 0.0f;
    public float winddir = 0.0f;
    public float angleDiff = 0.0f;
    public float vaneAngle = 0.0f;
    public double WindSpeed = 0.0;

    public WindmeterHDBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.WINDMETER_HD_BE.get(), pos, blockState);
        this.xPos = pos.getX();
        this.yPos = pos.getY();
        this.zPos = pos.getZ();
        this.server = ServerLifecycleHooks.getCurrentServer();
    }

    public void ClearChannel(int i) {
        this.channel = i;
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public int getChannel() {
        return this.channel;
    }

    public boolean getPlacementValidity() {
        return this.IsValidPlacement;
    }

    public void setPlacementValidity(boolean b) {
        this.IsValidPlacement = b;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void GetChannelFromClient() {
        BlockPos pos1;
        BlockEntity be;
        if (this.level.isClientSide() || ServerPayloadHandler.ChannelDataUpdate[0] == this.channel || !this.IsValidPlacement) return;
        if (this.requested_channel != ServerPayloadHandler.ChannelDataUpdate[0]) {
            this.count = 0;
            this.requested_channel = ServerPayloadHandler.ChannelDataUpdate[0];
        }
        if (!((be = this.level.getBlockEntity(pos1 = new BlockPos(this.xPos, this.yPos, this.zPos))) instanceof WindmeterHDBlockEntity)) return;
        WindmeterHDBlockEntity blockEntity = (WindmeterHDBlockEntity)be;
        if (ServerPayloadHandler.ChannelDataUpdate[1] != this.xPos || ServerPayloadHandler.ChannelDataUpdate[2] != this.yPos || ServerPayloadHandler.ChannelDataUpdate[3] != this.zPos || this.count > 2) return;
        ++this.count;
        WindmeterData data = WindmeterData.requestData(this.server);
        int testIfPosXFree = data.posArrayX.get(ServerPayloadHandler.ChannelDataUpdate[0]);
        int testIfPosYFree = data.posArrayY.get(ServerPayloadHandler.ChannelDataUpdate[0]);
        int testIfPosZFree = data.posArrayZ.get(ServerPayloadHandler.ChannelDataUpdate[0]);
        if (this.count == 3) {
            ServerPayloadHandler.ChannelDataUpdate[0] = 0;
            ServerPayloadHandler.ChannelDataUpdate[1] = 0;
            ServerPayloadHandler.ChannelDataUpdate[2] = 0;
            ServerPayloadHandler.ChannelDataUpdate[3] = 0;
            this.requested_channel = -1;
            System.out.println("get channel from client clearing payload");
            return;
        }
        if (testIfPosXFree != 0 || testIfPosYFree != 0 || testIfPosZFree != 0) return;
        WindmeterData.requestData(this.server).FreeChannel(this.channel, pos1);
        this.channel = ServerPayloadHandler.ChannelDataUpdate[0];
        this.requested_channel = -1;
        WindMeterUtils.ClearPayloads();
        WindmeterData.requestData(this.server).writePositionInsta(this.channel, this.xPos, this.yPos, this.zPos, this.level);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ChannelDataWM(this.channel, this.xPos, this.yPos, this.zPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void SendChannelToClient() {
        if (!this.level.isClientSide() || ClientPayloadHandler.ChannelDataUpdate[0] == this.channel || !this.IsValidPlacement) return;
        BlockPos pos1 = new BlockPos(this.xPos, this.yPos, this.zPos);
        BlockEntity be = this.level.getBlockEntity(pos1);
        if (!(be instanceof WindmeterHDBlockEntity)) return;
        WindmeterHDBlockEntity blockEntity = (WindmeterHDBlockEntity)be;
        if (ClientPayloadHandler.ChannelDataUpdate[1] != this.xPos || ClientPayloadHandler.ChannelDataUpdate[2] != this.yPos || ClientPayloadHandler.ChannelDataUpdate[3] != this.zPos) return;
        this.channel = ClientPayloadHandler.ChannelDataUpdate[0];
        WindMeterUtils.ClearPayloads();
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        double windspeed;
        if (this.level == null) {
            return;
        }
        Vec3 wind = WindEngine.getWind((BlockPos)blockPos, (Level)level);
        this.winddir = Math.floorMod((int)Math.toDegrees(Math.atan2(-wind.x, wind.z)), 360);
        this.WindSpeed = windspeed = wind.length();
        if (Double.isNaN(this.WindSpeed)) {
            this.WindSpeed = 1.0;
        }
        if (level.getGameTime() - this.prevGameTime == 20L || level.getGameTime() % 40L == 0L) {
            int i = level.getBrightness(LightLayer.SKY, blockPos);
            if (i <= 14) {
                ++this.skyCount;
            }
            if (i > 14) {
                this.skyCount = 0;
            }
            if (this.WindSpeed == 0.0 && (double)this.winddir == 0.0 || this.skyCount >= 4 || Objects.requireNonNull(level).dimension() != Level.OVERWORLD) {
                this.skyCount = 5;
                this.setPlacementValidity(false);
                if (this.channel != 0) {
                    if (!level.isClientSide()) {
                        WindmeterData.requestData(this.server).FreeChannel(this.channel, blockPos);
                    }
                    WindMeterUtils.FreeChannel(this.channel, blockPos);
                    WindMeterUtils.ClearPayloads();
                    this.ClearChannel(0);
                }
            } else {
                this.setPlacementValidity(true);
            }
        }
        this.GetChannelFromClient();
        this.SendChannelToClient();
        if (level.isClientSide()) {
            this.angleDiff = this.winddir - this.vaneAngle;
            if (this.angleDiff > 360.0f) {
                this.vaneAngle = this.winddir;
            }
            if (this.angleDiff < -360.0f) {
                this.vaneAngle = this.winddir;
            }
            double windSpeedFactor = Math.pow(windspeed, 2.0) / (Math.pow(windspeed, 2.0) + 20000.0);
            double windSpeedFactor2 = Math.pow(windspeed, 2.0) / (Math.pow(windspeed, 2.0) + 2000.0);
            if (!Double.isNaN(windSpeedFactor2)) {
                if (this.angleDiff > 180.0f) {
                    angleDiff2 = 360.0f - this.angleDiff;
                    this.vaneAngle -= (float)(windSpeedFactor2 * angleDiff2 + (Math.random() - 0.5) * windSpeedFactor * 45.0);
                } else if (this.angleDiff < -180.0f) {
                    angleDiff2 = 360.0f + this.angleDiff;
                    this.vaneAngle += (float)(windSpeedFactor2 * angleDiff2 + (Math.random() - 0.5) * windSpeedFactor * 45.0);
                } else {
                    this.vaneAngle += (float)((double)this.angleDiff * windSpeedFactor2 + (Math.random() - 0.5) * windSpeedFactor * 45.0);
                }
                if (this.vaneAngle < 0.0f) {
                    this.vaneAngle = 360.0f - this.vaneAngle;
                }
                double rotMax = 100.0;
                double maxSpeed = windspeed * 1.609 / 0.1875 * 1000.0 / (Math.PI * 2) * 360.0;
                if ((double)this.smoothAngleRotationalVel < maxSpeed) {
                    this.smoothAngleRotationalVel += (float)windspeed / 55.0f;
                }
                if ((double)this.smoothAngleRotationalVel > rotMax) {
                    this.smoothAngleRotationalVel = (float)rotMax;
                }
                if (this.smoothAngle >= 180.0f) {
                    this.smoothAngle -= 360.0f;
                }
                this.prevSmoothAngle = this.smoothAngle;
                this.smoothAngle += this.smoothAngleRotationalVel;
                this.smoothAngleRotationalVel -= 0.01f;
                this.smoothAngleRotationalVel *= 0.99f;
                if (this.smoothAngleRotationalVel <= 0.0f) {
                    this.smoothAngleRotationalVel = 0.0f;
                }
            }
        }
    }

    public double OutputWind() {
        return this.WindSpeed;
    }

    public float OutputDir() {
        return this.vaneAngle;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag postag = new CompoundTag();
        this.saveAdditional(postag, registries);
        return postag;
    }

    public void handleUpdateTag(CompoundTag postag, HolderLookup.Provider registries) {
        this.channel = postag.getInt("channel");
        super.handleUpdateTag(postag, registries);
    }

    public void saveAdditional(CompoundTag postag, HolderLookup.Provider registries) {
        postag.putInt("channel", this.channel);
        super.saveAdditional(postag, registries);
    }

    public void loadAdditional(@NotNull CompoundTag postag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(postag, registries);
        this.channel = postag.getInt("channel");
        if (this.channel > 100) {
            this.channel = 0;
        }
    }

    public Component getDisplayName() {
        return Component.literal((String)"Wind meter heavy duty channel setup");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new WindmeterHDMenu(i, inventory, this);
    }
}

