/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.entity.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import net.elton.windmeter.WindMeter;
import net.elton.windmeter.WindmeterClientConfig;
import net.elton.windmeter.block.custom.WindDisplayBlock;
import net.elton.windmeter.block.entity.WindDisplayBlockEntity;
import net.elton.windmeter.block.entity.renderer.WindDisplayModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WindDisplayBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final BlockEntityRendererProvider.Context context;
    private static Map<String, ResourceLocation> resLocMap = Maps.newHashMap();
    private static Map<String, Material> materialMap = Maps.newHashMap();
    protected final WindDisplayModel model = new WindDisplayModel(Minecraft.getInstance().getEntityModels().bakeLayer(WindDisplayModel.LAYER_WIND_DISPLAY));

    public static Material getMaterial(String path) {
        return materialMap.computeIfAbsent(path, m -> WindDisplayBlockEntityRenderer.createMaterial(path));
    }

    public static Material createMaterial(String path) {
        return new Material(TextureAtlas.LOCATION_BLOCKS, WindDisplayBlockEntityRenderer.getTexture(path));
    }

    public static ResourceLocation getTexture(String path) {
        return resLocMap.computeIfAbsent(path, k -> WindMeter.getPath("textures/block/wind_display.png"));
    }

    public static void renderModel(Material material, Model model, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        model.renderToBuffer(poseStack, buffer.getBuffer(model.renderType(material.texture())), combinedLightIn, combinedOverlayIn, -1);
    }

    public WindDisplayBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.context = ctx;
    }

    public void render(T pBlockEntity, float partialTicks, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pCombinedLightIn, int pCombinedOverlayIn) {
        this.model.base.getAllParts().forEach(ModelPart::resetPose);
        this.model.arrow_base.getAllParts().forEach(ModelPart::resetPose);
        this.model.arrow.getAllParts().forEach(ModelPart::resetPose);
        ModelPart mp = this.model.base;
        mp.x += 8.0f;
        mp.z += 8.0f;
        mp.xRot += (float)Math.toRadians(180.0);
        mp.yRot += (float)Math.toRadians(270.0);
        mp.y += -9.0f;
        mp = this.model.arrow_base;
        mp.x += 8.0f;
        mp.z += 8.0f;
        mp.xRot += (float)Math.toRadians(180.0);
        mp.yRot += (float)Math.toRadians(270.0);
        mp.y += -9.0f;
        mp = this.model.arrow;
        mp.x += 0.0f;
        mp.z += 0.0f;
        mp.xRot += (float)Math.toRadians(180.0);
        mp.yRot += (float)Math.toRadians(180.0);
        mp.y += 0.0f;
        int DisplayRotation = 0;
        if (pBlockEntity instanceof WindDisplayBlockEntity) {
            WindDisplayBlockEntity windDisplayBlockEntity = (WindDisplayBlockEntity)((Object)pBlockEntity);
            BlockState state = pBlockEntity.getBlockState();
            Direction direction = (Direction)state.getValue((Property)WindDisplayBlock.FACING);
            switch (direction) {
                case NORTH: {
                    DisplayRotation = 90;
                    break;
                }
                case EAST: {
                    DisplayRotation = 0;
                    break;
                }
                case WEST: {
                    DisplayRotation = 180;
                    break;
                }
                default: {
                    DisplayRotation = 270;
                }
            }
            this.model.base.yRot += (float)Math.toRadians(DisplayRotation);
            this.model.arrow_base.yRot += (float)Math.toRadians(DisplayRotation);
            this.model.arrow.zRot = -((float)Math.toRadians(windDisplayBlockEntity.vaneAngleToOutput - 180.0f));
            WindDisplayBlockEntityRenderer.renderModel(WindDisplayBlockEntityRenderer.getMaterial("wind_display"), (Model)this.model, pPoseStack, pBufferSource, pCombinedLightIn, pCombinedOverlayIn);
            String units = "";
            double WindMax = windDisplayBlockEntity.WindMax;
            double WindSpeed = windDisplayBlockEntity.WindSpeedToOutput;
            float WindDirection = windDisplayBlockEntity.vaneAngleToOutput;
            String world_name = windDisplayBlockEntity.world_name;
            int numbers_color = WindmeterClientConfig.screenColor;
            int ws_color = windDisplayBlockEntity.text_color_ws;
            int wmax_color = windDisplayBlockEntity.text_color_wmax;
            int text_color = WindmeterClientConfig.screenTextColor;
            String string_plus1 = "";
            String string_plus2 = "";
            WindmeterClientConfig.WindUnits windUnits = WindmeterClientConfig.windUnits;
            int Channel2 = windDisplayBlockEntity.channel;
            switch (windUnits) {
                case KMH: {
                    units = "kmh";
                    WindSpeed *= 1.609;
                    WindMax *= 1.609;
                    break;
                }
                case MPS: {
                    units = "m/s";
                    WindSpeed *= 0.44704;
                    WindMax *= 0.44704;
                    break;
                }
                case BEAUFORT: {
                    units = "bft";
                    WindSpeed = Math.pow(WindSpeed * 0.44704 / 0.836, 0.6666666666666666);
                    WindMax = Math.pow(WindMax * 0.44704 / 0.836, 0.6666666666666666);
                    break;
                }
                case KTS: {
                    units = "kts";
                    WindSpeed *= 0.868976;
                    WindMax *= 0.868976;
                    break;
                }
                default: {
                    units = "mph";
                }
            }
            int WindSpeedr = (int)(WindSpeed + 0.5);
            int WindMaxr = (int)(WindMax + 0.5);
            int WindDirectionr = (int)((double)WindDirection + 0.5);
            if (WindmeterClientConfig.screenCap) {
                if (WindSpeedr >= 999) {
                    WindSpeedr = 999;
                    string_plus1 = "+";
                }
                if (WindMaxr >= 999) {
                    WindMaxr = 999;
                    string_plus2 = "+";
                }
            }
            Font wmx = this.context.getFont();
            Font ws = this.context.getFont();
            Font ch = this.context.getFont();
            Font dir = this.context.getFont();
            Font wname = this.context.getFont();
            Double TextShiftWmx = (double)wmx.width(WindMaxr + string_plus2) * 0.015;
            Double TextShiftWs = (double)ws.width(WindSpeedr + string_plus1) * 0.015;
            Double TextShiftWd = (double)ws.width("" + WindDirectionr) * 0.015;
            Double TextShiftCh = (double)ch.width("" + Channel2) * 0.01;
            float TextscaleWN = 1.0f / ((float)wname.width(world_name) * 3.0f + 50.0f);
            float TextShiftWN = (float)wname.width(world_name) * TextscaleWN;
            pPoseStack.pushPose();
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(DisplayRotation + 90)));
            switch (DisplayRotation) {
                case 270: {
                    pPoseStack.translate((double)0.97f - TextShiftWmx, (double)0.96f, (double)0.07f);
                    break;
                }
                case 90: {
                    pPoseStack.translate((double)-0.03f - TextShiftWmx, (double)0.96f, (double)-0.93f);
                    break;
                }
                case 180: {
                    pPoseStack.translate((double)0.97f - TextShiftWmx, (double)0.96f, (double)-0.93f);
                    break;
                }
                default: {
                    pPoseStack.translate((double)-0.03f - TextShiftWmx, (double)0.96f, (double)0.07f);
                }
            }
            pPoseStack.scale(0.015f, -0.015f, 0.015f);
            wmx.drawInBatch(WindMaxr + string_plus2, 0.0f, 0.0f, wmax_color, false, pPoseStack.last().pose(), pBufferSource, Font.DisplayMode.NORMAL, 0, 255);
            pPoseStack.popPose();
            pPoseStack.pushPose();
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(DisplayRotation + 90)));
            switch (DisplayRotation) {
                case 270: {
                    pPoseStack.translate((double)0.41f - TextShiftWs, (double)0.96f, (double)0.07f);
                    break;
                }
                case 90: {
                    pPoseStack.translate((double)-0.59f - TextShiftWs, (double)0.96f, (double)-0.93f);
                    break;
                }
                case 180: {
                    pPoseStack.translate((double)0.41f - TextShiftWs, (double)0.96f, (double)-0.93f);
                    break;
                }
                default: {
                    pPoseStack.translate((double)-0.59f - TextShiftWs, (double)0.96f, (double)0.07f);
                }
            }
            pPoseStack.scale(0.015f, -0.015f, 0.015f);
            ws.drawInBatch(WindSpeedr + string_plus1, 0.0f, 0.0f, ws_color, false, pPoseStack.last().pose(), pBufferSource, Font.DisplayMode.NORMAL, 0, 255);
            pPoseStack.popPose();
            pPoseStack.pushPose();
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(DisplayRotation + 90)));
            switch (DisplayRotation) {
                case 270: {
                    pPoseStack.translate((double)0.643f - TextShiftWd, (double)0.578f, (double)0.07f);
                    break;
                }
                case 90: {
                    pPoseStack.translate((double)-0.357f - TextShiftWd, (double)0.578f, (double)-0.93f);
                    break;
                }
                case 180: {
                    pPoseStack.translate((double)0.643f - TextShiftWd, (double)0.578f, (double)-0.93f);
                    break;
                }
                default: {
                    pPoseStack.translate((double)-0.357f - TextShiftWd, (double)0.578f, (double)0.07f);
                }
            }
            pPoseStack.scale(0.015f, -0.015f, 0.015f);
            dir.drawInBatch("" + WindDirectionr, 0.0f, 0.0f, numbers_color, false, pPoseStack.last().pose(), pBufferSource, Font.DisplayMode.NORMAL, 0, 255);
            pPoseStack.popPose();
            pPoseStack.pushPose();
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(DisplayRotation + 90)));
            switch (DisplayRotation) {
                case 270: {
                    pPoseStack.translate((double)0.96f - TextShiftCh, (double)0.12f, (double)0.07f);
                    break;
                }
                case 90: {
                    pPoseStack.translate((double)-0.04f - TextShiftCh, (double)0.12f, (double)-0.93f);
                    break;
                }
                case 180: {
                    pPoseStack.translate((double)0.96f - TextShiftCh, (double)0.12f, (double)-0.93f);
                    break;
                }
                default: {
                    pPoseStack.translate((double)-0.04f - TextShiftCh, (double)0.12f, (double)0.07f);
                }
            }
            pPoseStack.scale(0.01f, -0.01f, 0.01f);
            ws.drawInBatch("" + Channel2, 0.0f, 0.0f, numbers_color, false, pPoseStack.last().pose(), pBufferSource, Font.DisplayMode.NORMAL, 0, 255);
            pPoseStack.popPose();
            pPoseStack.pushPose();
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(DisplayRotation + 90)));
            switch (DisplayRotation) {
                case 270: {
                    pPoseStack.translate(0.45f, 0.965f, 0.07f);
                    break;
                }
                case 90: {
                    pPoseStack.translate(-0.55f, 0.965f, -0.93f);
                    break;
                }
                case 180: {
                    pPoseStack.translate(0.45f, 0.965f, -0.93f);
                    break;
                }
                default: {
                    pPoseStack.translate(-0.55f, 0.965f, 0.07f);
                }
            }
            pPoseStack.scale(0.006f, -0.006f, 0.006f);
            ws.drawInBatch(units, 0.0f, 0.0f, numbers_color, false, pPoseStack.last().pose(), pBufferSource, Font.DisplayMode.NORMAL, 0, 255);
            pPoseStack.popPose();
            pPoseStack.pushPose();
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(DisplayRotation + 90)));
            switch (DisplayRotation) {
                case 270: {
                    pPoseStack.translate(0.501f - TextShiftWN / 2.0f, 0.38f + TextscaleWN * 3.0f, 0.07f);
                    break;
                }
                case 90: {
                    pPoseStack.translate(-0.499f - TextShiftWN / 2.0f, 0.38f + TextscaleWN * 3.0f, -0.93f);
                    break;
                }
                case 180: {
                    pPoseStack.translate(0.501f - TextShiftWN / 2.0f, 0.38f + TextscaleWN * 3.0f, -0.93f);
                    break;
                }
                default: {
                    pPoseStack.translate(-0.499f - TextShiftWN / 2.0f, 0.38f + TextscaleWN * 3.0f, 0.07f);
                }
            }
            pPoseStack.scale(TextscaleWN, -1.0f * TextscaleWN, TextscaleWN);
            ws.drawInBatch(world_name, 0.0f, 0.0f, text_color, false, pPoseStack.last().pose(), pBufferSource, Font.DisplayMode.NORMAL, 0, 255);
            pPoseStack.popPose();
        }
    }
}

