/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.entity.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.elton.windmeter.WindMeter;
import net.elton.windmeter.block.entity.WindVaneBlockEntity;
import net.elton.windmeter.block.entity.renderer.WindVaneModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WindVaneBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static Map<String, ResourceLocation> resLocMap = Maps.newHashMap();
    private static Map<String, Material> materialMap = Maps.newHashMap();
    protected final WindVaneModel model = new WindVaneModel(Minecraft.getInstance().getEntityModels().bakeLayer(WindVaneModel.LAYER_LOCATION));

    public static Material getMaterial(String path) {
        return materialMap.computeIfAbsent(path, m -> WindVaneBlockEntityRenderer.createMaterial(path));
    }

    public static Material createMaterial(String path) {
        return new Material(TextureAtlas.LOCATION_BLOCKS, WindVaneBlockEntityRenderer.getTexture(path));
    }

    public static ResourceLocation getTexture(String path) {
        return resLocMap.computeIfAbsent(path, k -> WindMeter.getPath("textures/block/wind_vane.png"));
    }

    public static void renderModel(Material material, Model model, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        model.renderToBuffer(poseStack, buffer.getBuffer(model.renderType(material.texture())), combinedLightIn, combinedOverlayIn, -1);
    }

    public WindVaneBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLightIn, int combinedOverlayIn) {
        this.model.mast.getAllParts().forEach(ModelPart::resetPose);
        this.model.vane.getAllParts().forEach(ModelPart::resetPose);
        ModelPart mp = this.model.mast;
        mp.x += 8.0f;
        mp.z += 8.0f;
        mp.xRot += (float)Math.toRadians(180.0);
        mp.y += -24.0f;
        mp = this.model.vane;
        mp.x += 8.0f;
        mp.z += 8.0f;
        mp.xRot += (float)Math.toRadians(180.0);
        if (blockEntity instanceof WindVaneBlockEntity) {
            WindVaneBlockEntity windVaneBlockEntity = (WindVaneBlockEntity)((Object)blockEntity);
            float lerpAngle = Mth.lerp((float)partialTicks, (float)windVaneBlockEntity.prevSmoothAngle, (float)windVaneBlockEntity.smoothAngle);
            this.model.vane.yRot = -((float)Math.toRadians(windVaneBlockEntity.vaneAngle - 90.0f));
        }
        WindVaneBlockEntityRenderer.renderModel(WindVaneBlockEntityRenderer.getMaterial("wind_vane"), (Model)this.model, poseStack, multiBufferSource, combinedLightIn, combinedOverlayIn);
    }
}

