/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import net.elton.windmeter.Data.WindmeterData;
import net.elton.windmeter.util.WindMeterUtils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;

public class WindmeterCommands {
    public WindmeterCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"windmeter").then(((LiteralArgumentBuilder)Commands.literal((String)"clearchannel").requires(plr -> plr.hasPermission(2))).then(Commands.argument((String)"channel", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(this::clearChannel))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"windmeter").then(((LiteralArgumentBuilder)Commands.literal((String)"get_anemo_pos_from_channel").requires(plr -> plr.hasPermission(2))).then(Commands.argument((String)"channel", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(this::getPos))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"windmeter").then(Commands.literal((String)"available_channels").executes(this::getAvailableChannels)));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"windmeter").then(Commands.literal((String)"occupied_channels").executes(this::getOccupiedChannels)));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"windmeter").then(Commands.literal((String)"occupied_channels_client").executes(this::getOccupiedChannelsClient)));
    }

    private int getAvailableChannels(CommandContext<CommandSourceStack> context) {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        ArrayList<Integer> availableChannelList = new ArrayList<Integer>();
        WindmeterData data = WindmeterData.requestData(server);
        for (int i = 1; i <= 100; ++i) {
            if (data.posArrayX.get(i) != 0 || data.posArrayY.get(i) != 0 || data.posArrayZ.get(i) != 0) continue;
            availableChannelList.add(i);
        }
        if (((CommandSourceStack)context.getSource()).isPlayer()) {
            ((CommandSourceStack)context.getSource()).getPlayer().sendSystemMessage((Component)Component.literal((String)("Available channels: " + ((Object)availableChannelList).toString())));
        }
        return 1;
    }

    private int getOccupiedChannels(CommandContext<CommandSourceStack> context) {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        ArrayList<Integer> occupiedChannelList = new ArrayList<Integer>();
        WindmeterData data = WindmeterData.requestData(server);
        for (int i = 1; i <= 100; ++i) {
            if (WindMeterUtils.posArrayXClient.get(i) == 0 && WindMeterUtils.posArrayYClient.get(i) == 0 && WindMeterUtils.posArrayZClient.get(i) == 0) continue;
            occupiedChannelList.add(i);
        }
        if (((CommandSourceStack)context.getSource()).isPlayer()) {
            ((CommandSourceStack)context.getSource()).getPlayer().sendSystemMessage((Component)Component.literal((String)("Occupied channels: " + ((Object)occupiedChannelList).toString())));
        }
        return 1;
    }

    private int getOccupiedChannelsClient(CommandContext<CommandSourceStack> context) {
        ArrayList<Integer> occupiedChannelList = new ArrayList<Integer>();
        for (int i = 1; i <= 100; ++i) {
            if (WindMeterUtils.posArrayXClient.get(i) == 0 && WindMeterUtils.posArrayYClient.get(i) == 0 && WindMeterUtils.posArrayZClient.get(i) == 0) continue;
            occupiedChannelList.add(i);
        }
        if (((CommandSourceStack)context.getSource()).isPlayer()) {
            ((CommandSourceStack)context.getSource()).getPlayer().sendSystemMessage((Component)Component.literal((String)("Occupied channels: " + ((Object)occupiedChannelList).toString())));
        }
        return 1;
    }

    private int clearChannel(CommandContext<CommandSourceStack> context) {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        int channel = IntegerArgumentType.getInteger(context, (String)"channel");
        WindMeterUtils.posArrayXClient.set(channel, 0);
        WindMeterUtils.posArrayYClient.set(channel, 0);
        WindMeterUtils.posArrayZClient.set(channel, 0);
        WindmeterData.requestData((MinecraftServer)server).posArrayX.set(channel, 0);
        WindmeterData.requestData((MinecraftServer)server).posArrayY.set(channel, 0);
        WindmeterData.requestData((MinecraftServer)server).posArrayZ.set(channel, 0);
        if (((CommandSourceStack)context.getSource()).isPlayer()) {
            ((CommandSourceStack)context.getSource()).getPlayer().sendSystemMessage((Component)Component.literal((String)String.format("Channel %s cleared", channel)));
        }
        return 1;
    }

    private int getPos(CommandContext<CommandSourceStack> context) {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        int channel = IntegerArgumentType.getInteger(context, (String)"channel");
        int xPos = WindmeterData.requestData((MinecraftServer)server).posArrayX.get(channel);
        int yPos = WindmeterData.requestData((MinecraftServer)server).posArrayY.get(channel);
        int zPos = WindmeterData.requestData((MinecraftServer)server).posArrayZ.get(channel);
        if (((CommandSourceStack)context.getSource()).isPlayer()) {
            ((CommandSourceStack)context.getSource()).getPlayer().sendSystemMessage((Component)Component.literal((String)String.format("Anemometer with channel %s is located at x: %s y: %s z: %s", channel, xPos, yPos, zPos)));
        }
        return 1;
    }
}

