/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.entity;

import dev.protomanly.pmweather.weather.WindEngine;
import net.elton.windmeter.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class WindVaneBlockEntity
extends BlockEntity {
    private final MinecraftServer server;
    int xPos = 0;
    int yPos = 0;
    int zPos = 0;
    double variance2 = 0.0;
    private int time_divisor = 1;
    public float smoothAngle = 0.0f;
    public float prevSmoothAngle = 0.0f;
    public float winddir = 0.0f;
    public float angleDiff = 0.0f;
    public float vaneAngle = 0.0f;
    public double WindSpeed = 0.0;

    public WindVaneBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.WIND_VANE_BE.get(), pos, blockState);
        this.xPos = pos.getX();
        this.yPos = pos.getY();
        this.zPos = pos.getZ();
        this.server = ServerLifecycleHooks.getCurrentServer();
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        double windspeed;
        if (this.level == null) {
            return;
        }
        Vec3 wind = WindEngine.getWind((BlockPos)blockPos, (Level)level);
        this.winddir = Math.floorMod((int)Math.toDegrees(Math.atan2(-wind.x, wind.z)), 360);
        this.WindSpeed = windspeed = wind.length();
        if (Double.isNaN(this.WindSpeed)) {
            this.WindSpeed = 1.0;
        }
        if (level.isClientSide()) {
            this.angleDiff = this.winddir - this.vaneAngle;
            if (this.angleDiff > 360.0f) {
                this.vaneAngle = this.winddir;
            }
            if (this.angleDiff < -360.0f) {
                this.vaneAngle = this.winddir;
            }
            double windSpeedFactor = Math.pow(windspeed, 2.0) / (Math.pow(windspeed, 2.0) + 20000.0);
            double windSpeedFactor2 = Math.pow(windspeed, 2.0) / (Math.pow(windspeed, 2.0) + 2000.0);
            if (!Double.isNaN(windSpeedFactor2)) {
                this.time_divisor = 2 + (int)(50.0 / (this.WindSpeed + 1.0));
                if (level.getGameTime() % (long)this.time_divisor == 0L) {
                    this.variance2 = (Math.random() - 0.5) * windSpeedFactor * 30.0;
                }
                if (this.angleDiff > 180.0f) {
                    double angleDiff2 = 360.0f - this.angleDiff;
                    this.vaneAngle -= (float)(windSpeedFactor2 * angleDiff2 + this.variance2);
                } else if (this.angleDiff < -180.0f) {
                    double angleDiff2 = 360.0f + this.angleDiff;
                    this.vaneAngle += (float)(windSpeedFactor2 * angleDiff2 + this.variance2);
                } else {
                    this.vaneAngle += (float)((double)this.angleDiff * windSpeedFactor2 + this.variance2);
                }
                if (this.vaneAngle < 0.0f) {
                    this.vaneAngle = 360.0f - this.vaneAngle;
                }
            }
        }
    }

    public float OutputDir() {
        return this.vaneAngle;
    }
}

