/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.entity.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.elton.windmeter.WindMeter;
import net.elton.windmeter.block.entity.GardenWindmillBlockEntity;
import net.elton.windmeter.block.entity.renderer.GardenWindmillModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GardenWindmillBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static Map<String, ResourceLocation> resLocMap = Maps.newHashMap();
    private static Map<String, Material> materialMap = Maps.newHashMap();
    protected final GardenWindmillModel model = new GardenWindmillModel(Minecraft.getInstance().getEntityModels().bakeLayer(GardenWindmillModel.LAYER_LOCATION));

    public static Material getMaterial(String path) {
        return materialMap.computeIfAbsent(path, m -> GardenWindmillBlockEntityRenderer.createMaterial(path));
    }

    public static Material createMaterial(String path) {
        return new Material(TextureAtlas.LOCATION_BLOCKS, GardenWindmillBlockEntityRenderer.getTexture(path));
    }

    public static ResourceLocation getTexture(String path) {
        return resLocMap.computeIfAbsent(path, k -> WindMeter.getPath("textures/block/garden_windmill.png"));
    }

    public static void renderModel(Material material, Model model, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        model.renderToBuffer(poseStack, buffer.getBuffer(model.renderType(material.texture())), combinedLightIn, combinedOverlayIn, -1);
    }

    public GardenWindmillBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLightIn, int combinedOverlayIn) {
        this.model.tower.getAllParts().forEach(ModelPart::resetPose);
        ModelPart mp = this.model.tower;
        mp.x += 8.0f;
        mp.z += 8.0f;
        mp.xRot += (float)Math.toRadians(180.0);
        mp.yRot += (float)Math.toRadians(180.0);
        mp.y += -24.0f;
        mp = this.model.nacelle;
        mp.x += 0.0f;
        mp.z += 0.0f;
        mp.xRot += 0.0f;
        mp.yRot += 0.0f;
        mp.y += 0.0f;
        mp = this.model.tail;
        mp.x += 0.0f;
        mp.z += 0.0f;
        mp.xRot += 0.0f;
        mp.yRot += 0.0f;
        mp.y += 0.0f;
        if (blockEntity instanceof GardenWindmillBlockEntity) {
            GardenWindmillBlockEntity gardenWindmillBlockEntity = (GardenWindmillBlockEntity)((Object)blockEntity);
            float lerpAngle = Mth.lerp((float)partialTicks, (float)gardenWindmillBlockEntity.prevSmoothAngle, (float)gardenWindmillBlockEntity.smoothAngle);
            float wobbleAngle = gardenWindmillBlockEntity.wobbleAngle;
            this.model.rotor.zRot = -((float)Math.toRadians(lerpAngle));
            this.model.rotor.xRot = -((float)Math.toRadians(wobbleAngle));
            this.model.nacelle.yRot = (float)Math.toRadians(gardenWindmillBlockEntity.nacelleAngle);
            this.model.tower.xRot = -((float)Math.toRadians(gardenWindmillBlockEntity.towerAngleX + 180.0f));
            this.model.tower.zRot = -((float)Math.toRadians(gardenWindmillBlockEntity.towerAngleZ));
            this.model.tail.yRot = (float)Math.toRadians(gardenWindmillBlockEntity.vaneAngle);
        }
        GardenWindmillBlockEntityRenderer.renderModel(GardenWindmillBlockEntityRenderer.getMaterial("garden_windmill"), (Model)this.model, poseStack, multiBufferSource, combinedLightIn, combinedOverlayIn);
    }
}

