/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.elton.windmeter.block.entity.SmallCarbonWindTurbineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmallCarbonWindTurbineBlock
extends Block
implements EntityBlock {
    public static final MapCodec<SmallCarbonWindTurbineBlock> CODEC = SmallCarbonWindTurbineBlock.simpleCodec(SmallCarbonWindTurbineBlock::new);
    public static final Property<AttachFace> ATTACHMENT;
    public static final VoxelShape SHAPE;
    public static final VoxelShape SHAPE2;

    protected SmallCarbonWindTurbineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ATTACHMENT});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        BlockPos blockpos = context.getClickedPos();
        Level level = context.getLevel();
        boolean flag1 = !SmallCarbonWindTurbineBlock.canSupportCenter((LevelReader)level, (BlockPos)blockpos.below(), (Direction)Direction.UP);
        BlockState blockstate1 = (BlockState)this.defaultBlockState().setValue(ATTACHMENT, (Comparable)AttachFace.FLOOR);
        blockstate1 = (BlockState)blockstate1.setValue(ATTACHMENT, (Comparable)AttachFace.FLOOR);
        if (flag1) {
            return blockstate1;
        }
        return (BlockState)this.defaultBlockState().setValue(ATTACHMENT, (Comparable)AttachFace.CEILING);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(state);
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new SmallCarbonWindTurbineBlockEntity(blockPos, blockState);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.windmeter.small_carbon_wind_turbine.tooltip"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    protected void onRemove(BlockState state, @NotNull Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (state.getBlock() != newState.getBlock()) {
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return (level0, blockPos, blockState, blockEntity) -> ((SmallCarbonWindTurbineBlockEntity)blockEntity).tick(level0, blockPos, blockState);
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        AttachFace attachtype = (AttachFace)state.getValue(ATTACHMENT);
        if (!SmallCarbonWindTurbineBlock.canSupportCenter((LevelReader)level, (BlockPos)currentPos.below(), (Direction)Direction.UP)) {
            return (BlockState)state.setValue(ATTACHMENT, (Comparable)AttachFace.FLOOR);
        }
        return (BlockState)state.setValue(ATTACHMENT, (Comparable)AttachFace.CEILING);
    }

    @NotNull
    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(state);
    }

    private VoxelShape getVoxelShape(BlockState state) {
        AttachFace attachtype = (AttachFace)state.getValue(ATTACHMENT);
        if (attachtype == AttachFace.FLOOR) {
            return SHAPE2;
        }
        return SHAPE;
    }

    static {
        SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        SHAPE2 = Shapes.or((VoxelShape)SHAPE, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0));
        ATTACHMENT = BlockStateProperties.ATTACH_FACE;
    }
}

