/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.entity;

import dev.protomanly.pmweather.block.entity.RadarBlockEntity;
import dev.protomanly.pmweather.config.ServerConfig;
import dev.protomanly.pmweather.event.GameBusClientEvents;
import dev.protomanly.pmweather.event.GameBusEvents;
import dev.protomanly.pmweather.weather.ThermodynamicEngine;
import dev.protomanly.pmweather.weather.WeatherHandler;
import dev.protomanly.pmweather.weather.WeatherHandlerServer;
import dev.protomanly.pmweather.weather.WindEngine;
import java.util.Objects;
import net.elton.windmeter.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class ProbeBlockEntity
extends BlockEntity {
    private final MinecraftServer server;
    int xPos = 0;
    int yPos = 0;
    int zPos = 0;
    private int skyCount = 0;
    private long prevGameTime = 0L;
    public long probeTime = 0L;
    public long current_time = 0L;
    public boolean IsValidPlacement = false;
    public float smoothAngle = 0.0f;
    public float prevSmoothAngle = 0.0f;
    public float smoothAngleRotationalVel = 0.0f;
    public float winddir = 0.0f;
    public float angleDiff = 0.0f;
    public float vaneAngle = 0.0f;
    public double WindSpeed = 0.0;
    public double WindMax = 0.0;
    public float temperature = 0.0f;
    public float temperatureMax = -999.0f;
    public float temperatureMin = 999.0f;
    public float dew = 0.0f;
    public float dewMax = -999.0f;
    public float dewMin = 999.0f;
    public float pressure = 0.0f;
    public float pressureMax = 0.0f;
    public float pressureMin = 9999.0f;
    public int drops = 1;
    public int time110mph = 0;
    public int time150mph = 0;
    public int time220mph = 0;
    public int time260mph = 0;
    public int time320mph = 0;
    public static final int recordingTime = 6000;

    public ProbeBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.PROBE_BE.get(), pos, blockState);
        this.xPos = pos.getX();
        this.yPos = pos.getY();
        this.zPos = pos.getZ();
        this.server = ServerLifecycleHooks.getCurrentServer();
    }

    public boolean getPlacementValidity() {
        return this.IsValidPlacement;
    }

    public void setPlacementValidity(boolean b) {
        this.IsValidPlacement = b;
    }

    public void timeExposedInWind(double windspeed) {
        if (110.0 < windspeed) {
            ++this.time110mph;
            if (this.time110mph > 20) {
                this.time110mph = 20;
            }
        }
        if (150.0 < windspeed) {
            ++this.time150mph;
            if (this.time150mph > 20) {
                this.time150mph = 20;
            }
        }
        if (220.0 < windspeed) {
            ++this.time220mph;
            if (this.time220mph > 20) {
                this.time220mph = 20;
            }
        }
        if (260.0 < windspeed) {
            ++this.time260mph;
            if (this.time260mph > 20) {
                this.time260mph = 20;
            }
        }
        if (320.0 < windspeed) {
            ++this.time320mph;
            if (this.time320mph > 20) {
                this.time320mph = 20;
            }
        }
    }

    public void readAtmosphericConditions(BlockPos pos, Level level) {
        if (!level.isClientSide() && ServerConfig.validDimensions != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (ServerConfig.validDimensions.contains(level.dimension())) {
                WeatherHandlerServer weatherHandler = (WeatherHandlerServer)GameBusEvents.MANAGERS.get(level.dimension());
                ThermodynamicEngine.AtmosphericDataPoint sfc = ThermodynamicEngine.samplePoint((WeatherHandler)weatherHandler, (Vec3)pos.getCenter(), (Level)level, (RadarBlockEntity)null, (int)0);
                this.temperature = sfc.temperature();
                this.dew = sfc.dewpoint();
                this.pressure = sfc.pressure();
                if (this.temperature != 0.0f && this.temperature < this.temperatureMin) {
                    this.temperatureMin = this.temperature;
                }
                if (this.temperature > this.temperatureMax) {
                    this.temperatureMax = this.temperature;
                }
                if (this.pressure != 0.0f && this.pressure < this.pressureMin) {
                    this.pressureMin = this.pressure;
                }
                if (this.pressure > this.pressureMax) {
                    this.pressureMax = this.pressure;
                }
                if (this.dew != 0.0f && this.dew < this.dewMin) {
                    this.dewMin = this.dew;
                }
                if (this.dew > this.dewMax) {
                    this.dewMax = this.dew;
                }
                this.setChanged();
            }
        }
    }

    public void readAtmosphericConditionsClient(BlockPos pos, Level level) {
        if (level.isClientSide()) {
            ThermodynamicEngine.AtmosphericDataPoint sfc = ThermodynamicEngine.samplePoint((WeatherHandler)GameBusClientEvents.weatherHandler, (Vec3)pos.getCenter(), (Level)level, (RadarBlockEntity)null, (int)0);
            this.temperature = sfc.temperature();
            this.dew = sfc.dewpoint();
            this.pressure = sfc.pressure();
            if (this.temperature != 0.0f && this.temperature < this.temperatureMin) {
                this.temperatureMin = this.temperature;
            }
            if (this.temperature > this.temperatureMax) {
                this.temperatureMax = this.temperature;
            }
            if (this.pressure != 0.0f && this.pressure < this.pressureMin) {
                this.pressureMin = this.pressure;
            }
            if (this.pressure > this.pressureMax) {
                this.pressureMax = this.pressure;
            }
            if (this.dew != 0.0f && this.dew < this.dewMin) {
                this.dewMin = this.dew;
            }
            if (this.dew > this.dewMax) {
                this.dewMax = this.dew;
            }
            this.setChanged();
        }
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        double windspeed;
        if (this.level == null) {
            return;
        }
        this.current_time = level.getGameTime();
        if (this.probeTime == 0L) {
            this.probeTime = this.current_time;
        }
        Vec3 wind = WindEngine.getWind((BlockPos)blockPos, (Level)level);
        this.winddir = Math.floorMod((int)Math.toDegrees(Math.atan2(-wind.x, wind.z)), 360);
        this.WindSpeed = windspeed = wind.length();
        if (this.current_time - this.probeTime < 6000L && this.IsValidPlacement && this.current_time - this.probeTime > 40L && this.WindSpeed > this.WindMax) {
            this.WindMax = this.WindSpeed;
        }
        if (Double.isNaN(this.WindSpeed)) {
            this.WindSpeed = 1.0;
            this.winddir = 1.0f;
        }
        if (this.current_time - this.probeTime > 20L || this.current_time % 40L == 0L) {
            int i = level.getBrightness(LightLayer.SKY, blockPos);
            if (i <= 14) {
                ++this.skyCount;
            }
            if (i > 14) {
                this.skyCount = 0;
            }
            if (this.WindSpeed == 0.0 && (double)this.winddir == 0.0 || this.skyCount >= 4 || Objects.requireNonNull(level).dimension() != Level.OVERWORLD) {
                this.skyCount = 5;
                this.setPlacementValidity(false);
            } else {
                this.setPlacementValidity(true);
            }
        }
        if (!level.isClientSide() && this.current_time - this.probeTime > 20L && this.current_time % 20L == 0L && this.IsValidPlacement && this.current_time - this.probeTime < 6000L) {
            this.timeExposedInWind(this.WindSpeed);
            this.readAtmosphericConditions(blockPos, level);
        }
        if (level.isClientSide()) {
            if (this.current_time - this.probeTime > 20L && this.current_time % 20L == 0L && this.IsValidPlacement && this.current_time - this.probeTime < 6000L) {
                this.readAtmosphericConditionsClient(blockPos, level);
            }
            this.angleDiff = this.winddir - this.vaneAngle;
            if (this.angleDiff > 360.0f) {
                this.vaneAngle = this.winddir;
            }
            if (this.angleDiff < -360.0f) {
                this.vaneAngle = this.winddir;
            }
            double windSpeedFactor = Math.pow(windspeed, 2.0) / (Math.pow(windspeed, 2.0) + 20000.0);
            double windSpeedFactor2 = Math.pow(windspeed, 2.0) / (Math.pow(windspeed, 2.0) + 2000.0);
            if (!Double.isNaN(windSpeedFactor2)) {
                if (this.angleDiff > 180.0f) {
                    angleDiff2 = 360.0f - this.angleDiff;
                    this.vaneAngle -= (float)(windSpeedFactor2 * angleDiff2 + (Math.random() - 0.5) * windSpeedFactor * 45.0);
                } else if (this.angleDiff < -180.0f) {
                    angleDiff2 = 360.0f + this.angleDiff;
                    this.vaneAngle += (float)(windSpeedFactor2 * angleDiff2 + (Math.random() - 0.5) * windSpeedFactor * 45.0);
                } else {
                    this.vaneAngle += (float)((double)this.angleDiff * windSpeedFactor2 + (Math.random() - 0.5) * windSpeedFactor * 45.0);
                }
                if (this.vaneAngle % 360.0f == 0.0f) {
                    int divider = (int)((double)this.vaneAngle + 0.5) / 360;
                    this.vaneAngle -= (float)(divider * 360);
                }
                if (this.vaneAngle < 0.0f) {
                    this.vaneAngle = 360.0f - this.vaneAngle;
                }
                double rotMax = 70.0;
                double maxSpeed = windspeed * 1.609 / 0.1875 * 3.6 / (Math.PI * 2) * 0.7;
                if ((double)this.smoothAngleRotationalVel < maxSpeed) {
                    this.smoothAngleRotationalVel += (float)windspeed / 5.0f;
                }
                if ((double)this.smoothAngleRotationalVel > rotMax) {
                    this.smoothAngleRotationalVel = (float)rotMax;
                }
                if (this.smoothAngle >= 180.0f) {
                    this.smoothAngle -= 360.0f;
                }
                this.prevSmoothAngle = this.smoothAngle;
                this.smoothAngle += this.smoothAngleRotationalVel;
                this.smoothAngleRotationalVel -= 0.01f;
                this.smoothAngleRotationalVel *= 0.99f;
                if (this.smoothAngleRotationalVel <= 0.0f) {
                    this.smoothAngleRotationalVel = 0.0f;
                }
            }
        }
    }

    public double OutputWind() {
        return this.WindSpeed;
    }

    public float OutputDir() {
        return this.vaneAngle;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag postag = new CompoundTag();
        this.saveAdditional(postag, registries);
        return postag;
    }

    public void handleUpdateTag(CompoundTag postag, HolderLookup.Provider registries) {
        this.WindMax = postag.getDouble("windMax");
        this.temperatureMax = postag.getFloat("tempMax");
        this.temperatureMin = postag.getFloat("tempMin");
        this.dewMax = postag.getFloat("dewMax");
        this.dewMin = postag.getFloat("dewMin");
        this.pressureMin = postag.getFloat("pressMin");
        this.pressureMax = postag.getFloat("pressMax");
        this.probeTime = postag.getLong("probeTime");
        this.drops = postag.getInt("drops");
        this.time110mph = postag.getInt("time110mph");
        this.time150mph = postag.getInt("time150mph");
        this.time220mph = postag.getInt("time220mph");
        this.time260mph = postag.getInt("time260mph");
        this.time320mph = postag.getInt("time300mph");
        super.handleUpdateTag(postag, registries);
    }

    public void saveAdditional(CompoundTag postag, HolderLookup.Provider registries) {
        postag.putDouble("windMax", this.WindMax);
        postag.putFloat("tempMax", this.temperatureMax);
        postag.putFloat("tempMin", this.temperatureMin);
        postag.putFloat("dewMin", this.dewMin);
        postag.putFloat("dewMax", this.dewMax);
        postag.putFloat("pressMax", this.pressureMax);
        postag.putFloat("pressMin", this.pressureMin);
        postag.putLong("probeTime", this.probeTime);
        postag.putInt("drops", this.drops);
        postag.putInt("time110mph", this.time110mph);
        postag.putInt("time150mph", this.time150mph);
        postag.putInt("time220mph", this.time220mph);
        postag.putInt("time260mph", this.time260mph);
        postag.putInt("time300mph", this.time320mph);
        super.saveAdditional(postag, registries);
    }

    public void loadAdditional(@NotNull CompoundTag postag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(postag, registries);
        this.WindMax = postag.getDouble("windMax");
        this.temperatureMax = postag.getFloat("tempMax");
        this.temperatureMin = postag.getFloat("tempMin");
        this.dewMax = postag.getFloat("dewMax");
        this.dewMin = postag.getFloat("dewMin");
        this.pressureMin = postag.getFloat("pressMin");
        this.pressureMax = postag.getFloat("pressMax");
        this.probeTime = postag.getLong("probeTime");
        this.drops = postag.getInt("drops");
        this.time110mph = postag.getInt("time110mph");
        this.time150mph = postag.getInt("time150mph");
        this.time220mph = postag.getInt("time220mph");
        this.time260mph = postag.getInt("time260mph");
        this.time320mph = postag.getInt("time300mph");
    }
}

