/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.entity;

import dev.protomanly.pmweather.weather.WindEngine;
import net.elton.windmeter.WindmeterClientConfig;
import net.elton.windmeter.block.custom.SmallCarbonWindTurbineBlock;
import net.elton.windmeter.block.entity.ModBlockEntities;
import net.elton.windmeter.util.WindmeterEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmallCarbonWindTurbineBlockEntity
extends BlockEntity {
    private final MinecraftServer server;
    int xPos = 0;
    int yPos = 0;
    int zPos = 0;
    private int requested_channel = 0;
    private int count = 0;
    private int skyCount = 0;
    private long prevGameTime = 0L;
    private boolean IsValidPlacement = false;
    private boolean IsValidChannel = false;
    private int channel_changed = 0;
    private int channel = 0;
    public float smoothAngle = 0.0f;
    public float prevSmoothAngle = 0.0f;
    public float smoothAngleRotationalVel = 0.0f;
    public float winddir = 0.0f;
    public float angleDiff = 0.0f;
    public float vaneAngle = 0.0f;
    public float vaneAngle2 = 0.0f;
    public float nacelleAngle = 0.0f;
    public float towerAngleX = 0.0f;
    public float towerAngleZ = 0.0f;
    public double WindSpeed = 0.0;
    public double RotorWindSpeed = 0.0;
    public int wobbleAngle = 0;
    public int damagedLevel = 0;
    private int time_divisor = 1;
    double variance2 = 0.0;
    private double damageWSpeed1 = 110.0 + Math.random() * 30.0;
    private double damageWSpeed2 = 144.0 + Math.random() * 30.0;
    public boolean rotorDamage = false;
    private boolean updateFlag = false;
    private int energyPerTick = 0;
    private AttachFace attachtype;
    private BlockCapabilityCache<IEnergyStorage, @Nullable Direction> capCache;
    public final WindmeterEnergyStorage energy = new WindmeterEnergyStorage(50000, 0, 9999999, 0);

    public SmallCarbonWindTurbineBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.SMALL_CARBON_WIND_TURBINE_BE.get(), pos, blockState);
        this.xPos = pos.getX();
        this.yPos = pos.getY();
        this.zPos = pos.getZ();
        this.server = ServerLifecycleHooks.getCurrentServer();
        this.attachtype = (AttachFace)blockState.getValue(SmallCarbonWindTurbineBlock.ATTACHMENT);
    }

    public void onLoad() {
        Level level = this.level;
        if (level != null && !level.isClientSide) {
            this.capCache = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)((ServerLevel)level), (BlockPos)this.getBlockPos().below(), (Object)Direction.UP);
        }
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        double windspeed;
        if (this.level == null) {
            return;
        }
        Vec3 wind = WindEngine.getWind((BlockPos)blockPos, (Level)level);
        this.winddir = Math.floorMod((int)Math.toDegrees(Math.atan2(-wind.x, wind.z)), 360);
        this.WindSpeed = windspeed = wind.length();
        if (!Double.isNaN(this.WindSpeed)) {
            this.nacelleAngle = this.vaneAngle;
            this.RotorWindSpeed = windspeed;
            if (level.isClientSide() && level.getGameTime() % 3L == 0L && this.RotorWindSpeed > 120.0 && WindmeterClientConfig.sparks) {
                level.addParticle((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, (double)blockPos.getX() + 0.5 + 0.2 * Math.cos(Math.toRadians(this.nacelleAngle + 90.0f)), (double)blockPos.getY() + 0.8, (double)blockPos.getZ() + 0.5 + 0.2 * Math.sin(Math.toRadians(this.nacelleAngle + 90.0f)), 0.0, 0.0, 0.0);
            }
            if (!level.isClientSide() && this.damagedLevel < 2) {
                IEnergyStorage handler;
                if (level.getGameTime() % 10L == 0L) {
                    this.energyPerTick = (int)(0.8620530241450393 * Math.pow(this.RotorWindSpeed / 2.237, 3.0) * 10.0 / 20.0);
                    if (this.energy.getEnergyStored() < this.energy.getMaxEnergyStored()) {
                        this.energy.addEnergy(this.energyPerTick);
                    }
                }
                if ((handler = (IEnergyStorage)this.capCache.getCapability()) != null) {
                    if (handler.getEnergyStored() < handler.getMaxEnergyStored() && this.energy.getMaxEnergyStored() - 1 > this.energyPerTick) {
                        handler.receiveEnergy(this.energy.extractEnergy(Math.clamp((long)(handler.getMaxEnergyStored() - handler.getEnergyStored()), 0, this.energyPerTick / 10 + 2), false), false);
                    } else if (handler.getEnergyStored() < handler.getMaxEnergyStored()) {
                        handler.receiveEnergy(Math.clamp((long)(handler.getMaxEnergyStored() - handler.getEnergyStored()), 0, this.energyPerTick / 10), false);
                    } else {
                        level.invalidateCapabilities(this.getBlockPos().below());
                    }
                }
            }
            if (level.isClientSide()) {
                this.angleDiff = this.winddir - this.vaneAngle;
                if (this.angleDiff > 360.0f) {
                    this.vaneAngle = this.winddir;
                }
                if (this.angleDiff < -360.0f) {
                    this.vaneAngle = this.winddir;
                }
                double windSpeedFactor = Math.pow(windspeed, 2.0) / (Math.pow(windspeed, 2.0) + 20000.0);
                double windSpeedFactor2 = Math.pow(windspeed, 2.0) / (Math.pow(windspeed, 2.0) + 2000.0);
                if (!Double.isNaN(windSpeedFactor2)) {
                    this.time_divisor = 1 + (int)(150.0 / (this.WindSpeed + 1.0));
                    if (level.getGameTime() % (long)this.time_divisor == 0L) {
                        this.variance2 = (Math.random() - 0.5) * windSpeedFactor * 30.0;
                    }
                    if (this.angleDiff > 180.0f) {
                        angleDiff2 = 360.0f - this.angleDiff;
                        this.vaneAngle -= (float)(windSpeedFactor2 * angleDiff2 + this.variance2);
                    } else if (this.angleDiff < -180.0f) {
                        angleDiff2 = 360.0f + this.angleDiff;
                        this.vaneAngle += (float)(windSpeedFactor2 * angleDiff2 + this.variance2);
                    } else {
                        this.vaneAngle += (float)((double)this.angleDiff * windSpeedFactor2 + this.variance2);
                    }
                }
                if (this.vaneAngle < 0.0f) {
                    this.vaneAngle = 360.0f - this.vaneAngle;
                }
                double rotMax = 300.0;
                double maxSpeed = this.RotorWindSpeed * 1.609 * 7.0 / 3.6 / 0.7 / (Math.PI * 2) * 360.0;
                if ((double)this.smoothAngleRotationalVel < maxSpeed) {
                    this.smoothAngleRotationalVel += (float)this.RotorWindSpeed / 30.0f;
                }
                if ((double)this.smoothAngleRotationalVel > rotMax) {
                    this.smoothAngleRotationalVel = (float)rotMax;
                }
                if (this.smoothAngle >= 180.0f) {
                    this.smoothAngle -= 360.0f;
                }
                this.prevSmoothAngle = this.smoothAngle;
                this.smoothAngle += this.smoothAngleRotationalVel;
                this.smoothAngleRotationalVel -= 0.01f;
                this.smoothAngleRotationalVel *= 0.99f;
                if (this.smoothAngleRotationalVel <= 0.0f) {
                    this.smoothAngleRotationalVel = 0.0f;
                }
            }
        }
    }

    public double OutputWind() {
        return this.WindSpeed;
    }

    public float OutputDir() {
        return this.vaneAngle;
    }

    public int getEnergy() {
        return this.energy.getEnergyStored();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag postag = new CompoundTag();
        this.saveAdditional(postag, registries);
        return postag;
    }

    public void handleUpdateTag(CompoundTag postag, HolderLookup.Provider registries) {
        super.handleUpdateTag(postag, registries);
    }

    private void sendUpdate() {
        this.updateFlag = false;
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void saveAdditional(CompoundTag postag, HolderLookup.Provider registries) {
        super.saveAdditional(postag, registries);
        if (!this.updateFlag) {
            postag.put("Energy", this.energy.serializeNBT(registries));
        } else {
            postag.put("Energy", this.energy.serializeNBT(registries));
            this.updateFlag = false;
        }
    }

    public void loadAdditional(@NotNull CompoundTag postag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(postag, registries);
        if (!this.updateFlag) {
            this.vaneAngle = postag.getFloat("vaneAngle");
            this.nacelleAngle = postag.getFloat("nacelleAngle");
            this.wobbleAngle = postag.getInt("wobbleAngle");
            this.damagedLevel = postag.getInt("damagedLevel");
            this.damageWSpeed1 = postag.getDouble("damageWSpeed1");
            this.damageWSpeed2 = postag.getDouble("damageWSpeed2");
            if (postag.contains("Energy", 3)) {
                this.energy.deserializeNBT(registries, postag.get("Energy"));
            }
        } else if (postag.contains("Energy", 3)) {
            this.energy.deserializeNBT(registries, postag.get("Energy"));
            this.updateFlag = false;
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

