/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.entity;

import dev.protomanly.pmweather.block.entity.RadarBlockEntity;
import dev.protomanly.pmweather.config.ServerConfig;
import dev.protomanly.pmweather.event.GameBusClientEvents;
import dev.protomanly.pmweather.event.GameBusEvents;
import dev.protomanly.pmweather.weather.Sounding;
import dev.protomanly.pmweather.weather.ThermodynamicEngine;
import dev.protomanly.pmweather.weather.WeatherHandler;
import dev.protomanly.pmweather.weather.WeatherHandlerServer;
import dev.protomanly.pmweather.weather.WindEngine;
import java.util.Objects;
import net.elton.windmeter.Data.WindmeterData;
import net.elton.windmeter.block.entity.ModBlockEntities;
import net.elton.windmeter.network.ChannelDataDisp;
import net.elton.windmeter.network.ClientPayloadHandlerDisp;
import net.elton.windmeter.network.ServerPayloadHandlerDisp;
import net.elton.windmeter.screen.custon.WeatherDisplayMenu;
import net.elton.windmeter.util.WindMeterUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeatherDisplayBlockEntity
extends BlockEntity
implements MenuProvider {
    int[] posArray = new int[]{0, 0, 0};
    private int ticks = 0;
    private long prevGameTime;
    int xPos = 0;
    int yPos = 0;
    int zPos = 0;
    int xPosW = 0;
    int yPosW = 0;
    int zPosW = 0;
    public long displayTime = 0L;
    public long current_time = 0L;
    public int channel = 0;
    public float smoothAngle = 0.0f;
    public float prevSmoothAngle = 0.0f;
    public float winddir = 0.0f;
    public float angleDiff = 0.0f;
    private final MinecraftServer server;
    public float vaneAngle = 0.0f;
    public double WindSpeed = 0.0;
    public float vaneAngleToOutput = 0.0f;
    public double WindSpeedToOutput = 0.0;
    public double WindMax = 0.0;
    public float temperature = 0.0f;
    public float temperatureMax = -999.0f;
    public float temperatureMin = 999.0f;
    public float dew = 0.0f;
    public float dewMax = -999.0f;
    public float dewMin = 999.0f;
    public float pressure = 0.0f;
    public float pressureMax = 0.0f;
    public float pressureMin = 9999.0f;
    private int varReset = 1;
    float riskV = 0.0f;
    float peakRiskOffset = 0.0f;
    float risk2 = 0.0f;
    float risk3 = 0.0f;
    public String StrRiskV = "";
    public String StrRisk2 = "";
    public String StrRisk3 = "";

    public WeatherDisplayBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.WEATHER_DISPLAY_BE.get(), pos, blockState);
        this.xPos = pos.getX();
        this.yPos = pos.getY();
        this.zPos = pos.getZ();
        this.server = ServerLifecycleHooks.getCurrentServer();
    }

    public void ClearChannel(int x, int y, int z) {
        this.xPos = 0;
        this.yPos = 0;
        this.zPos = 0;
    }

    public int getChannel() {
        return this.channel;
    }

    public void readAtmosphericConditions(BlockPos pos, Level level) {
        if (!level.isClientSide() && ServerConfig.validDimensions != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (ServerConfig.validDimensions.contains(level.dimension())) {
                WeatherHandlerServer weatherHandler = (WeatherHandlerServer)GameBusEvents.MANAGERS.get(level.dimension());
                if (this.WindSpeed != -1.0) {
                    pos = new BlockPos(this.xPosW, this.yPosW, this.zPosW);
                }
                ThermodynamicEngine.AtmosphericDataPoint sfc = ThermodynamicEngine.samplePoint((WeatherHandler)weatherHandler, (Vec3)pos.getCenter(), (Level)level, (RadarBlockEntity)null, (int)0);
                this.temperature = sfc.temperature();
                this.dew = sfc.dewpoint();
                this.pressure = sfc.pressure();
                if (this.temperature != 0.0f && this.temperature < this.temperatureMin) {
                    this.temperatureMin = this.temperature;
                }
                if (this.temperature > this.temperatureMax) {
                    this.temperatureMax = this.temperature;
                }
                if (this.pressure != 0.0f && this.pressure < this.pressureMin) {
                    this.pressureMin = this.pressure;
                }
                if (this.pressure > this.pressureMax) {
                    this.pressureMax = this.pressure;
                }
                if (this.dew != 0.0f && this.dew < this.dewMin) {
                    this.dewMin = this.dew;
                }
                if (this.dew > this.dewMax) {
                    this.dewMax = this.dew;
                }
                this.setChanged();
            }
        }
    }

    public void readAtmosphericConditionsClient(BlockPos pos, Level level) {
        if (level.isClientSide()) {
            if (this.WindSpeed != -1.0) {
                pos = new BlockPos(this.xPosW, this.yPosW, this.zPosW);
            }
            ThermodynamicEngine.AtmosphericDataPoint sfc = ThermodynamicEngine.samplePoint((WeatherHandler)GameBusClientEvents.weatherHandler, (Vec3)pos.getCenter(), (Level)level, (RadarBlockEntity)null, (int)0);
            this.temperature = sfc.temperature();
            this.dew = sfc.dewpoint();
            this.pressure = sfc.pressure();
            if (this.temperature != 0.0f && this.temperature < this.temperatureMin) {
                this.temperatureMin = this.temperature;
            }
            if (this.temperature > this.temperatureMax) {
                this.temperatureMax = this.temperature;
            }
            if (this.pressure != 0.0f && this.pressure < this.pressureMin) {
                this.pressureMin = this.pressure;
            }
            if (this.pressure > this.pressureMax) {
                this.pressureMax = this.pressure;
            }
            if (this.dew != 0.0f && this.dew < this.dewMin) {
                this.dewMin = this.dew;
            }
            if (this.dew > this.dewMax) {
                this.dewMax = this.dew;
            }
            if (this.temperatureMin < -572.0f) {
                this.temperatureMin = -572.0f;
            }
            if (this.temperatureMax > 537.0f) {
                this.temperatureMax = 537.0f;
            }
            if (this.dewMin < -572.0f) {
                this.dewMin = -572.0f;
            }
            if (this.dewMax > 537.0f) {
                this.dewMax = 537.0f;
            }
            this.setChanged();
        }
    }

    public void getRisk(Level level, BlockPos pos) {
        float r;
        Sounding sounding;
        int i;
        this.riskV = 0.0f;
        this.risk2 = 0.0f;
        this.risk3 = 0.0f;
        for (i = 0; i < 24000; i += 200) {
            sounding = new Sounding(GameBusClientEvents.weatherHandler, pos.getCenter(), level, 250, 16000, i);
            r = sounding.getRisk(i);
            if (!(r > this.riskV)) continue;
            this.riskV = r;
        }
        for (i = 24000; i < 48000; i += 400) {
            sounding = new Sounding(GameBusClientEvents.weatherHandler, pos.getCenter(), level, 250, 16000, i);
            r = sounding.getRisk(i);
            if (!(r > this.risk2)) continue;
            this.risk2 = r;
        }
        for (i = 48000; i < 72000; i += 800) {
            sounding = new Sounding(GameBusClientEvents.weatherHandler, pos.getCenter(), level, 250, 16000, i);
            r = sounding.getRisk(i);
            if (!(r > this.risk3)) continue;
            this.risk3 = r;
        }
        this.StrRisk3 = this.riskToString(this.risk3);
        this.StrRisk2 = this.riskToString(this.risk2);
        this.StrRiskV = this.riskToString(this.riskV);
    }

    String riskToString(float riskV) {
        String risk = "NONE [0/6]";
        if (riskV > 1.5f) {
            risk = "HIGH [6/6]";
        } else if (riskV > 1.2f) {
            risk = "MDT [5/6]";
        } else if (riskV > 0.8f) {
            risk = "ENH [4/6]";
        } else if (riskV > 0.6f) {
            risk = "SLGT [3/6]";
        } else if (riskV > 0.3f) {
            risk = "MRGL [2/6]";
        } else if (riskV > 0.15f) {
            risk = "TSTM [1/6]";
        }
        return risk;
    }

    void getWindSpeed(Level plevel, BlockPos pos) {
        BlockPos pos1 = new BlockPos(this.xPosW, this.yPosW, this.zPosW);
        BlockEntity be = plevel.getBlockEntity(pos1);
        if (this.channel != 0 && (this.xPosW != 0 || this.yPosW != 0 || this.zPosW != 0) && Objects.requireNonNull(this.level).dimension() == Level.OVERWORLD) {
            double windspeed;
            Vec3 wind = WindEngine.getWind((BlockPos)pos1, (Level)this.level);
            this.winddir = Math.floorMod((int)Math.toDegrees(Math.atan2(-wind.x, wind.z)), 360);
            this.WindSpeed = windspeed = wind.length();
            if (this.level.isClientSide) {
                this.angleDiff = this.winddir - this.vaneAngle;
                if (this.angleDiff > 360.0f) {
                    this.vaneAngle = this.winddir;
                    if (this.channel > 100) {
                        this.channel = 0;
                    }
                }
                if (this.angleDiff < -360.0f) {
                    this.vaneAngle = this.winddir;
                }
                double windSpeedFactor = Math.pow(windspeed, 2.0) / (Math.pow(windspeed, 2.0) + 20000.0);
                double windSpeedFactor2 = Math.pow(windspeed, 2.0) / (Math.pow(windspeed, 2.0) + 2000.0);
                if (!Double.isNaN(windSpeedFactor2)) {
                    if (Math.abs(this.angleDiff) > 0.0f) {
                        if (this.angleDiff > 180.0f) {
                            angleDiff2 = 360.0f - this.angleDiff;
                            this.vaneAngle -= (float)(windSpeedFactor2 * angleDiff2 + (Math.random() - 0.5) * windSpeedFactor * 45.0);
                        } else if (this.angleDiff < -180.0f) {
                            angleDiff2 = 360.0f + this.angleDiff;
                            this.vaneAngle += (float)(windSpeedFactor2 * angleDiff2 + (Math.random() - 0.5) * windSpeedFactor * 45.0);
                        } else {
                            this.vaneAngle += (float)((double)this.angleDiff * windSpeedFactor2 + (Math.random() - 0.5) * windSpeedFactor * 45.0);
                        }
                    } else {
                        return;
                    }
                    if (this.vaneAngle >= 360.0f) {
                        int divider = (int)((double)this.vaneAngle + 0.5) / 360;
                        this.vaneAngle -= (float)(divider * 360);
                    }
                    if (this.vaneAngle < 0.0f) {
                        this.vaneAngle = 360.0f - this.vaneAngle;
                    }
                }
            }
        } else {
            this.WindSpeed = -1.0;
            this.vaneAngle = 0.0f;
        }
    }

    public void randomSearchForAnemometers() {
        if (!(this.level.getGameTime() - this.prevGameTime != 20L && this.level.getGameTime() % 40L != 0L || this.channel == 0 && this.WindSpeed != -1.0)) {
            if (!this.level.isClientSide()) {
                WindmeterData data = WindmeterData.requestData(this.server);
                this.xPosW = data.posArrayX.get(this.channel);
                this.yPosW = data.posArrayY.get(this.channel);
                this.zPosW = data.posArrayZ.get(this.channel);
                this.setChanged();
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
            if (this.level.isClientSide()) {
                this.xPosW = WindMeterUtils.getWMPosX(this.channel);
                this.yPosW = WindMeterUtils.getWMPosY(this.channel);
                this.zPosW = WindMeterUtils.getWMPosZ(this.channel);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void GetChannelFromClient() {
        if (this.level.isClientSide() || this.level.getGameTime() % 10L != 0L || ServerPayloadHandlerDisp.ChannelDataUpdateDisplay[0] == this.channel && this.WindSpeed != -1.0) return;
        BlockPos pos3 = new BlockPos(this.xPos, this.yPos, this.zPos);
        BlockEntity be = this.level.getBlockEntity(pos3);
        if (!(be instanceof WeatherDisplayBlockEntity)) return;
        WeatherDisplayBlockEntity blockEntity = (WeatherDisplayBlockEntity)be;
        if (ServerPayloadHandlerDisp.ChannelDataUpdateDisplay[1] != this.xPos || ServerPayloadHandlerDisp.ChannelDataUpdateDisplay[2] != this.yPos || ServerPayloadHandlerDisp.ChannelDataUpdateDisplay[3] != this.zPos) return;
        this.channel = ServerPayloadHandlerDisp.ChannelDataUpdateDisplay[0];
        this.xPosW = WindmeterData.requestData((MinecraftServer)this.server).posArrayX.get(this.channel);
        this.yPosW = WindmeterData.requestData((MinecraftServer)this.server).posArrayY.get(this.channel);
        this.zPosW = WindmeterData.requestData((MinecraftServer)this.server).posArrayZ.get(this.channel);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ChannelDataDisp(this.channel, this.xPos, this.yPos, this.zPos, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        WindMeterUtils.ClearPayloads();
        System.out.println("CHANNEL IS: " + this.channel);
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void SendChannelToClient() {
        if (!this.level.isClientSide() || this.level.getGameTime() % 40L != 0L || ClientPayloadHandlerDisp.ChannelDataUpdateDisplay[0] == this.channel && this.WindSpeed != -1.0) return;
        BlockPos pos3 = new BlockPos(this.xPos, this.yPos, this.zPos);
        BlockEntity be = this.level.getBlockEntity(pos3);
        if (!(be instanceof WeatherDisplayBlockEntity)) return;
        WeatherDisplayBlockEntity blockEntity = (WeatherDisplayBlockEntity)be;
        if (ClientPayloadHandlerDisp.ChannelDataUpdateDisplay[1] != this.xPos || ClientPayloadHandlerDisp.ChannelDataUpdateDisplay[2] != this.yPos || ClientPayloadHandlerDisp.ChannelDataUpdateDisplay[3] != this.zPos) return;
        this.channel = ClientPayloadHandlerDisp.ChannelDataUpdateDisplay[0];
        this.xPosW = WindMeterUtils.getWMPosX(this.channel);
        this.yPosW = WindMeterUtils.getWMPosY(this.channel);
        this.zPosW = WindMeterUtils.getWMPosZ(this.channel);
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public void tick(Level plevel, BlockPos pblockPos, BlockState pblockState) {
        if (this.level == null) {
            return;
        }
        this.current_time = this.level.getGameTime();
        if (this.displayTime == 0L) {
            this.displayTime = this.current_time;
        }
        this.GetChannelFromClient();
        this.SendChannelToClient();
        this.getWindSpeed(plevel, pblockPos);
        this.randomSearchForAnemometers();
        double windspeed = this.WindSpeed;
        if (!this.level.isClientSide() && (this.current_time - this.displayTime > 20L && this.current_time % 1200L == 0L || this.varReset == 1 && this.current_time - this.displayTime > 40L)) {
            this.varReset = 0;
            this.readAtmosphericConditions(pblockPos, this.level);
        }
        if (this.level.isClientSide() && (this.current_time - this.displayTime > 20L && this.current_time % 1200L == 0L || this.varReset == 1 && this.current_time - this.displayTime > 40L)) {
            this.varReset = 0;
            this.getRisk(this.level, pblockPos);
            this.readAtmosphericConditionsClient(pblockPos, this.level);
        }
        if ((int)(this.WindMax + 0.5) < (int)(windspeed + 0.5)) {
            this.WindMax = windspeed;
            if (this.WindMax > 621.0) {
                this.WindMax = 621.0;
            }
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.setChanged();
        }
        if (this.level.getGameTime() % 40L == 0L) {
            this.vaneAngleToOutput = this.vaneAngle;
            if (this.WindSpeed > 621.0) {
                this.WindSpeed = 621.0;
            }
            this.WindSpeedToOutput = this.WindSpeed;
        }
    }

    public double OutputWind() {
        return this.WindSpeed;
    }

    public float OutputDir() {
        return this.vaneAngle;
    }

    public void ResetVariables() {
        this.varReset = 1;
        this.WindMax = 0.0;
        this.temperatureMin = 999.0f;
        this.temperatureMax = -999.0f;
        this.dewMax = -999.0f;
        this.dewMin = 999.0f;
        this.pressureMax = 0.0f;
        this.pressureMin = 9999.0f;
        this.setChanged();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag postag = new CompoundTag();
        this.saveAdditional(postag, registries);
        return postag;
    }

    public void handleUpdateTag(CompoundTag postag, HolderLookup.Provider registries) {
        this.zPosW = postag.getInt("zPosW");
        this.yPosW = postag.getInt("yPosW");
        this.xPosW = postag.getInt("xPosW");
        this.posArray = postag.getIntArray("posArray");
        this.WindMax = postag.getDouble("WindMax");
        this.temperatureMax = postag.getFloat("tempMax");
        this.temperatureMin = postag.getFloat("tempMin");
        this.dewMax = postag.getFloat("dewMax");
        this.dewMin = postag.getFloat("dewMin");
        this.pressureMin = postag.getFloat("pressMin");
        this.pressureMax = postag.getFloat("pressMax");
        this.channel = postag.getInt("channel");
        super.handleUpdateTag(postag, registries);
    }

    public void saveAdditional(CompoundTag postag, HolderLookup.Provider registries) {
        postag.putIntArray("posArray", this.posArray);
        postag.putDouble("WindMax", this.WindMax);
        postag.putFloat("tempMax", this.temperatureMax);
        postag.putFloat("tempMin", this.temperatureMin);
        postag.putFloat("dewMin", this.dewMin);
        postag.putFloat("dewMax", this.dewMax);
        postag.putFloat("pressMax", this.pressureMax);
        postag.putFloat("pressMin", this.pressureMin);
        postag.putInt("channel", this.channel);
        super.saveAdditional(postag, registries);
    }

    public void loadAdditional(@NotNull CompoundTag postag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(postag, registries);
        this.WindMax = postag.getDouble("WindMax");
        this.temperatureMax = postag.getFloat("tempMax");
        this.temperatureMin = postag.getFloat("tempMin");
        this.dewMax = postag.getFloat("dewMax");
        this.dewMin = postag.getFloat("dewMin");
        this.pressureMin = postag.getFloat("pressMin");
        this.pressureMax = postag.getFloat("pressMax");
        this.channel = postag.getInt("channel");
    }

    public Component getDisplayName() {
        return Component.literal((String)"Wind display channel setup");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new WeatherDisplayMenu(i, inventory, this);
    }
}

