/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.entity;

import dev.protomanly.pmweather.weather.WindEngine;
import net.elton.windmeter.block.entity.ModBlockEntities;
import net.elton.windmeter.util.WindmeterServerConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class WindSockBlockEntity
extends BlockEntity {
    int xPos = 0;
    int yPos = 0;
    int zPos = 0;
    public float smoothAngle = 0.0f;
    public float prevSmoothAngle = 0.0f;
    public float angleDiff2 = 0.0f;
    public float angleDiff3 = 0.0f;
    public float angleDiff4 = 0.0f;
    public float angleDiff5 = 0.0f;
    public float winddir = 0.0f;
    public float angleDiff = 0.0f;
    public float vaneAngle = 0.0f;
    public double windUpwardAngle = 0.0;
    public float sockAngle2 = 0.0f;
    public float sockAngle3 = 0.0f;
    public float sockAngle4 = 0.0f;
    public float sockAngle5 = 0.0f;
    public double WindSpeed = 0.0;
    public float sockAngle2ToRender = 0.0f;
    public float sockAngle3ToRender = 0.0f;
    public float sockAngle4ToRender = 0.0f;
    public float sockAngle5ToRender = 0.0f;
    double variance = 0.0;
    double variance2 = 0.0;
    double variance3 = 0.0;
    public int damagedLevel = 0;
    public int Scale = 1;
    private double damageWSpeed = 144.0 + Math.random() * 30.0;
    private int time_divisor = 1;

    public WindSockBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.WIND_SOCK_BE.get(), pos, blockState);
        this.xPos = pos.getX();
        this.yPos = pos.getY();
        this.zPos = pos.getZ();
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        double windspeed;
        if (this.level == null) {
            return;
        }
        if (!blockState.canSurvive((LevelReader)level, blockPos)) {
            level.destroyBlock(blockPos, true);
        }
        Vec3 wind = WindEngine.getWind((BlockPos)blockPos, (Level)level);
        this.winddir = Math.floorMod((int)Math.toDegrees(Math.atan2(-wind.x, wind.z)), 360);
        this.WindSpeed = windspeed = wind.length();
        if (Double.isNaN(this.WindSpeed)) {
            this.WindSpeed = 1.0;
            this.winddir = 1.0f;
        }
        if (!WindmeterServerConfig.sockDamage && this.damagedLevel != -1) {
            this.damagedLevel = -1;
        }
        if (WindmeterServerConfig.sockDamage && this.damagedLevel == -1) {
            this.damagedLevel = 0;
        }
        if (!Double.isNaN(this.WindSpeed)) {
            if (this.WindSpeed > this.damageWSpeed && this.damagedLevel != 1 && this.damagedLevel != -1) {
                this.damagedLevel = 1;
            }
            if (this.damagedLevel == 1 && this.Scale != 0) {
                this.Scale = 0;
                this.setChanged();
            }
        }
        if (level.isClientSide()) {
            this.windUpwardAngle = Math.atan(wind.y / windspeed);
            this.angleDiff = this.winddir - this.vaneAngle;
            if (this.angleDiff > 360.0f) {
                this.vaneAngle = this.winddir;
            }
            if (this.angleDiff < -360.0f) {
                this.vaneAngle = this.winddir;
            }
            double windSpeedFactor = (Math.pow(windspeed, 2.0) + 5.0) / (Math.pow(windspeed, 2.0) + 12000.0);
            double windSpeedFactor2 = (Math.pow(windspeed, 2.0) + 5.0) / (Math.pow(windspeed, 2.0) + 2000.0);
            double windSpeedFactor3 = (Math.pow(windspeed, 2.0) + 5.0) / (Math.pow(windspeed, 2.0) + 1000.0);
            if (!Double.isNaN(windSpeedFactor2)) {
                this.time_divisor = 1 + (int)(100.0 / (this.WindSpeed + 1.0));
                if (level.getGameTime() % (long)this.time_divisor == 0L) {
                    this.variance2 = (Math.random() - 0.5) * windSpeedFactor * 30.0;
                }
                if (Math.abs(this.angleDiff) > 0.0f) {
                    if (this.angleDiff > 180.0f) {
                        angleDiff2 = 360.0f - this.angleDiff;
                        this.vaneAngle -= (float)(windSpeedFactor2 * angleDiff2 + this.variance2);
                    } else if (this.angleDiff < -180.0f) {
                        angleDiff2 = 360.0f + this.angleDiff;
                        this.vaneAngle += (float)(windSpeedFactor2 * angleDiff2 + this.variance2);
                    } else {
                        this.vaneAngle += (float)((double)this.angleDiff * windSpeedFactor2 + this.variance2);
                    }
                } else {
                    return;
                }
                if (this.vaneAngle % 360.0f == 0.0f) {
                    int divider = (int)((double)this.vaneAngle + 0.5) / 360;
                    this.vaneAngle -= (float)(divider * 360);
                }
                if (this.vaneAngle < 0.0f) {
                    this.vaneAngle = 360.0f - this.vaneAngle;
                }
                if (level.getGameTime() % (long)this.time_divisor == 0L) {
                    this.variance = (Math.random() - 0.5) * windSpeedFactor * 15.0;
                    this.variance3 = (Math.random() - 0.5) * windSpeedFactor * 45.0;
                }
                double swayAngle = Math.toDegrees(Math.atan(Math.pow(windspeed, 2.0) / 50.0));
                if (this.WindSpeed == 0.0) {
                    this.sockAngle2ToRender = 0.0f;
                    this.sockAngle3ToRender = 0.0f;
                    this.sockAngle4ToRender = 0.0f;
                    this.sockAngle5ToRender = 0.0f;
                } else {
                    this.sockAngle2 = (int)(Math.toDegrees(Math.atan(Math.pow(windspeed, 2.0) / 8.0)) + this.variance + this.windUpwardAngle);
                    this.angleDiff2 = this.sockAngle2 - this.sockAngle2ToRender;
                    this.sockAngle2ToRender += (float)(windSpeedFactor3 * (double)this.angleDiff2 + this.variance);
                    this.angleDiff3 = this.sockAngle3 - this.sockAngle3ToRender;
                    this.sockAngle3 = -this.sockAngle2 + (float)((int)(Math.toDegrees(Math.atan(Math.pow(windspeed, 2.0) / 15.0)) + this.variance));
                    this.sockAngle3ToRender += (float)(windSpeedFactor3 * (double)this.angleDiff3 + this.variance);
                    this.angleDiff4 = this.sockAngle4 - this.sockAngle4ToRender;
                    this.sockAngle4 = -this.sockAngle3 - this.sockAngle2 + (float)((int)(Math.toDegrees(Math.atan(Math.pow(windspeed, 2.0) / 40.0)) + this.variance));
                    this.sockAngle4ToRender += (float)(windSpeedFactor3 * (double)this.angleDiff4 + this.variance);
                    this.angleDiff5 = this.sockAngle5 - this.sockAngle5ToRender;
                    this.sockAngle5 = -this.sockAngle4 - this.sockAngle3 - this.sockAngle2 + (float)((int)(Math.toDegrees(Math.atan(Math.pow(windspeed, 2.0) / 70.0)) + this.variance3));
                    this.sockAngle5ToRender += (float)(windSpeedFactor3 * (double)this.angleDiff5 + this.variance3);
                }
            }
        }
    }

    public double OutputWind() {
        return this.WindSpeed;
    }

    public float OutputDir() {
        return this.vaneAngle;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag postag = new CompoundTag();
        this.saveAdditional(postag, registries);
        return postag;
    }

    public void handleUpdateTag(CompoundTag postag, HolderLookup.Provider registries) {
        super.handleUpdateTag(postag, registries);
    }

    public void saveAdditional(CompoundTag postag, HolderLookup.Provider registries) {
        super.saveAdditional(postag, registries);
        postag.putInt("damagedLevel", this.damagedLevel);
        postag.putDouble("damageWSpeed", this.damageWSpeed);
        postag.putInt("Scale", this.Scale);
    }

    public void loadAdditional(@NotNull CompoundTag postag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(postag, registries);
        this.damagedLevel = postag.getInt("damagedLevel");
        this.damageWSpeed = postag.getDouble("damageWSpeed");
        this.Scale = postag.getInt("Scale");
    }
}

