/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.entity.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.elton.windmeter.WindMeter;
import net.elton.windmeter.block.custom.SmallWindTurbineBlock;
import net.elton.windmeter.block.entity.SmallWindTurbineBlockEntity;
import net.elton.windmeter.block.entity.renderer.SmallWindTurbineModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;

public class SmallWindTurbineBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static Map<String, ResourceLocation> resLocMap = Maps.newHashMap();
    private static Map<String, Material> materialMap = Maps.newHashMap();
    protected final SmallWindTurbineModel model = new SmallWindTurbineModel(Minecraft.getInstance().getEntityModels().bakeLayer(SmallWindTurbineModel.LAYER_LOCATION));

    public static Material getMaterial(String path) {
        return materialMap.computeIfAbsent(path, m -> SmallWindTurbineBlockEntityRenderer.createMaterial(path));
    }

    public static Material createMaterial(String path) {
        return new Material(TextureAtlas.LOCATION_BLOCKS, SmallWindTurbineBlockEntityRenderer.getTexture(path));
    }

    public static ResourceLocation getTexture(String path) {
        return resLocMap.computeIfAbsent(path, k -> WindMeter.getPath("textures/block/small_wind_turbine.png"));
    }

    public static void renderModel(Material material, Model model, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        model.renderToBuffer(poseStack, buffer.getBuffer(model.renderType(material.texture())), combinedLightIn, combinedOverlayIn, -1);
    }

    public SmallWindTurbineBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLightIn, int combinedOverlayIn) {
        this.model.mast.getAllParts().forEach(ModelPart::resetPose);
        ModelPart mp = this.model.mast;
        mp.x += 8.0f;
        mp.z += 8.0f;
        mp.xRot += (float)Math.toRadians(180.0);
        mp.yRot += (float)Math.toRadians(180.0);
        mp.y += -24.0f;
        mp = this.model.rotor2;
        mp.x += 0.0f;
        mp.z += 0.0f;
        mp.xRot += 0.0f;
        mp.yRot += 0.0f;
        mp.y += 0.0f;
        mp = this.model.tail_mast;
        mp.x += 0.0f;
        mp.z += 0.0f;
        mp.xRot += 0.0f;
        mp.yRot += 0.0f;
        mp.y += 0.0f;
        if (blockEntity instanceof SmallWindTurbineBlockEntity) {
            SmallWindTurbineBlockEntity smallWindTurbineBlockEntity = (SmallWindTurbineBlockEntity)((Object)blockEntity);
            boolean PlateVisible = false;
            BlockState state = smallWindTurbineBlockEntity.getBlockState();
            AttachFace attachtype = (AttachFace)state.getValue(SmallWindTurbineBlock.ATTACHMENT);
            if (attachtype == AttachFace.FLOOR) {
                PlateVisible = true;
            }
            float lerpAngle = Mth.lerp((float)partialTicks, (float)smallWindTurbineBlockEntity.prevSmoothAngle, (float)smallWindTurbineBlockEntity.smoothAngle);
            this.model.rotor1.zRot = (float)Math.toRadians(lerpAngle);
            this.model.rotor2.zRot = (float)Math.toRadians(lerpAngle);
            this.model.rotor3.zRot = (float)Math.toRadians(lerpAngle);
            this.model.nacelle.yRot = (float)Math.toRadians(smallWindTurbineBlockEntity.nacelleAngle);
            this.model.tail_mast.yRot = (float)Math.toRadians(smallWindTurbineBlockEntity.vaneAngle2);
            this.model.rotor2.visible = !smallWindTurbineBlockEntity.rotorDamage;
            this.model.rotor1.visible = !smallWindTurbineBlockEntity.rotorDamage;
            this.model.rotor3.visible = !smallWindTurbineBlockEntity.rotorDamage;
            this.model.mast2.visible = PlateVisible;
        }
        SmallWindTurbineBlockEntityRenderer.renderModel(SmallWindTurbineBlockEntityRenderer.getMaterial("small_wind_turbine"), (Model)this.model, poseStack, multiBufferSource, combinedLightIn, combinedOverlayIn);
    }
}

