/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.entity.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import net.elton.windmeter.WindMeter;
import net.elton.windmeter.WindmeterClientConfig;
import net.elton.windmeter.block.custom.WeatherDisplayBlock;
import net.elton.windmeter.block.entity.WeatherDisplayBlockEntity;
import net.elton.windmeter.block.entity.renderer.WeatherDisplayModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WeatherDisplayBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final BlockEntityRendererProvider.Context context;
    private static Map<String, ResourceLocation> resLocMap = Maps.newHashMap();
    private static Map<String, Material> materialMap = Maps.newHashMap();
    protected final WeatherDisplayModel model = new WeatherDisplayModel(Minecraft.getInstance().getEntityModels().bakeLayer(WeatherDisplayModel.LAYER_WEATHER_DISPLAY));

    public static Material getMaterial(String path) {
        return materialMap.computeIfAbsent(path, m -> WeatherDisplayBlockEntityRenderer.createMaterial(path));
    }

    public static Material createMaterial(String path) {
        return new Material(TextureAtlas.LOCATION_BLOCKS, WeatherDisplayBlockEntityRenderer.getTexture(path));
    }

    public static ResourceLocation getTexture(String path) {
        return resLocMap.computeIfAbsent(path, k -> WindMeter.getPath("textures/block/weather_display.png"));
    }

    public static void renderModel(Material material, Model model, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        model.renderToBuffer(poseStack, buffer.getBuffer(model.renderType(material.texture())), combinedLightIn, combinedOverlayIn, -1);
    }

    public WeatherDisplayBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.context = ctx;
    }

    public void render(T pBlockEntity, float partialTicks, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pCombinedLightIn, int pCombinedOverlayIn) {
        this.model.base.getAllParts().forEach(ModelPart::resetPose);
        this.model.arrow.getAllParts().forEach(ModelPart::resetPose);
        ModelPart mp = this.model.base;
        mp.x += 8.0f;
        mp.z += 8.0f;
        mp.xRot += (float)Math.toRadians(180.0);
        mp.yRot += (float)Math.toRadians(270.0);
        mp.y += -9.0f;
        mp = this.model.arrow;
        mp.x += 0.0f;
        mp.z += 0.0f;
        mp.xRot += (float)Math.toRadians(180.0);
        mp.yRot += (float)Math.toRadians(180.0);
        mp.y += 0.0f;
        int DisplayRotation = 0;
        if (pBlockEntity instanceof WeatherDisplayBlockEntity) {
            WeatherDisplayBlockEntity weatherDisplayBlockEntity = (WeatherDisplayBlockEntity)((Object)pBlockEntity);
            BlockState state = pBlockEntity.getBlockState();
            Direction direction = (Direction)state.getValue((Property)WeatherDisplayBlock.FACING);
            switch (direction) {
                case NORTH: {
                    DisplayRotation = 90;
                    break;
                }
                case EAST: {
                    DisplayRotation = 0;
                    break;
                }
                case WEST: {
                    DisplayRotation = 180;
                    break;
                }
                default: {
                    DisplayRotation = 270;
                }
            }
            this.model.base.yRot += (float)Math.toRadians(DisplayRotation);
            this.model.arrow.zRot = -((float)Math.toRadians(weatherDisplayBlockEntity.vaneAngleToOutput - 180.0f));
            WeatherDisplayBlockEntityRenderer.renderModel(WeatherDisplayBlockEntityRenderer.getMaterial("weather_display"), (Model)this.model, pPoseStack, pBufferSource, pCombinedLightIn, pCombinedOverlayIn);
            WindmeterClientConfig.WindUnits windUnits = WindmeterClientConfig.windUnits;
            WindmeterClientConfig.TempUnits tempUnits = WindmeterClientConfig.tempUnits;
            String units = "";
            String units2 = "";
            double WindMax = weatherDisplayBlockEntity.WindMax;
            double WindSpeed = weatherDisplayBlockEntity.WindSpeedToOutput;
            float WindDirection = weatherDisplayBlockEntity.vaneAngleToOutput;
            float Temperature = weatherDisplayBlockEntity.temperature;
            float TemperatureMax = weatherDisplayBlockEntity.temperatureMax;
            float TemperatureMin = weatherDisplayBlockEntity.temperatureMin;
            float Dew = weatherDisplayBlockEntity.dew;
            float DewMax = weatherDisplayBlockEntity.dewMax;
            float DewMin = weatherDisplayBlockEntity.dewMin;
            double factor_temp = 0.0;
            double factor_temp2 = 0.0;
            String Risk3 = weatherDisplayBlockEntity.StrRisk3;
            String Risk2 = weatherDisplayBlockEntity.StrRisk2;
            String RiskV = weatherDisplayBlockEntity.StrRiskV;
            int Channel2 = weatherDisplayBlockEntity.channel;
            switch (windUnits) {
                case KMH: {
                    units = "kmh";
                    WindSpeed *= 1.609;
                    WindMax *= 1.609;
                    break;
                }
                case MPS: {
                    units = "m/s";
                    WindSpeed *= 0.44704;
                    WindMax *= 0.44704;
                    break;
                }
                case BEAUFORT: {
                    units = "bft";
                    WindSpeed = Math.pow(WindSpeed * 0.44704 / 0.836, 0.6666666666666666);
                    WindMax = Math.pow(WindMax * 0.44704 / 0.836, 0.6666666666666666);
                    break;
                }
                case KTS: {
                    units = "kts";
                    WindSpeed *= 0.868976;
                    WindMax *= 0.868976;
                    break;
                }
                default: {
                    units = "mph";
                }
            }
            switch (tempUnits) {
                case FAHRENHEIT: {
                    factor_temp = 1.8f;
                    factor_temp2 = 32.0;
                    units2 = "\u00b0F";
                    break;
                }
                case KELVIN: {
                    factor_temp = 1.0;
                    factor_temp2 = 273.15f;
                    units2 = "K";
                    break;
                }
                default: {
                    factor_temp = 1.0;
                    units2 = "\u00b0C";
                }
            }
            Temperature = (float)((double)Temperature * factor_temp + factor_temp2);
            TemperatureMax = (float)((double)TemperatureMax * factor_temp + factor_temp2);
            TemperatureMin = (float)((double)TemperatureMin * factor_temp + factor_temp2);
            Dew = (float)((double)Dew * factor_temp + factor_temp2);
            DewMax = (float)((double)DewMax * factor_temp + factor_temp2);
            DewMin = (float)((double)DewMin * factor_temp + factor_temp2);
            int WindSpeedr = (int)(WindSpeed + 0.5);
            int WindMaxr = (int)(WindMax + 0.5);
            int WindDirectionr = (int)((double)WindDirection + 0.5);
            String strTemp = String.format("%.1f%s", Float.valueOf(Temperature), units2);
            String strTempMax = String.format("%.1f%s", Float.valueOf(TemperatureMax), units2);
            String strTempMin = String.format("%.1f%s", Float.valueOf(TemperatureMin), units2);
            String strDew = String.format("%.1f%s", Float.valueOf(Dew), units2);
            String strDewMax = String.format("%.1f%s", Float.valueOf(DewMax), units2);
            String strDewMin = String.format("%.1f%s", Float.valueOf(DewMin), units2);
            Font wmx = this.context.getFont();
            Font ws = this.context.getFont();
            Font ch = this.context.getFont();
            Font dir = this.context.getFont();
            Font temp = this.context.getFont();
            Font tempMax = this.context.getFont();
            Font tempMin = this.context.getFont();
            Font dew = this.context.getFont();
            Font dewMax = this.context.getFont();
            Font dewMin = this.context.getFont();
            Font fRisk3 = this.context.getFont();
            Font fRisk2 = this.context.getFont();
            Font fRiskV = this.context.getFont();
            Double TextShiftWmx = (double)wmx.width("" + WindMaxr) * 0.008;
            Double TextShiftWs = (double)ws.width("" + WindSpeedr) * 0.008;
            Double TextShiftWd = (double)ws.width("" + WindDirectionr) * 0.007;
            Double TextShiftCh = (double)ch.width("" + Channel2) * 0.007;
            Double TextShiftTemp = (double)temp.width(strTemp) * 0.008;
            Double TextShiftTempMax = (double)tempMax.width(strTempMax) * 0.006;
            Double TextShiftTempMin = (double)tempMin.width(strTempMin) * 0.006;
            Double TextShiftDew = (double)dew.width(strDew) * 0.008;
            Double TextShiftDewMax = (double)dewMax.width(strDewMax) * 0.006;
            Double TextShiftDewMin = (double)dewMin.width(strDewMin) * 0.006;
            Double TextShiftRisk2 = (double)fRisk2.width(Risk2) * 0.006;
            Double TextShiftRisk3 = (double)fRisk3.width(Risk3) * 0.006;
            Double TextShiftRiskV = (double)fRiskV.width(RiskV) * 0.006;
            pPoseStack.pushPose();
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(DisplayRotation + 90)));
            switch (DisplayRotation) {
                case 270: {
                    pPoseStack.translate(0.75 - TextShiftWmx, (double)0.695f, (double)0.07f);
                    break;
                }
                case 90: {
                    pPoseStack.translate(-0.25 - TextShiftWmx, (double)0.695f, (double)-0.93f);
                    break;
                }
                case 180: {
                    pPoseStack.translate(0.75 - TextShiftWmx, (double)0.695f, (double)-0.93f);
                    break;
                }
                default: {
                    pPoseStack.translate(-0.25 - TextShiftWmx, (double)0.695f, (double)0.07f);
                }
            }
            pPoseStack.scale(0.008f, -0.008f, 0.008f);
            wmx.drawInBatch(WindMaxr + " " + units, 0.0f, 0.0f, 0, false, pPoseStack.last().pose(), pBufferSource, Font.DisplayMode.NORMAL, 0, 255);
            pPoseStack.popPose();
            pPoseStack.pushPose();
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(DisplayRotation + 90)));
            switch (DisplayRotation) {
                case 270: {
                    pPoseStack.translate(0.75 - TextShiftWs, (double)0.89f, (double)0.07f);
                    break;
                }
                case 90: {
                    pPoseStack.translate(-0.25 - TextShiftWs, (double)0.89f, (double)-0.93f);
                    break;
                }
                case 180: {
                    pPoseStack.translate(0.75 - TextShiftWs, (double)0.89f, (double)-0.93f);
                    break;
                }
                default: {
                    pPoseStack.translate(-0.25 - TextShiftWs, (double)0.89f, (double)0.07f);
                }
            }
            pPoseStack.scale(0.008f, -0.008f, 0.008f);
            ws.drawInBatch(WindSpeedr + " " + units, 0.0f, 0.0f, 0, false, pPoseStack.last().pose(), pBufferSource, Font.DisplayMode.NORMAL, 0, 255);
            pPoseStack.popPose();
            pPoseStack.pushPose();
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(DisplayRotation + 90)));
            switch (DisplayRotation) {
                case 270: {
                    pPoseStack.translate((double)0.31f - TextShiftWd, (double)0.78f, (double)0.07f);
                    break;
                }
                case 90: {
                    pPoseStack.translate((double)-0.69f - TextShiftWd, (double)0.78f, (double)-0.93f);
                    break;
                }
                case 180: {
                    pPoseStack.translate((double)0.31f - TextShiftWd, (double)0.78f, (double)-0.93f);
                    break;
                }
                default: {
                    pPoseStack.translate((double)-0.69f - TextShiftWd, (double)0.78f, (double)0.07f);
                }
            }
            pPoseStack.scale(0.007f, -0.007f, 0.007f);
            dir.drawInBatch(WindDirectionr + "\u00b0", 0.0f, 0.0f, 0, false, pPoseStack.last().pose(), pBufferSource, Font.DisplayMode.NORMAL, 0, 255);
            pPoseStack.popPose();
            pPoseStack.pushPose();
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(DisplayRotation + 90)));
            switch (DisplayRotation) {
                case 270: {
                    pPoseStack.translate((double)0.96f - TextShiftCh, (double)0.59f, (double)0.07f);
                    break;
                }
                case 90: {
                    pPoseStack.translate((double)-0.04f - TextShiftCh, (double)0.59f, (double)-0.93f);
                    break;
                }
                case 180: {
                    pPoseStack.translate((double)0.96f - TextShiftCh, (double)0.59f, (double)-0.93f);
                    break;
                }
                default: {
                    pPoseStack.translate((double)-0.04f - TextShiftCh, (double)0.59f, (double)0.07f);
                }
            }
            pPoseStack.scale(0.007f, -0.007f, 0.007f);
            ch.drawInBatch("" + Channel2, 0.0f, 0.0f, 0, false, pPoseStack.last().pose(), pBufferSource, Font.DisplayMode.NORMAL, 0, 255);
            pPoseStack.popPose();
            pPoseStack.pushPose();
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(DisplayRotation + 90)));
            switch (DisplayRotation) {
                case 270: {
                    pPoseStack.translate((double)0.53f - TextShiftTemp, (double)0.49f, (double)0.07f);
                    break;
                }
                case 90: {
                    pPoseStack.translate((double)-0.47f - TextShiftTemp, (double)0.49f, (double)-0.93f);
                    break;
                }
                case 180: {
                    pPoseStack.translate((double)0.53f - TextShiftTemp, (double)0.49f, (double)-0.93f);
                    break;
                }
                default: {
                    pPoseStack.translate((double)-0.47f - TextShiftTemp, (double)0.49f, (double)0.07f);
                }
            }
            pPoseStack.scale(0.008f, -0.008f, 0.008f);
            temp.drawInBatch(strTemp, 0.0f, 0.0f, 0, false, pPoseStack.last().pose(), pBufferSource, Font.DisplayMode.NORMAL, 0, 255);
            pPoseStack.popPose();
            pPoseStack.pushPose();
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(DisplayRotation + 90)));
            switch (DisplayRotation) {
                case 270: {
                    pPoseStack.translate((double)0.96f - TextShiftTempMax, (double)0.513f, (double)0.07f);
                    break;
                }
                case 90: {
                    pPoseStack.translate((double)-0.04f - TextShiftTempMax, (double)0.513f, (double)-0.93f);
                    break;
                }
                case 180: {
                    pPoseStack.translate((double)0.96f - TextShiftTempMax, (double)0.513f, (double)-0.93f);
                    break;
                }
                default: {
                    pPoseStack.translate((double)-0.04f - TextShiftTempMax, (double)0.513f, (double)0.07f);
                }
            }
            pPoseStack.scale(0.006f, -0.006f, 0.006f);
            tempMax.drawInBatch(strTempMax, 0.0f, 0.0f, 0, false, pPoseStack.last().pose(), pBufferSource, Font.DisplayMode.NORMAL, 0, 255);
            pPoseStack.popPose();
            pPoseStack.pushPose();
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(DisplayRotation + 90)));
            switch (DisplayRotation) {
                case 270: {
                    pPoseStack.translate((double)0.96f - TextShiftTempMin, (double)0.454f, (double)0.07f);
                    break;
                }
                case 90: {
                    pPoseStack.translate((double)-0.04f - TextShiftTempMin, (double)0.454f, (double)-0.93f);
                    break;
                }
                case 180: {
                    pPoseStack.translate((double)0.96f - TextShiftTempMin, (double)0.454f, (double)-0.93f);
                    break;
                }
                default: {
                    pPoseStack.translate((double)-0.04f - TextShiftTempMin, (double)0.454f, (double)0.07f);
                }
            }
            pPoseStack.scale(0.006f, -0.006f, 0.006f);
            tempMin.drawInBatch(strTempMin, 0.0f, 0.0f, 0, false, pPoseStack.last().pose(), pBufferSource, Font.DisplayMode.NORMAL, 0, 255);
            pPoseStack.popPose();
            pPoseStack.pushPose();
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(DisplayRotation + 90)));
            switch (DisplayRotation) {
                case 270: {
                    pPoseStack.translate((double)0.53f - TextShiftDew, (double)0.36f, (double)0.07f);
                    break;
                }
                case 90: {
                    pPoseStack.translate((double)-0.47f - TextShiftDew, (double)0.36f, (double)-0.93f);
                    break;
                }
                case 180: {
                    pPoseStack.translate((double)0.53f - TextShiftDew, (double)0.36f, (double)-0.93f);
                    break;
                }
                default: {
                    pPoseStack.translate((double)-0.47f - TextShiftDew, (double)0.36f, (double)0.07f);
                }
            }
            pPoseStack.scale(0.008f, -0.008f, 0.008f);
            dew.drawInBatch(strDew, 0.0f, 0.0f, 0, false, pPoseStack.last().pose(), pBufferSource, Font.DisplayMode.NORMAL, 0, 255);
            pPoseStack.popPose();
            pPoseStack.pushPose();
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(DisplayRotation + 90)));
            switch (DisplayRotation) {
                case 270: {
                    pPoseStack.translate((double)0.96f - TextShiftDewMax, (double)0.383f, (double)0.07f);
                    break;
                }
                case 90: {
                    pPoseStack.translate((double)-0.04f - TextShiftDewMax, (double)0.383f, (double)-0.93f);
                    break;
                }
                case 180: {
                    pPoseStack.translate((double)0.96f - TextShiftDewMax, (double)0.383f, (double)-0.93f);
                    break;
                }
                default: {
                    pPoseStack.translate((double)-0.04f - TextShiftDewMax, (double)0.383f, (double)0.07f);
                }
            }
            pPoseStack.scale(0.006f, -0.006f, 0.006f);
            dewMax.drawInBatch(strDewMax, 0.0f, 0.0f, 0, false, pPoseStack.last().pose(), pBufferSource, Font.DisplayMode.NORMAL, 0, 255);
            pPoseStack.popPose();
            pPoseStack.pushPose();
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(DisplayRotation + 90)));
            switch (DisplayRotation) {
                case 270: {
                    pPoseStack.translate((double)0.96f - TextShiftDewMin, (double)0.324f, (double)0.07f);
                    break;
                }
                case 90: {
                    pPoseStack.translate((double)-0.04f - TextShiftDewMin, (double)0.324f, (double)-0.93f);
                    break;
                }
                case 180: {
                    pPoseStack.translate((double)0.96f - TextShiftDewMin, (double)0.324f, (double)-0.93f);
                    break;
                }
                default: {
                    pPoseStack.translate((double)-0.04f - TextShiftDewMin, (double)0.324f, (double)0.07f);
                }
            }
            pPoseStack.scale(0.006f, -0.006f, 0.006f);
            dewMin.drawInBatch(strDewMin, 0.0f, 0.0f, 0, false, pPoseStack.last().pose(), pBufferSource, Font.DisplayMode.NORMAL, 0, 255);
            pPoseStack.popPose();
            pPoseStack.pushPose();
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(DisplayRotation + 90)));
            switch (DisplayRotation) {
                case 270: {
                    pPoseStack.translate(0.5 - TextShiftRiskV, (double)0.2f, (double)0.07f);
                    break;
                }
                case 90: {
                    pPoseStack.translate(-0.5 - TextShiftRiskV, (double)0.2f, (double)-0.93f);
                    break;
                }
                case 180: {
                    pPoseStack.translate(0.5 - TextShiftRiskV, (double)0.2f, (double)-0.93f);
                    break;
                }
                default: {
                    pPoseStack.translate(-0.5 - TextShiftRiskV, (double)0.2f, (double)0.07f);
                }
            }
            pPoseStack.scale(0.006f, -0.006f, 0.006f);
            fRiskV.drawInBatch(RiskV, 0.0f, 0.0f, 0, false, pPoseStack.last().pose(), pBufferSource, Font.DisplayMode.NORMAL, 0, 255);
            pPoseStack.popPose();
            pPoseStack.pushPose();
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(DisplayRotation + 90)));
            switch (DisplayRotation) {
                case 270: {
                    pPoseStack.translate(0.5 - TextShiftRisk2, (double)0.145f, (double)0.07f);
                    break;
                }
                case 90: {
                    pPoseStack.translate(-0.5 - TextShiftRisk2, (double)0.145f, (double)-0.93f);
                    break;
                }
                case 180: {
                    pPoseStack.translate(0.5 - TextShiftRisk2, (double)0.145f, (double)-0.93f);
                    break;
                }
                default: {
                    pPoseStack.translate(-0.5 - TextShiftRisk2, (double)0.145f, (double)0.07f);
                }
            }
            pPoseStack.scale(0.006f, -0.006f, 0.006f);
            fRisk2.drawInBatch(Risk2, 0.0f, 0.0f, 0, false, pPoseStack.last().pose(), pBufferSource, Font.DisplayMode.NORMAL, 0, 255);
            pPoseStack.popPose();
            pPoseStack.pushPose();
            pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(DisplayRotation + 90)));
            switch (DisplayRotation) {
                case 270: {
                    pPoseStack.translate(0.5 - TextShiftRisk3, (double)0.09f, (double)0.07f);
                    break;
                }
                case 90: {
                    pPoseStack.translate(-0.5 - TextShiftRisk3, (double)0.09f, (double)-0.93f);
                    break;
                }
                case 180: {
                    pPoseStack.translate(0.5 - TextShiftRisk3, (double)0.09f, (double)-0.93f);
                    break;
                }
                default: {
                    pPoseStack.translate(-0.5 - TextShiftRisk3, (double)0.09f, (double)0.07f);
                }
            }
            pPoseStack.scale(0.006f, -0.006f, 0.006f);
            fRisk3.drawInBatch(Risk3, 0.0f, 0.0f, 0, false, pPoseStack.last().pose(), pBufferSource, Font.DisplayMode.NORMAL, 0, 255);
            pPoseStack.popPose();
        }
    }
}

